/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.ResourcePattern;
import org.apache.doris.analysis.TablePattern;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PaloAuth;
import org.apache.doris.mysql.privilege.PaloRole;
import org.apache.doris.mysql.privilege.PrivBitSet;

public class RoleManager
implements Writable {
    private Map<String, PaloRole> roles = Maps.newHashMap();

    public RoleManager() {
        this.roles.put(PaloRole.OPERATOR.getRoleName(), PaloRole.OPERATOR);
        this.roles.put(PaloRole.ADMIN.getRoleName(), PaloRole.ADMIN);
    }

    public PaloRole getRole(String role) {
        return this.roles.get(role);
    }

    public PaloRole addRole(PaloRole newRole, boolean errOnExist) throws DdlException {
        PaloRole existingRole = this.roles.get(newRole.getRoleName());
        if (existingRole != null) {
            if (errOnExist) {
                throw new DdlException("Role " + newRole + " already exists");
            }
            existingRole.merge(newRole);
            return existingRole;
        }
        this.roles.put(newRole.getRoleName(), newRole);
        return newRole;
    }

    public void dropRole(String qualifiedRole, boolean errOnNonExist) throws DdlException {
        if (!this.roles.containsKey(qualifiedRole)) {
            if (errOnNonExist) {
                throw new DdlException("Role " + qualifiedRole + " does not exist");
            }
            return;
        }
        this.roles.remove(qualifiedRole);
    }

    public PaloRole revokePrivs(String role, TablePattern tblPattern, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        PaloRole existingRole = this.roles.get(role);
        if (existingRole == null) {
            if (errOnNonExist) {
                throw new DdlException("Role " + role + " does not exist");
            }
            return null;
        }
        Map<TablePattern, PrivBitSet> map = existingRole.getTblPatternToPrivs();
        PrivBitSet existingPriv = map.get(tblPattern);
        if (existingPriv == null) {
            if (errOnNonExist) {
                throw new DdlException(tblPattern + " does not exist in role " + role);
            }
            return null;
        }
        existingPriv.remove(privs);
        return existingRole;
    }

    public PaloRole revokePrivs(String role, ResourcePattern resourcePattern, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        PaloRole existingRole = this.roles.get(role);
        if (existingRole == null) {
            if (errOnNonExist) {
                throw new DdlException("Role " + role + " does not exist");
            }
            return null;
        }
        Map<ResourcePattern, PrivBitSet> map = existingRole.getResourcePatternToPrivs();
        PrivBitSet existingPriv = map.get(resourcePattern);
        if (existingPriv == null) {
            if (errOnNonExist) {
                throw new DdlException(resourcePattern + " does not exist in role " + role);
            }
            return null;
        }
        existingPriv.remove(privs);
        return existingRole;
    }

    public void dropUser(UserIdentity userIdentity) {
        for (PaloRole role : this.roles.values()) {
            role.dropUser(userIdentity);
        }
    }

    public void getRoleInfo(List<List<String>> results) {
        for (PaloRole role : this.roles.values()) {
            ArrayList info = Lists.newArrayList();
            info.add(role.getRoleName());
            info.add(Joiner.on((String)", ").join(role.getUsers()));
            boolean hasGlobal = false;
            for (Map.Entry<TablePattern, PrivBitSet> entry : role.getTblPatternToPrivs().entrySet()) {
                if (entry.getKey().getPrivLevel() != PaloAuth.PrivLevel.GLOBAL) continue;
                hasGlobal = true;
                info.add(entry.getValue().toString());
                break;
            }
            if (!hasGlobal) {
                info.add(FeConstants.null_string);
            }
            ArrayList tmp = Lists.newArrayList();
            for (Map.Entry<TablePattern, PrivBitSet> entry : role.getTblPatternToPrivs().entrySet()) {
                if (entry.getKey().getPrivLevel() != PaloAuth.PrivLevel.DATABASE) continue;
                tmp.add(entry.getKey().toString() + ": " + entry.getValue().toString());
            }
            if (tmp.isEmpty()) {
                info.add(FeConstants.null_string);
            } else {
                info.add(Joiner.on((String)"; ").join((Iterable)tmp));
            }
            tmp.clear();
            for (Map.Entry<TablePattern, PrivBitSet> entry : role.getTblPatternToPrivs().entrySet()) {
                if (entry.getKey().getPrivLevel() != PaloAuth.PrivLevel.TABLE) continue;
                tmp.add(entry.getKey().toString() + ": " + entry.getValue().toString());
            }
            if (tmp.isEmpty()) {
                info.add(FeConstants.null_string);
            } else {
                info.add(Joiner.on((String)"; ").join((Iterable)tmp));
            }
            tmp.clear();
            for (Map.Entry<Object, PrivBitSet> entry : role.getResourcePatternToPrivs().entrySet()) {
                if (((ResourcePattern)entry.getKey()).getPrivLevel() != PaloAuth.PrivLevel.RESOURCE) continue;
                tmp.add(((ResourcePattern)entry.getKey()).toString() + ": " + entry.getValue().toString());
            }
            if (tmp.isEmpty()) {
                info.add(FeConstants.null_string);
            } else {
                info.add(Joiner.on((String)"; ").join((Iterable)tmp));
            }
            results.add(info);
        }
    }

    public static RoleManager read(DataInput in) throws IOException {
        RoleManager roleManager = new RoleManager();
        roleManager.readFields(in);
        return roleManager;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.roles.size() - 2);
        for (PaloRole role : this.roles.values()) {
            if (role == PaloRole.ADMIN || role == PaloRole.OPERATOR) continue;
            role.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            PaloRole role = PaloRole.read(in);
            this.roles.put(role.getRoleName(), role);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Roles: ");
        for (PaloRole role : this.roles.values()) {
            sb.append(role).append("\n");
        }
        return sb.toString();
    }
}

