/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;
import org.apache.doris.mysql.privilege.PrivTable;
import org.apache.doris.mysql.privilege.ResourcePrivEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePrivTable
extends PrivTable {
    private static final Logger LOG = LogManager.getLogger(ResourcePrivTable.class);

    public void getPrivs(UserIdentity currentUser, String resourceName, PrivBitSet savedPrivs) {
        PrivEntry matchedEntry = null;
        for (PrivEntry entry : this.entries) {
            ResourcePrivEntry resourcePrivEntry = (ResourcePrivEntry)entry;
            if (!resourcePrivEntry.match(currentUser, true) || !resourcePrivEntry.getResourcePattern().match(resourceName)) continue;
            matchedEntry = resourcePrivEntry;
            break;
        }
        if (matchedEntry == null) {
            return;
        }
        savedPrivs.or(matchedEntry.getPrivSet());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = ResourcePrivTable.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        super.write(out);
    }
}

