/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;

public class ResourcePrivEntry
extends PrivEntry {
    protected static final String ANY_RESOURCE = "*";
    protected PatternMatcher resourcePattern;
    protected String origResource;
    protected boolean isAnyResource;

    protected ResourcePrivEntry() {
    }

    protected ResourcePrivEntry(PatternMatcher hostPattern, String origHost, PatternMatcher resourcePattern, String origResource, PatternMatcher userPattern, String user, boolean isDomain, PrivBitSet privSet) {
        super(hostPattern, origHost, userPattern, user, isDomain, privSet);
        this.resourcePattern = resourcePattern;
        this.origResource = origResource;
        if (origResource.equals(ANY_RESOURCE)) {
            this.isAnyResource = true;
        }
    }

    public static ResourcePrivEntry create(String host, String resourceName, String user, boolean isDomain, PrivBitSet privs) throws AnalysisException {
        PatternMatcher hostPattern = PatternMatcher.createMysqlPattern(host, CaseSensibility.HOST.getCaseSensibility());
        PatternMatcher resourcePattern = PatternMatcher.createMysqlPattern(resourceName.equals(ANY_RESOURCE) ? "%" : resourceName, CaseSensibility.RESOURCE.getCaseSensibility());
        PatternMatcher userPattern = PatternMatcher.createMysqlPattern(user, CaseSensibility.USER.getCaseSensibility());
        if (privs.containsNodePriv() || privs.containsDbTablePriv()) {
            throw new AnalysisException("Resource privilege can not contains node or db table privileges: " + privs);
        }
        return new ResourcePrivEntry(hostPattern, host, resourcePattern, resourceName, userPattern, user, isDomain, privs);
    }

    public PatternMatcher getResourcePattern() {
        return this.resourcePattern;
    }

    public String getOrigResource() {
        return this.origResource;
    }

    @Override
    public int compareTo(PrivEntry other) {
        if (!(other instanceof ResourcePrivEntry)) {
            throw new ClassCastException("cannot cast " + other.getClass().toString() + " to " + this.getClass());
        }
        ResourcePrivEntry otherEntry = (ResourcePrivEntry)other;
        int res = this.origHost.compareTo(otherEntry.origHost);
        if (res != 0) {
            return -res;
        }
        res = this.origResource.compareTo(otherEntry.origResource);
        if (res != 0) {
            return -res;
        }
        return -this.origUser.compareTo(otherEntry.origUser);
    }

    @Override
    public boolean keyMatch(PrivEntry other) {
        if (!(other instanceof ResourcePrivEntry)) {
            return false;
        }
        ResourcePrivEntry otherEntry = (ResourcePrivEntry)other;
        return this.origHost.equals(otherEntry.origHost) && this.origUser.equals(otherEntry.origUser) && this.origResource.equals(otherEntry.origResource) && this.isDomain == otherEntry.isDomain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("resource priv. host: ").append(this.origHost).append(", resource: ").append(this.origResource);
        sb.append(", user: ").append(this.origUser);
        sb.append(", priv: ").append(this.privSet).append(", set by resolver: ").append(this.isSetByDomainResolver);
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = ResourcePrivEntry.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.origResource);
        this.isClassNameWrote = false;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.origResource = Text.readString((DataInput)in);
        try {
            this.resourcePattern = PatternMatcher.createMysqlPattern(this.origResource, CaseSensibility.RESOURCE.getCaseSensibility());
        }
        catch (AnalysisException e) {
            throw new IOException(e);
        }
        this.isAnyResource = this.origResource.equals(ANY_RESOURCE);
    }
}

