/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PrivTable
implements Writable {
    private static final Logger LOG = LogManager.getLogger(PrivTable.class);
    protected List<PrivEntry> entries = Lists.newArrayList();
    protected boolean isClassNameWrote = false;

    public PrivEntry addEntry(PrivEntry newEntry, boolean errOnExist, boolean errOnNonExist) throws DdlException {
        PrivEntry existingEntry = this.getExistingEntry(newEntry);
        if (existingEntry == null) {
            if (errOnNonExist) {
                throw new DdlException("User " + newEntry.getUserIdent() + " does not exist");
            }
            this.entries.add(newEntry);
            Collections.sort(this.entries);
            LOG.info("add priv entry: {}", (Object)newEntry);
            return newEntry;
        }
        if (errOnExist) {
            throw new DdlException("User already exist");
        }
        this.checkOperationAllowed(existingEntry, newEntry, "ADD ENTRY");
        if (existingEntry.isSetByDomainResolver()) {
            existingEntry.setPrivSet(newEntry.getPrivSet());
            existingEntry.setSetByDomainResolver(newEntry.isSetByDomainResolver());
            LOG.debug("reset priv entry: {}", (Object)existingEntry);
        } else if (!newEntry.isSetByDomainResolver()) {
            this.mergePriv(existingEntry, newEntry);
            existingEntry.setSetByDomainResolver(false);
            LOG.debug("merge priv entry: {}", (Object)existingEntry);
        }
        return existingEntry;
    }

    public List<PrivEntry> getEntries() {
        return this.entries;
    }

    public void dropEntry(PrivEntry entry) {
        Iterator<PrivEntry> iter = this.entries.iterator();
        while (iter.hasNext()) {
            PrivEntry privEntry = iter.next();
            if (!privEntry.keyMatch(entry)) continue;
            iter.remove();
            LOG.info("drop priv entry: {}", (Object)privEntry);
            break;
        }
    }

    public void clearEntriesSetByResolver() {
        Iterator<PrivEntry> iter = this.entries.iterator();
        while (iter.hasNext()) {
            PrivEntry privEntry = iter.next();
            if (!privEntry.isSetByDomainResolver()) continue;
            iter.remove();
            LOG.info("drop priv entry set by resolver: {}", (Object)privEntry);
        }
    }

    public void dropUser(UserIdentity userIdentity) {
        Iterator<PrivEntry> iter = this.entries.iterator();
        while (iter.hasNext()) {
            PrivEntry privEntry = iter.next();
            if (!privEntry.match(userIdentity, true) || privEntry.isSetByDomainResolver()) continue;
            iter.remove();
            LOG.info("drop entry: {}", (Object)privEntry);
        }
    }

    public void revoke(PrivEntry entry, boolean errOnNonExist, boolean deleteEntryWhenEmpty) throws DdlException {
        PrivEntry existingEntry = this.getExistingEntry(entry);
        if (existingEntry == null) {
            if (errOnNonExist) {
                ErrorReport.reportDdlException(ErrorCode.ERR_NONEXISTING_GRANT, entry.getOrigUser(), entry.getOrigHost());
            }
            return;
        }
        this.checkOperationAllowed(existingEntry, entry, "REVOKE");
        PrivBitSet tmp = existingEntry.getPrivSet().copy();
        tmp.and(entry.getPrivSet());
        if (tmp.isEmpty()) {
            if (errOnNonExist) {
                ErrorReport.reportDdlException(ErrorCode.ERR_NONEXISTING_GRANT, entry.getOrigUser(), entry.getOrigHost());
            }
            return;
        }
        LOG.debug("before revoke: {}, privs to be revoked: {}", (Object)existingEntry.getPrivSet(), (Object)entry.getPrivSet());
        tmp = existingEntry.getPrivSet().copy();
        tmp.xor(entry.getPrivSet());
        existingEntry.getPrivSet().and(tmp);
        LOG.debug("after revoke: {}", (Object)existingEntry);
        if (existingEntry.getPrivSet().isEmpty() && deleteEntryWhenEmpty) {
            this.dropEntry(existingEntry);
        }
    }

    protected void checkOperationAllowed(PrivEntry existingEntry, PrivEntry newEntry, String op) throws DdlException {
        if (!existingEntry.isSetByDomainResolver() && newEntry.isSetByDomainResolver()) {
            throw new DdlException("the existing entry is NOT set by resolver: " + existingEntry + ", can not be set by resolver " + newEntry + ", op: " + op);
        }
    }

    protected PrivEntry getExistingEntry(PrivEntry entry) {
        for (PrivEntry existingEntry : this.entries) {
            if (!existingEntry.keyMatch(entry)) continue;
            return existingEntry;
        }
        return null;
    }

    private void mergePriv(PrivEntry first, PrivEntry second) {
        first.getPrivSet().or(second.getPrivSet());
        first.setSetByDomainResolver(first.isSetByDomainResolver() || second.isSetByDomainResolver());
    }

    public boolean doesUsernameExist(String qualifiedUsername) {
        for (PrivEntry entry : this.entries) {
            if (!entry.getOrigUser().equals(qualifiedUsername)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.entries.clear();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public static PrivTable read(DataInput in) throws IOException {
        String className = Text.readString((DataInput)in);
        if (className.startsWith("com.baidu.palo")) {
            className = className.replaceFirst("com.baidu.palo", "org.apache.doris");
        }
        PrivTable privTable = null;
        try {
            Class<?> derivedClass = Class.forName(className);
            privTable = (PrivTable)derivedClass.newInstance();
            Class[] paramTypes = new Class[]{DataInput.class};
            Method readMethod = derivedClass.getMethod("readFields", paramTypes);
            Object[] params = new Object[]{in};
            readMethod.invoke((Object)privTable, params);
            return privTable;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException("failed read PrivTable", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        for (PrivEntry privEntry : this.entries) {
            sb.append(privEntry).append("\n");
        }
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = PrivTable.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        out.writeInt(this.entries.size());
        for (PrivEntry privEntry : this.entries) {
            privEntry.write(out);
        }
        this.isClassNameWrote = false;
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            PrivEntry entry = PrivEntry.read(in);
            this.entries.add(entry);
        }
        Collections.sort(this.entries);
    }
}

