/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivBitSet;

public class PrivPredicate {
    public static final PrivPredicate SHOW = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.SELECT_PRIV, PaloPrivilege.LOAD_PRIV, PaloPrivilege.ALTER_PRIV, PaloPrivilege.CREATE_PRIV, PaloPrivilege.DROP_PRIV, PaloPrivilege.USAGE_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate GRANT = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.GRANT_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate ADMIN = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate LOAD = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.LOAD_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate ALTER = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.ALTER_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate CREATE = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.CREATE_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate DROP = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.DROP_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate SELECT = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.SELECT_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate OPERATOR = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.NODE_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate USAGE = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ADMIN_PRIV, PaloPrivilege.USAGE_PRIV), CompoundPredicate.Operator.OR);
    public static final PrivPredicate ALL = PrivPredicate.of(PrivBitSet.of(PaloPrivilege.NODE_PRIV, PaloPrivilege.ADMIN_PRIV, PaloPrivilege.SELECT_PRIV, PaloPrivilege.LOAD_PRIV, PaloPrivilege.ALTER_PRIV, PaloPrivilege.CREATE_PRIV, PaloPrivilege.DROP_PRIV, PaloPrivilege.USAGE_PRIV), CompoundPredicate.Operator.OR);
    private PrivBitSet privs;
    private CompoundPredicate.Operator op;

    private PrivPredicate(PrivBitSet privs, CompoundPredicate.Operator op) {
        this.privs = privs;
        this.op = op;
    }

    public static PrivPredicate of(PrivBitSet privs, CompoundPredicate.Operator op) {
        PrivPredicate predicate = new PrivPredicate(privs, op);
        return predicate;
    }

    public PrivBitSet getPrivs() {
        return this.privs;
    }

    public CompoundPredicate.Operator getOp() {
        return this.op;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("priv predicate: ").append((Object)this.op).append(", ").append(this.privs);
        return sb.toString();
    }
}

