/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.NotImplementedException;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PrivBitSet;

public abstract class PrivEntry
implements Comparable<PrivEntry>,
Writable {
    protected static final String ANY_HOST = "%";
    protected static final String ANY_USER = "%";
    protected PatternMatcher hostPattern;
    protected String origHost;
    protected boolean isAnyHost = false;
    protected PatternMatcher userPattern;
    protected String origUser;
    protected boolean isAnyUser = false;
    protected PrivBitSet privSet;
    protected boolean isSetByDomainResolver = false;
    protected boolean isDomain = false;
    protected boolean isClassNameWrote = false;
    private UserIdentity userIdentity;

    protected PrivEntry() {
    }

    protected PrivEntry(PatternMatcher hostPattern, String origHost, PatternMatcher userPattern, String origUser, boolean isDomain, PrivBitSet privSet) {
        this.hostPattern = hostPattern;
        this.origHost = origHost;
        if (origHost.equals("%")) {
            this.isAnyHost = true;
        }
        this.userPattern = userPattern;
        this.origUser = origUser;
        if (origUser.equals("%")) {
            this.isAnyUser = true;
        }
        this.isDomain = isDomain;
        this.privSet = privSet;
        this.userIdentity = isDomain ? UserIdentity.createAnalyzedUserIdentWithDomain(origUser, origHost) : UserIdentity.createAnalyzedUserIdentWithIp(origUser, origHost);
    }

    public PatternMatcher getHostPattern() {
        return this.hostPattern;
    }

    public String getOrigHost() {
        return this.origHost;
    }

    public boolean isAnyHost() {
        return this.isAnyHost;
    }

    public PatternMatcher getUserPattern() {
        return this.userPattern;
    }

    public String getOrigUser() {
        return this.origUser;
    }

    public boolean isAnyUser() {
        return this.isAnyUser;
    }

    public PrivBitSet getPrivSet() {
        return this.privSet;
    }

    public void setPrivSet(PrivBitSet privSet) {
        this.privSet = privSet;
    }

    public boolean isSetByDomainResolver() {
        return this.isSetByDomainResolver;
    }

    public void setSetByDomainResolver(boolean isSetByDomainResolver) {
        this.isSetByDomainResolver = isSetByDomainResolver;
    }

    public UserIdentity getUserIdent() {
        return this.userIdentity;
    }

    public boolean match(UserIdentity userIdent, boolean exactMatch) {
        if (exactMatch) {
            return this.origUser.equals(userIdent.getQualifiedUser()) && this.origHost.equals(userIdent.getHost());
        }
        return this.origUser.equals(userIdent.getQualifiedUser()) && this.hostPattern.match(userIdent.getHost());
    }

    public abstract boolean keyMatch(PrivEntry var1);

    public static PrivEntry read(DataInput in) throws IOException {
        String className = Text.readString((DataInput)in);
        if (className.startsWith("com.baidu.palo")) {
            className = className.replaceFirst("com.baidu.palo", "org.apache.doris");
        }
        PrivEntry privEntry = null;
        try {
            Class<?> derivedClass = Class.forName(className);
            privEntry = (PrivEntry)derivedClass.newInstance();
            Class[] paramTypes = new Class[]{DataInput.class};
            Method readMethod = derivedClass.getMethod("readFields", paramTypes);
            Object[] params = new Object[]{in};
            readMethod.invoke((Object)privEntry, params);
            return privEntry;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException("failed read PrivEntry", e);
        }
    }

    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = PrivEntry.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        Text.writeString((DataOutput)out, (String)this.origHost);
        Text.writeString((DataOutput)out, (String)this.origUser);
        this.privSet.write(out);
        out.writeBoolean(this.isSetByDomainResolver);
        out.writeBoolean(this.isDomain);
        this.isClassNameWrote = false;
    }

    public void readFields(DataInput in) throws IOException {
        this.origHost = Text.readString((DataInput)in);
        try {
            this.hostPattern = PatternMatcher.createMysqlPattern(this.origHost, CaseSensibility.HOST.getCaseSensibility());
        }
        catch (AnalysisException e) {
            throw new IOException(e);
        }
        this.isAnyHost = this.origHost.equals("%");
        this.origUser = Text.readString((DataInput)in);
        try {
            this.userPattern = PatternMatcher.createMysqlPattern(this.origUser, CaseSensibility.USER.getCaseSensibility());
        }
        catch (AnalysisException e) {
            throw new IOException(e);
        }
        this.isAnyUser = this.origUser.equals("%");
        this.privSet = PrivBitSet.read(in);
        this.isSetByDomainResolver = in.readBoolean();
        this.isDomain = in.readBoolean();
        this.userIdentity = this.isDomain ? UserIdentity.createAnalyzedUserIdentWithDomain(this.origUser, this.origHost) : UserIdentity.createAnalyzedUserIdentWithIp(this.origUser, this.origHost);
    }

    @Override
    public int compareTo(PrivEntry o) {
        throw new NotImplementedException();
    }
}

