/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivPredicate;

public class PrivBitSet
implements Writable {
    private long set = 0L;

    public void set(int index) {
        Preconditions.checkState((index < PaloPrivilege.privileges.length ? 1 : 0) != 0, (Object)index);
        this.set |= (long)(1 << index);
    }

    public void unset(int index) {
        Preconditions.checkState((index < PaloPrivilege.privileges.length ? 1 : 0) != 0, (Object)index);
        this.set &= this.set ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean get(int index) {
        Preconditions.checkState((index < PaloPrivilege.privileges.length ? 1 : 0) != 0, (Object)index);
        return (this.set & (long)(1 << index)) > 0L;
    }

    public void or(PrivBitSet other) {
        this.set |= other.set;
    }

    public void and(PrivBitSet other) {
        this.set &= other.set;
    }

    public void xor(PrivBitSet other) {
        this.set ^= other.set;
    }

    public void remove(PrivBitSet privs) {
        PrivBitSet tmp = this.copy();
        tmp.xor(privs);
        this.and(tmp);
    }

    public boolean isEmpty() {
        return this.set == 0L;
    }

    public boolean satisfy(PrivPredicate wantPrivs) {
        if (wantPrivs.getOp() == CompoundPredicate.Operator.AND) {
            return (this.set & wantPrivs.getPrivs().set) == wantPrivs.getPrivs().set;
        }
        return (this.set & wantPrivs.getPrivs().set) != 0L;
    }

    public boolean containsNodePriv() {
        return this.containsPrivs(PaloPrivilege.NODE_PRIV);
    }

    public boolean containsResourcePriv() {
        return this.containsPrivs(PaloPrivilege.USAGE_PRIV);
    }

    public boolean containsDbTablePriv() {
        return this.containsPrivs(PaloPrivilege.SELECT_PRIV, PaloPrivilege.LOAD_PRIV, PaloPrivilege.ALTER_PRIV, PaloPrivilege.CREATE_PRIV, PaloPrivilege.DROP_PRIV);
    }

    public boolean containsPrivs(PaloPrivilege ... privs) {
        for (PaloPrivilege priv : privs) {
            if (!this.get(priv.getIdx())) continue;
            return true;
        }
        return false;
    }

    public List<PaloPrivilege> toPrivilegeList() {
        ArrayList privs = Lists.newArrayList();
        for (int i = 0; i < PaloPrivilege.privileges.length; ++i) {
            if (!this.get(i)) continue;
            privs.add(PaloPrivilege.getPriv(i));
        }
        return privs;
    }

    public static PrivBitSet of(PaloPrivilege ... privs) {
        PrivBitSet bitSet = new PrivBitSet();
        for (PaloPrivilege priv : privs) {
            bitSet.set(priv.getIdx());
        }
        return bitSet;
    }

    public static PrivBitSet of(List<PaloPrivilege> privs) {
        PrivBitSet bitSet = new PrivBitSet();
        for (PaloPrivilege priv : privs) {
            bitSet.set(priv.getIdx());
        }
        return bitSet;
    }

    public PrivBitSet copy() {
        PrivBitSet newSet = new PrivBitSet();
        newSet.set = this.set;
        return newSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < PaloPrivilege.privileges.length; ++i) {
            if (!this.get(i)) continue;
            sb.append((Object)PaloPrivilege.getPriv(i)).append(" ");
        }
        return sb.toString();
    }

    public static PrivBitSet read(DataInput in) throws IOException {
        PrivBitSet privBitSet = new PrivBitSet();
        privBitSet.readFields(in);
        return privBitSet;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.set);
    }

    public void readFields(DataInput in) throws IOException {
        this.set = in.readLong();
    }
}

