/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.ResourcePattern;
import org.apache.doris.analysis.TablePattern;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivBitSet;

public class PaloRole
implements Writable {
    public static String OPERATOR_ROLE = "operator";
    public static String ADMIN_ROLE = "admin";
    public static PaloRole OPERATOR = new PaloRole(OPERATOR_ROLE, TablePattern.ALL, PrivBitSet.of(PaloPrivilege.NODE_PRIV, PaloPrivilege.ADMIN_PRIV), ResourcePattern.ALL, PrivBitSet.of(PaloPrivilege.NODE_PRIV, PaloPrivilege.ADMIN_PRIV));
    public static PaloRole ADMIN = new PaloRole(ADMIN_ROLE, TablePattern.ALL, PrivBitSet.of(PaloPrivilege.ADMIN_PRIV), ResourcePattern.ALL, PrivBitSet.of(PaloPrivilege.ADMIN_PRIV));
    private String roleName;
    private Map<TablePattern, PrivBitSet> tblPatternToPrivs = Maps.newConcurrentMap();
    private Map<ResourcePattern, PrivBitSet> resourcePatternToPrivs = Maps.newConcurrentMap();
    private Set<UserIdentity> users = Sets.newConcurrentHashSet();

    private PaloRole() {
    }

    public PaloRole(String roleName) {
        this.roleName = roleName;
    }

    public PaloRole(String roleName, TablePattern tablePattern, PrivBitSet privs) {
        this.roleName = roleName;
        this.tblPatternToPrivs.put(tablePattern, privs);
    }

    public PaloRole(String roleName, ResourcePattern resourcePattern, PrivBitSet privs) {
        this.roleName = roleName;
        this.resourcePatternToPrivs.put(resourcePattern, privs);
    }

    public PaloRole(String roleName, TablePattern tablePattern, PrivBitSet tablePrivs, ResourcePattern resourcePattern, PrivBitSet resourcePrivs) {
        this.roleName = roleName;
        this.tblPatternToPrivs.put(tablePattern, tablePrivs);
        this.resourcePatternToPrivs.put(resourcePattern, resourcePrivs);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public Map<TablePattern, PrivBitSet> getTblPatternToPrivs() {
        return this.tblPatternToPrivs;
    }

    public Map<ResourcePattern, PrivBitSet> getResourcePatternToPrivs() {
        return this.resourcePatternToPrivs;
    }

    public Set<UserIdentity> getUsers() {
        return this.users;
    }

    public void mergeNotCheck(PaloRole other) {
        PrivBitSet existPrivs;
        for (Map.Entry<TablePattern, PrivBitSet> entry : other.getTblPatternToPrivs().entrySet()) {
            if (this.tblPatternToPrivs.containsKey(entry.getKey())) {
                existPrivs = this.tblPatternToPrivs.get(entry.getKey());
                existPrivs.or(entry.getValue());
                continue;
            }
            this.tblPatternToPrivs.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, PrivBitSet> entry : other.resourcePatternToPrivs.entrySet()) {
            if (this.resourcePatternToPrivs.containsKey(entry.getKey())) {
                existPrivs = this.resourcePatternToPrivs.get(entry.getKey());
                existPrivs.or(entry.getValue());
                continue;
            }
            this.resourcePatternToPrivs.put((ResourcePattern)entry.getKey(), entry.getValue());
        }
    }

    public void merge(PaloRole other) {
        Preconditions.checkState((boolean)this.roleName.equalsIgnoreCase(other.getRoleName()));
        this.mergeNotCheck(other);
    }

    public void addUser(UserIdentity userIdent) {
        this.users.add(userIdent);
    }

    public void dropUser(UserIdentity userIdentity) {
        Iterator<UserIdentity> iter = this.users.iterator();
        while (iter.hasNext()) {
            UserIdentity userIdent = iter.next();
            if (!userIdent.equals(userIdentity)) continue;
            iter.remove();
        }
    }

    public static PaloRole read(DataInput in) throws IOException {
        PaloRole role = new PaloRole();
        role.readFields(in);
        return role;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.roleName);
        out.writeInt(this.tblPatternToPrivs.size());
        for (Map.Entry<TablePattern, PrivBitSet> entry : this.tblPatternToPrivs.entrySet()) {
            entry.getKey().write(out);
            entry.getValue().write(out);
        }
        out.writeInt(this.resourcePatternToPrivs.size());
        for (Map.Entry<Object, PrivBitSet> entry : this.resourcePatternToPrivs.entrySet()) {
            ((ResourcePattern)entry.getKey()).write(out);
            entry.getValue().write(out);
        }
        out.writeInt(this.users.size());
        for (UserIdentity userIdentity : this.users) {
            userIdentity.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        PrivBitSet privs;
        int i;
        this.roleName = Text.readString((DataInput)in);
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            TablePattern tblPattern = TablePattern.read(in);
            privs = PrivBitSet.read(in);
            this.tblPatternToPrivs.put(tblPattern, privs);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            ResourcePattern resourcePattern = ResourcePattern.read(in);
            privs = PrivBitSet.read(in);
            this.resourcePatternToPrivs.put(resourcePattern, privs);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            UserIdentity userIdentity = UserIdentity.read(in);
            this.users.add(userIdentity);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("role: ").append(this.roleName).append(", db table privs: ").append(this.tblPatternToPrivs);
        sb.append(", resource privs: ").append(this.resourcePatternToPrivs);
        sb.append(", users: ").append(this.users);
        return sb.toString();
    }
}

