/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivPredicate;

public enum PaloPrivilege {
    NODE_PRIV("Node_priv", 0, "Privilege for cluster node operations"),
    ADMIN_PRIV("Admin_priv", 1, "Privilege for admin user"),
    GRANT_PRIV("Grant_priv", 2, "Privilege for granting privilege"),
    SELECT_PRIV("Select_priv", 3, "Privilege for select data in tables"),
    LOAD_PRIV("Load_priv", 4, "Privilege for loading data into tables"),
    ALTER_PRIV("Alter_priv", 5, "Privilege for alter database or table"),
    CREATE_PRIV("Create_priv", 6, "Privilege for creating database or table"),
    DROP_PRIV("Drop_priv", 7, "Privilege for dropping database or table"),
    USAGE_PRIV("Usage_priv", 8, "Privilege for using resource");

    public static PaloPrivilege[] privileges;
    public static Map<PaloPrivilege, String> privInPaloToMysql;
    private String name;
    private int idx;
    private String desc;

    private PaloPrivilege(String name, int index, String desc) {
        this.name = name;
        this.idx = index;
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public int getIdx() {
        return this.idx;
    }

    public String getDesc() {
        return this.desc;
    }

    public static PaloPrivilege getPriv(int index) {
        if (index < 0 || index > PaloPrivilege.values().length - 1) {
            return null;
        }
        return privileges[index];
    }

    public static boolean satisfy(PrivBitSet grantPriv, PrivPredicate wanted) {
        return grantPriv.satisfy(wanted);
    }

    public String toString() {
        return this.name;
    }

    static {
        privileges = new PaloPrivilege[]{NODE_PRIV, ADMIN_PRIV, GRANT_PRIV, SELECT_PRIV, LOAD_PRIV, ALTER_PRIV, CREATE_PRIV, DROP_PRIV, USAGE_PRIV};
        privInPaloToMysql = ImmutableMap.builder().put((Object)SELECT_PRIV, (Object)"SELECT").put((Object)LOAD_PRIV, (Object)"INSERT").put((Object)ALTER_PRIV, (Object)"ALTER").put((Object)CREATE_PRIV, (Object)"CREATE").put((Object)DROP_PRIV, (Object)"DROP").put((Object)USAGE_PRIV, (Object)"USAGE").build();
    }
}

