/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.analysis.CreateRoleStmt;
import org.apache.doris.analysis.CreateUserStmt;
import org.apache.doris.analysis.DropRoleStmt;
import org.apache.doris.analysis.DropUserStmt;
import org.apache.doris.analysis.GrantStmt;
import org.apache.doris.analysis.ResourcePattern;
import org.apache.doris.analysis.RevokeStmt;
import org.apache.doris.analysis.SetLdapPassVar;
import org.apache.doris.analysis.SetPassVar;
import org.apache.doris.analysis.SetUserPropertyStmt;
import org.apache.doris.analysis.TablePattern;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.AuthorizationInfo;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.LdapConfig;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.ldap.LdapPrivsChecker;
import org.apache.doris.load.DppConfig;
import org.apache.doris.mysql.privilege.DbPrivEntry;
import org.apache.doris.mysql.privilege.DbPrivTable;
import org.apache.doris.mysql.privilege.GlobalPrivEntry;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PaloRole;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.mysql.privilege.PrivTable;
import org.apache.doris.mysql.privilege.ResourcePrivEntry;
import org.apache.doris.mysql.privilege.ResourcePrivTable;
import org.apache.doris.mysql.privilege.RoleManager;
import org.apache.doris.mysql.privilege.TablePrivEntry;
import org.apache.doris.mysql.privilege.TablePrivTable;
import org.apache.doris.mysql.privilege.UserPrivTable;
import org.apache.doris.mysql.privilege.UserPropertyInfo;
import org.apache.doris.mysql.privilege.UserPropertyMgr;
import org.apache.doris.persist.LdapInfo;
import org.apache.doris.persist.PrivInfo;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.resource.Tag;
import org.apache.doris.thrift.TFetchResourceResult;
import org.apache.doris.thrift.TPrivilegeStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaloAuth
implements Writable {
    private static final Logger LOG = LogManager.getLogger(PaloAuth.class);
    public static final String ROOT_USER = "root";
    public static final String ADMIN_USER = "admin";
    public static final String UNKNOWN_USER = "unknown";
    private UserPrivTable userPrivTable = new UserPrivTable();
    private DbPrivTable dbPrivTable = new DbPrivTable();
    private TablePrivTable tablePrivTable = new TablePrivTable();
    private ResourcePrivTable resourcePrivTable = new ResourcePrivTable();
    private RoleManager roleManager = new RoleManager();
    private UserPropertyMgr propertyMgr = new UserPropertyMgr();
    private LdapInfo ldapInfo = new LdapInfo();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public PaloAuth() {
        this.initUser();
    }

    public UserPrivTable getUserPrivTable() {
        return this.userPrivTable;
    }

    public DbPrivTable getDbPrivTable() {
        return this.dbPrivTable;
    }

    public TablePrivTable getTablePrivTable() {
        return this.tablePrivTable;
    }

    public LdapInfo getLdapInfo() {
        return this.ldapInfo;
    }

    public void setLdapInfo(LdapInfo ldapInfo) {
        this.ldapInfo = ldapInfo;
    }

    private GlobalPrivEntry grantGlobalPrivs(UserIdentity userIdentity, boolean errOnExist, boolean errOnNonExist, PrivBitSet privs) throws DdlException {
        GlobalPrivEntry entry;
        if (errOnExist && errOnNonExist) {
            throw new DdlException("Can only specified errOnExist or errOnNonExist");
        }
        try {
            entry = GlobalPrivEntry.create(userIdentity.getHost(), userIdentity.getQualifiedUser(), userIdentity.isDomain(), new byte[0], privs);
            entry.setSetByDomainResolver(false);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        this.userPrivTable.addEntry(entry, errOnExist, errOnNonExist);
        return entry;
    }

    private void revokeGlobalPrivs(UserIdentity userIdentity, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        GlobalPrivEntry entry;
        try {
            entry = GlobalPrivEntry.create(userIdentity.getHost(), userIdentity.getQualifiedUser(), userIdentity.isDomain(), new byte[0], privs);
            entry.setSetByDomainResolver(false);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        this.userPrivTable.revoke(entry, errOnNonExist, false);
    }

    private void grantDbPrivs(UserIdentity userIdentity, String db, boolean errOnExist, boolean errOnNonExist, PrivBitSet privs) throws DdlException {
        DbPrivEntry entry;
        try {
            entry = DbPrivEntry.create(userIdentity.getHost(), db, userIdentity.getQualifiedUser(), userIdentity.isDomain(), privs);
            entry.setSetByDomainResolver(false);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        this.dbPrivTable.addEntry(entry, errOnExist, errOnNonExist);
    }

    private void revokeDbPrivs(UserIdentity userIdentity, String db, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        DbPrivEntry entry;
        try {
            entry = DbPrivEntry.create(userIdentity.getHost(), db, userIdentity.getQualifiedUser(), userIdentity.isDomain(), privs);
            entry.setSetByDomainResolver(false);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        this.dbPrivTable.revoke(entry, errOnNonExist, true);
    }

    private void grantTblPrivs(UserIdentity userIdentity, String db, String tbl, boolean errOnExist, boolean errOnNonExist, PrivBitSet privs) throws DdlException {
        TablePrivEntry entry;
        try {
            entry = TablePrivEntry.create(userIdentity.getHost(), db, userIdentity.getQualifiedUser(), tbl, userIdentity.isDomain(), privs);
            entry.setSetByDomainResolver(false);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        this.tablePrivTable.addEntry(entry, errOnExist, errOnNonExist);
    }

    private void revokeTblPrivs(UserIdentity userIdentity, String db, String tbl, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        TablePrivEntry entry;
        try {
            entry = TablePrivEntry.create(userIdentity.getHost(), db, userIdentity.getQualifiedUser(), tbl, userIdentity.isDomain(), privs);
            entry.setSetByDomainResolver(false);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        this.tablePrivTable.revoke(entry, errOnNonExist, true);
    }

    private void grantResourcePrivs(UserIdentity userIdentity, String resourceName, boolean errOnExist, boolean errOnNonExist, PrivBitSet privs) throws DdlException {
        ResourcePrivEntry entry;
        try {
            entry = ResourcePrivEntry.create(userIdentity.getHost(), resourceName, userIdentity.getQualifiedUser(), userIdentity.isDomain(), privs);
            entry.setSetByDomainResolver(false);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        this.resourcePrivTable.addEntry(entry, errOnExist, errOnNonExist);
    }

    private void revokeResourcePrivs(UserIdentity userIdentity, String resourceName, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        ResourcePrivEntry entry;
        try {
            entry = ResourcePrivEntry.create(userIdentity.getHost(), resourceName, userIdentity.getQualifiedUser(), userIdentity.isDomain(), privs);
            entry.setSetByDomainResolver(false);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        this.resourcePrivTable.revoke(entry, errOnNonExist, true);
    }

    public boolean doesRoleExist(String qualifiedRole) {
        return this.roleManager.getRole(qualifiedRole) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeRolesNoCheckName(List<String> roles, PaloRole savedRole) {
        this.readLock();
        try {
            for (String roleName : roles) {
                if (!this.doesRoleExist(roleName)) continue;
                PaloRole role = this.roleManager.getRole(roleName);
                savedRole.mergeNotCheck(role);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPassword(String remoteUser, String remoteHost, byte[] remotePasswd, byte[] randomString, List<UserIdentity> currentUser) {
        if (!Config.enable_auth_check) {
            return true;
        }
        if ((remoteUser.equals(ROOT_USER) || remoteUser.equals(ADMIN_USER)) && remoteHost.equals("127.0.0.1")) {
            if (remoteUser.equals(ROOT_USER)) {
                currentUser.add(UserIdentity.ROOT);
            } else {
                currentUser.add(UserIdentity.ADMIN);
            }
            return true;
        }
        this.readLock();
        try {
            boolean bl = this.userPrivTable.checkPassword(remoteUser, remoteHost, remotePasswd, randomString, currentUser);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPlainPassword(String remoteUser, String remoteHost, String remotePasswd, List<UserIdentity> currentUser) {
        if (!Config.enable_auth_check) {
            return true;
        }
        this.readLock();
        try {
            boolean bl = this.userPrivTable.checkPlainPassword(remoteUser, remoteHost, remotePasswd, currentUser);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean checkGlobalPriv(ConnectContext ctx, PrivPredicate wanted) {
        return this.checkGlobalPriv(ctx.getCurrentUserIdentity(), wanted);
    }

    public boolean checkGlobalPriv(UserIdentity currentUser, PrivPredicate wanted) {
        if (!Config.enable_auth_check) {
            return true;
        }
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        if (this.checkGlobalInternal(currentUser, wanted, savedPrivs)) {
            return true;
        }
        LOG.debug("failed to get wanted privs: {}, granted: {}", (Object)wanted, (Object)savedPrivs);
        return false;
    }

    public boolean checkDbPriv(ConnectContext ctx, String qualifiedDb, PrivPredicate wanted) {
        return this.checkDbPriv(ctx.getCurrentUserIdentity(), qualifiedDb, wanted);
    }

    public boolean checkDbPriv(UserIdentity currentUser, String db, PrivPredicate wanted) {
        if (!Config.enable_auth_check) {
            return true;
        }
        if (wanted.getPrivs().containsNodePriv()) {
            LOG.debug("should not check NODE priv in Database level. user: {}, db: {}", (Object)currentUser, (Object)db);
            return false;
        }
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        if (this.checkGlobalInternal(currentUser, wanted, savedPrivs) || this.checkDbInternal(currentUser, db, wanted, savedPrivs)) {
            return true;
        }
        if (db != null && wanted == PrivPredicate.SHOW && this.checkTblWithDb(currentUser, db)) {
            return true;
        }
        LOG.debug("failed to get wanted privs: {}, granted: {}", (Object)wanted, (Object)savedPrivs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTblWithDb(UserIdentity currentUser, String db) {
        this.readLock();
        try {
            boolean bl = this.isLdapAuthEnabled() && LdapPrivsChecker.hasPrivsOfDb(currentUser, db) || this.tablePrivTable.hasPrivsOfDb(currentUser, db);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean checkTblPriv(ConnectContext ctx, String qualifiedDb, String tbl, PrivPredicate wanted) {
        return this.checkTblPriv(ctx.getCurrentUserIdentity(), qualifiedDb, tbl, wanted);
    }

    public boolean checkTblPriv(UserIdentity currentUser, String db, String tbl, PrivPredicate wanted) {
        if (!Config.enable_auth_check) {
            return true;
        }
        if (wanted.getPrivs().containsNodePriv()) {
            LOG.debug("should check NODE priv in GLOBAL level. user: {}, db: {}, tbl: {}", (Object)currentUser, (Object)db, (Object)tbl);
            return false;
        }
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        if (this.checkGlobalInternal(currentUser, wanted, savedPrivs) || this.checkDbInternal(currentUser, db, wanted, savedPrivs) || this.checkTblInternal(currentUser, db, tbl, wanted, savedPrivs)) {
            return true;
        }
        LOG.debug("failed to get wanted privs: {}, granted: {}", (Object)wanted, (Object)savedPrivs);
        return false;
    }

    public boolean checkResourcePriv(ConnectContext ctx, String resourceName, PrivPredicate wanted) {
        return this.checkResourcePriv(ctx.getCurrentUserIdentity(), resourceName, wanted);
    }

    public boolean checkResourcePriv(UserIdentity currentUser, String resourceName, PrivPredicate wanted) {
        if (!Config.enable_auth_check) {
            return true;
        }
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        if (this.checkGlobalInternal(currentUser, wanted, savedPrivs) || this.checkResourceInternal(currentUser, resourceName, wanted, savedPrivs)) {
            return true;
        }
        LOG.debug("failed to get wanted privs: {}, granted: {}", (Object)wanted, (Object)savedPrivs);
        return false;
    }

    public boolean checkPrivByAuthInfo(ConnectContext ctx, AuthorizationInfo authInfo, PrivPredicate wanted) {
        if (authInfo == null) {
            return false;
        }
        if (authInfo.getDbName() == null) {
            return false;
        }
        if (authInfo.getTableNameList() == null || authInfo.getTableNameList().isEmpty()) {
            return this.checkDbPriv(ctx, authInfo.getDbName(), wanted);
        }
        for (String tblName : authInfo.getTableNameList()) {
            if (Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), authInfo.getDbName(), tblName, wanted)) continue;
            return false;
        }
        return true;
    }

    public boolean checkHasPriv(ConnectContext ctx, PrivPredicate priv, PrivLevel ... levels) {
        return this.checkHasPrivInternal(ctx.getCurrentUserIdentity(), ctx.getRemoteIP(), ctx.getQualifiedUser(), priv, levels);
    }

    private boolean checkHasPrivInternal(UserIdentity currentUser, String host, String user, PrivPredicate priv, PrivLevel ... levels) {
        block5: for (PrivLevel privLevel : levels) {
            switch (privLevel) {
                case GLOBAL: {
                    if ((!this.isLdapAuthEnabled() || !LdapPrivsChecker.hasGlobalPrivFromLdap(currentUser, priv)) && !this.userPrivTable.hasPriv(host, user, priv)) continue block5;
                    return true;
                }
                case DATABASE: {
                    if ((!this.isLdapAuthEnabled() || !LdapPrivsChecker.hasDbPrivFromLdap(currentUser, priv)) && !this.dbPrivTable.hasPriv(host, user, priv)) continue block5;
                    return true;
                }
                case TABLE: {
                    if ((!this.isLdapAuthEnabled() || !LdapPrivsChecker.hasTblPrivFromLdap(currentUser, priv)) && !this.tablePrivTable.hasPriv(host, user, priv)) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkGlobalInternal(UserIdentity currentUser, PrivPredicate wanted, PrivBitSet savedPrivs) {
        if (this.isLdapAuthEnabled() && LdapPrivsChecker.hasGlobalPrivFromLdap(currentUser, wanted)) {
            return true;
        }
        this.readLock();
        try {
            this.userPrivTable.getPrivs(currentUser, savedPrivs);
            if (PaloPrivilege.satisfy(savedPrivs, wanted)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDbInternal(UserIdentity currentUser, String db, PrivPredicate wanted, PrivBitSet savedPrivs) {
        if (this.isLdapAuthEnabled() && LdapPrivsChecker.hasDbPrivFromLdap(currentUser, db, wanted)) {
            return true;
        }
        this.readLock();
        try {
            this.dbPrivTable.getPrivs(currentUser, db, savedPrivs);
            if (PaloPrivilege.satisfy(savedPrivs, wanted)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.readUnlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTblInternal(UserIdentity currentUser, String db, String tbl, PrivPredicate wanted, PrivBitSet savedPrivs) {
        if (this.isLdapAuthEnabled() && LdapPrivsChecker.hasTblPrivFromLdap(currentUser, db, tbl, wanted)) {
            return true;
        }
        this.readLock();
        try {
            this.tablePrivTable.getPrivs(currentUser, db, tbl, savedPrivs);
            if (PaloPrivilege.satisfy(savedPrivs, wanted)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkResourceInternal(UserIdentity currentUser, String resourceName, PrivPredicate wanted, PrivBitSet savedPrivs) {
        if (this.isLdapAuthEnabled() && LdapPrivsChecker.hasResourcePrivFromLdap(currentUser, resourceName, wanted)) {
            return true;
        }
        this.readLock();
        try {
            this.resourcePrivTable.getPrivs(currentUser, resourceName, savedPrivs);
            if (PaloPrivilege.satisfy(savedPrivs, wanted)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    private boolean isLdapAuthEnabled() {
        return LdapConfig.ldap_authentication_enabled;
    }

    public void clear() {
        this.userPrivTable.clear();
        this.dbPrivTable.clear();
        this.tablePrivTable.clear();
        this.resourcePrivTable.clear();
    }

    public void createUser(CreateUserStmt stmt) throws DdlException {
        this.createUserInternal(stmt.getUserIdent(), stmt.getQualifiedRole(), stmt.getPassword(), stmt.isIfNotExist(), false);
    }

    public void replayCreateUser(PrivInfo privInfo) {
        try {
            this.createUserInternal(privInfo.getUserIdent(), privInfo.getRole(), privInfo.getPasswd(), false, true);
        }
        catch (DdlException e) {
            LOG.error("should not happen", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createUserInternal(UserIdentity userIdent, String roleName, byte[] password, boolean ignoreIfExists, boolean isReplay) throws DdlException {
        this.writeLock();
        try {
            PaloRole role = null;
            if (roleName != null && (role = this.roleManager.getRole(roleName)) == null) {
                throw new DdlException("Role: " + roleName + " does not exist");
            }
            if (this.userPrivTable.doesUserExist(userIdent)) {
                if (ignoreIfExists) {
                    LOG.info("user exists, ignored to create user: {}, is replay: {}", (Object)userIdent, (Object)isReplay);
                    return;
                }
                throw new DdlException("User " + userIdent + " already exist");
            }
            this.setPasswordInternal(userIdent, password, null, false, false, true);
            this.grantPrivsByRole(userIdent, role);
            this.propertyMgr.addUserResource(userIdent.getQualifiedUser(), false);
            if (!userIdent.getQualifiedUser().equals(ROOT_USER) && !userIdent.getQualifiedUser().equals(ADMIN_USER)) {
                TablePattern tblPattern = new TablePattern("information_schema", "*");
                try {
                    tblPattern.analyze(ClusterNamespace.getClusterNameFromFullName(userIdent.getQualifiedUser()));
                }
                catch (AnalysisException e) {
                    LOG.warn("should not happen", (Throwable)e);
                }
                this.grantInternal(userIdent, null, tblPattern, PrivBitSet.of(PaloPrivilege.SELECT_PRIV), false, true);
            }
            if (!isReplay) {
                PrivInfo privInfo = new PrivInfo(userIdent, null, password, roleName);
                Catalog.getCurrentCatalog().getEditLog().logCreateUser(privInfo);
            }
            LOG.info("finished to create user: {}, is replay: {}", (Object)userIdent, (Object)isReplay);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantPrivsByRole(UserIdentity userIdent, PaloRole role) throws DdlException {
        this.writeLock();
        try {
            if (role != null) {
                for (Map.Entry<TablePattern, PrivBitSet> entry : role.getTblPatternToPrivs().entrySet()) {
                    this.grantInternal(userIdent, null, entry.getKey(), entry.getValue().copy(), false, true);
                }
                for (Map.Entry<Object, PrivBitSet> entry : role.getResourcePatternToPrivs().entrySet()) {
                    this.grantInternal(userIdent, null, (ResourcePattern)entry.getKey(), entry.getValue().copy(), false, true);
                }
                role.addUser(userIdent);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void dropUser(DropUserStmt stmt) throws DdlException {
        this.dropUserInternal(stmt.getUserIdentity(), stmt.isSetIfExists(), false);
    }

    public void replayDropUser(UserIdentity userIdent) throws DdlException {
        this.dropUserInternal(userIdent, false, true);
    }

    public void replayOldDropUser(String userName) throws DdlException {
        UserIdentity userIdentity = new UserIdentity(userName, "%");
        userIdentity.setIsAnalyzed();
        this.dropUserInternal(userIdentity, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropUserInternal(UserIdentity userIdent, boolean ignoreIfNonExists, boolean isReplay) throws DdlException {
        this.writeLock();
        try {
            if (!this.doesUserExist(userIdent)) {
                if (ignoreIfNonExists) {
                    LOG.info("user non exists, ignored to drop user: {}, is replay: {}", (Object)userIdent.getQualifiedUser(), (Object)isReplay);
                    return;
                }
                throw new DdlException(String.format("User `%s`@`%s` does not exist.", userIdent.getQualifiedUser(), userIdent.getHost()));
            }
            this.userPrivTable.dropUser(userIdent);
            this.dbPrivTable.dropUser(userIdent);
            this.tablePrivTable.dropUser(userIdent);
            this.resourcePrivTable.dropUser(userIdent);
            this.roleManager.dropUser(userIdent);
            if (!this.userPrivTable.doesUsernameExist(userIdent.getQualifiedUser())) {
                this.propertyMgr.dropUser(userIdent);
            } else if (userIdent.isDomain()) {
                this.propertyMgr.removeDomainFromUser(userIdent);
            }
            if (!isReplay) {
                Catalog.getCurrentCatalog().getEditLog().logNewDropUser(userIdent);
            }
            LOG.info("finished to drop user: {}, is replay: {}", (Object)userIdent.getQualifiedUser(), (Object)isReplay);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void grant(GrantStmt stmt) throws DdlException {
        PrivBitSet privs = PrivBitSet.of(stmt.getPrivileges());
        if (stmt.getTblPattern() != null) {
            this.grantInternal(stmt.getUserIdent(), stmt.getQualifiedRole(), stmt.getTblPattern(), privs, true, false);
        } else {
            this.grantInternal(stmt.getUserIdent(), stmt.getQualifiedRole(), stmt.getResourcePattern(), privs, true, false);
        }
    }

    public void replayGrant(PrivInfo privInfo) {
        try {
            if (privInfo.getTblPattern() != null) {
                this.grantInternal(privInfo.getUserIdent(), privInfo.getRole(), privInfo.getTblPattern(), privInfo.getPrivs(), true, true);
            } else {
                this.grantInternal(privInfo.getUserIdent(), privInfo.getRole(), privInfo.getResourcePattern(), privInfo.getPrivs(), true, true);
            }
        }
        catch (DdlException e) {
            LOG.error("should not happen", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantInternal(UserIdentity userIdent, String role, TablePattern tblPattern, PrivBitSet privs, boolean errOnNonExist, boolean isReplay) throws DdlException {
        this.writeLock();
        try {
            if (role != null) {
                PaloRole newRole = new PaloRole(role, tblPattern, privs);
                PaloRole existingRole = this.roleManager.addRole(newRole, false);
                for (UserIdentity user : existingRole.getUsers()) {
                    for (Map.Entry<TablePattern, PrivBitSet> entry : existingRole.getTblPatternToPrivs().entrySet()) {
                        this.grantPrivs(user, entry.getKey(), entry.getValue().copy(), errOnNonExist);
                    }
                }
            } else {
                this.grantPrivs(userIdent, tblPattern, privs, errOnNonExist);
            }
            if (!isReplay) {
                PrivInfo info = new PrivInfo(userIdent, tblPattern, privs, null, role);
                Catalog.getCurrentCatalog().getEditLog().logGrantPriv(info);
            }
            LOG.info("finished to grant privilege. is replay: {}", (Object)isReplay);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantInternal(UserIdentity userIdent, String role, ResourcePattern resourcePattern, PrivBitSet privs, boolean errOnNonExist, boolean isReplay) throws DdlException {
        this.writeLock();
        try {
            if (role != null) {
                PaloRole newRole = new PaloRole(role, resourcePattern, privs);
                PaloRole existingRole = this.roleManager.addRole(newRole, false);
                for (UserIdentity user : existingRole.getUsers()) {
                    for (Map.Entry<ResourcePattern, PrivBitSet> entry : existingRole.getResourcePatternToPrivs().entrySet()) {
                        this.grantPrivs(user, entry.getKey(), entry.getValue().copy(), errOnNonExist);
                    }
                }
            } else {
                this.grantPrivs(userIdent, resourcePattern, privs, errOnNonExist);
            }
            if (!isReplay) {
                PrivInfo info = new PrivInfo(userIdent, resourcePattern, privs, null, role);
                Catalog.getCurrentCatalog().getEditLog().logGrantPriv(info);
            }
            LOG.info("finished to grant resource privilege. is replay: {}", (Object)isReplay);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void grantPrivs(UserIdentity userIdent, TablePattern tblPattern, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        LOG.debug("grant {} on {} to {}, err on non exist: {}", (Object)privs, (Object)tblPattern, (Object)userIdent, (Object)errOnNonExist);
        this.writeLock();
        try {
            if (errOnNonExist && !this.doesUserExist(userIdent)) {
                throw new DdlException("user " + userIdent + " does not exist");
            }
            switch (tblPattern.getPrivLevel()) {
                case GLOBAL: {
                    this.grantGlobalPrivs(userIdent, false, errOnNonExist, privs);
                    return;
                }
                case DATABASE: {
                    this.grantDbPrivs(userIdent, tblPattern.getQualifiedDb(), false, false, privs);
                    return;
                }
                case TABLE: {
                    this.grantTblPrivs(userIdent, tblPattern.getQualifiedDb(), tblPattern.getTbl(), false, false, privs);
                    return;
                }
                default: {
                    Preconditions.checkNotNull(null, (Object)((Object)tblPattern.getPrivLevel()));
                    return;
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void grantPrivs(UserIdentity userIdent, ResourcePattern resourcePattern, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        LOG.debug("grant {} on resource {} to {}, err on non exist: {}", (Object)privs, (Object)resourcePattern, (Object)userIdent, (Object)errOnNonExist);
        this.writeLock();
        try {
            if (errOnNonExist && !this.doesUserExist(userIdent)) {
                throw new DdlException("user " + userIdent + " does not exist");
            }
            switch (resourcePattern.getPrivLevel()) {
                case GLOBAL: {
                    this.grantGlobalPrivs(userIdent, false, errOnNonExist, privs);
                    return;
                }
                case RESOURCE: {
                    this.grantResourcePrivs(userIdent, resourcePattern.getResourceName(), false, false, privs);
                    return;
                }
                default: {
                    Preconditions.checkNotNull(null, (Object)((Object)resourcePattern.getPrivLevel()));
                    return;
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean doesUserExist(UserIdentity userIdent) {
        if (userIdent.isDomain()) {
            return this.propertyMgr.doesUserExist(userIdent);
        }
        return this.userPrivTable.doesUserExist(userIdent);
    }

    public UserIdentity getCurrentUserIdentity(UserIdentity userIdent) {
        this.readLock();
        try {
            UserIdentity userIdentity = this.userPrivTable.getCurrentUserIdentity(userIdent);
            return userIdentity;
        }
        finally {
            this.readUnlock();
        }
    }

    public void revoke(RevokeStmt stmt) throws DdlException {
        PrivBitSet privs = PrivBitSet.of(stmt.getPrivileges());
        if (stmt.getTblPattern() != null) {
            this.revokeInternal(stmt.getUserIdent(), stmt.getQualifiedRole(), stmt.getTblPattern(), privs, true, false);
        } else {
            this.revokeInternal(stmt.getUserIdent(), stmt.getQualifiedRole(), stmt.getResourcePattern(), privs, true, false);
        }
    }

    public void replayRevoke(PrivInfo info) {
        try {
            if (info.getTblPattern() != null) {
                this.revokeInternal(info.getUserIdent(), info.getRole(), info.getTblPattern(), info.getPrivs(), true, true);
            } else {
                this.revokeInternal(info.getUserIdent(), info.getRole(), info.getResourcePattern(), info.getPrivs(), true, true);
            }
        }
        catch (DdlException e) {
            LOG.error("should not happened", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeInternal(UserIdentity userIdent, String role, TablePattern tblPattern, PrivBitSet privs, boolean errOnNonExist, boolean isReplay) throws DdlException {
        this.writeLock();
        try {
            if (role != null) {
                PaloRole existingRole = this.roleManager.revokePrivs(role, tblPattern, privs, errOnNonExist);
                if (existingRole != null) {
                    for (UserIdentity user : existingRole.getUsers()) {
                        this.revokePrivs(user, tblPattern, privs, false);
                    }
                }
            } else {
                this.revokePrivs(userIdent, tblPattern, privs, errOnNonExist);
            }
            if (!isReplay) {
                PrivInfo info = new PrivInfo(userIdent, tblPattern, privs, null, role);
                Catalog.getCurrentCatalog().getEditLog().logRevokePriv(info);
            }
            LOG.info("finished to revoke privilege. is replay: {}", (Object)isReplay);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeInternal(UserIdentity userIdent, String role, ResourcePattern resourcePattern, PrivBitSet privs, boolean errOnNonExist, boolean isReplay) throws DdlException {
        this.writeLock();
        try {
            if (role != null) {
                PaloRole existingRole = this.roleManager.revokePrivs(role, resourcePattern, privs, errOnNonExist);
                if (existingRole != null) {
                    for (UserIdentity user : existingRole.getUsers()) {
                        this.revokePrivs(user, resourcePattern, privs, false);
                    }
                }
            } else {
                this.revokePrivs(userIdent, resourcePattern, privs, errOnNonExist);
            }
            if (!isReplay) {
                PrivInfo info = new PrivInfo(userIdent, resourcePattern, privs, null, role);
                Catalog.getCurrentCatalog().getEditLog().logRevokePriv(info);
            }
            LOG.info("finished to revoke privilege. is replay: {}", (Object)isReplay);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void revokePrivs(UserIdentity userIdent, TablePattern tblPattern, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        this.writeLock();
        try {
            switch (tblPattern.getPrivLevel()) {
                case GLOBAL: {
                    this.revokeGlobalPrivs(userIdent, privs, errOnNonExist);
                    return;
                }
                case DATABASE: {
                    this.revokeDbPrivs(userIdent, tblPattern.getQualifiedDb(), privs, errOnNonExist);
                    return;
                }
                case TABLE: {
                    this.revokeTblPrivs(userIdent, tblPattern.getQualifiedDb(), tblPattern.getTbl(), privs, errOnNonExist);
                    return;
                }
                default: {
                    Preconditions.checkNotNull(null, (Object)((Object)tblPattern.getPrivLevel()));
                    return;
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void revokePrivs(UserIdentity userIdent, ResourcePattern resourcePattern, PrivBitSet privs, boolean errOnNonExist) throws DdlException {
        this.writeLock();
        try {
            switch (resourcePattern.getPrivLevel()) {
                case GLOBAL: {
                    this.revokeGlobalPrivs(userIdent, privs, errOnNonExist);
                    return;
                }
                case RESOURCE: {
                    this.revokeResourcePrivs(userIdent, resourcePattern.getResourceName(), privs, errOnNonExist);
                    return;
                }
            }
            return;
        }
        finally {
            this.writeUnlock();
        }
    }

    public void setPassword(SetPassVar stmt) throws DdlException {
        this.setPasswordInternal(stmt.getUserIdent(), stmt.getPassword(), null, true, false, false);
    }

    public void replaySetPassword(PrivInfo info) {
        try {
            this.setPasswordInternal(info.getUserIdent(), info.getPasswd(), null, true, false, true);
        }
        catch (DdlException e) {
            LOG.error("should not happened", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordInternal(UserIdentity userIdent, byte[] password, UserIdentity domainUserIdent, boolean errOnNonExist, boolean setByResolver, boolean isReplay) throws DdlException {
        Preconditions.checkArgument((!setByResolver || domainUserIdent != null ? 1 : 0) != 0, (Object)(setByResolver + ", " + domainUserIdent));
        this.writeLock();
        try {
            if (userIdent.isDomain()) {
                this.propertyMgr.setPasswordForDomain(userIdent, password, true, errOnNonExist);
            } else {
                GlobalPrivEntry passwdEntry;
                try {
                    passwdEntry = GlobalPrivEntry.create(userIdent.getHost(), userIdent.getQualifiedUser(), userIdent.isDomain(), password, PrivBitSet.of(new PaloPrivilege[0]));
                    passwdEntry.setSetByDomainResolver(setByResolver);
                    if (setByResolver) {
                        Preconditions.checkNotNull((Object)domainUserIdent);
                        passwdEntry.setDomainUserIdent(domainUserIdent);
                    }
                }
                catch (AnalysisException e) {
                    throw new DdlException(e.getMessage());
                }
                this.userPrivTable.setPassword(passwdEntry, errOnNonExist);
            }
            if (!isReplay) {
                PrivInfo info = new PrivInfo(userIdent, null, password, null);
                Catalog.getCurrentCatalog().getEditLog().logSetPassword(info);
            }
        }
        finally {
            this.writeUnlock();
        }
        LOG.info("finished to set password for {}. is replay: {}", (Object)userIdent, (Object)isReplay);
    }

    public void setLdapPassword(SetLdapPassVar stmt) {
        this.ldapInfo = new LdapInfo(stmt.getLdapPassword());
        Catalog.getCurrentCatalog().getEditLog().logSetLdapPassword(this.ldapInfo);
        LOG.info("finished to set ldap password.");
    }

    public void replaySetLdapPassword(LdapInfo info) {
        this.ldapInfo = info;
        LOG.debug("finish replaying ldap admin password.");
    }

    public void createRole(CreateRoleStmt stmt) throws DdlException {
        this.createRoleInternal(stmt.getQualifiedRole(), stmt.isSetIfNotExists(), false);
    }

    public void replayCreateRole(PrivInfo info) {
        try {
            this.createRoleInternal(info.getRole(), false, true);
        }
        catch (DdlException e) {
            LOG.error("should not happened", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRoleInternal(String role, boolean ignoreIfExists, boolean isReplay) throws DdlException {
        PaloRole emptyPrivsRole = new PaloRole(role);
        this.writeLock();
        try {
            if (ignoreIfExists && this.roleManager.getRole(role) != null) {
                LOG.info("role exists, ignored to create role: {}, is replay: {}", (Object)role, (Object)isReplay);
                return;
            }
            this.roleManager.addRole(emptyPrivsRole, true);
            if (!isReplay) {
                PrivInfo info = new PrivInfo(null, null, null, role);
                Catalog.getCurrentCatalog().getEditLog().logCreateRole(info);
            }
        }
        finally {
            this.writeUnlock();
        }
        LOG.info("finished to create role: {}, is replay: {}", (Object)role, (Object)isReplay);
    }

    public void dropRole(DropRoleStmt stmt) throws DdlException {
        this.dropRoleInternal(stmt.getQualifiedRole(), stmt.isSetIfExists(), false);
    }

    public void replayDropRole(PrivInfo info) {
        try {
            this.dropRoleInternal(info.getRole(), false, true);
        }
        catch (DdlException e) {
            LOG.error("should not happened", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropRoleInternal(String role, boolean ignoreIfNonExists, boolean isReplay) throws DdlException {
        this.writeLock();
        try {
            if (ignoreIfNonExists && this.roleManager.getRole(role) == null) {
                LOG.info("role non exists, ignored to drop role: {}, is replay: {}", (Object)role, (Object)isReplay);
                return;
            }
            this.roleManager.dropRole(role, true);
            if (!isReplay) {
                PrivInfo info = new PrivInfo(null, null, null, role);
                Catalog.getCurrentCatalog().getEditLog().logDropRole(info);
            }
        }
        finally {
            this.writeUnlock();
        }
        LOG.info("finished to drop role: {}, is replay: {}", (Object)role, (Object)isReplay);
    }

    public void updateUserProperty(SetUserPropertyStmt stmt) throws UserException {
        List<Pair<String, String>> properties = stmt.getPropertyPairList();
        this.updateUserPropertyInternal(stmt.getUser(), properties, false);
    }

    public void replayUpdateUserProperty(UserPropertyInfo propInfo) throws UserException {
        this.updateUserPropertyInternal(propInfo.getUser(), propInfo.getProperties(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserPropertyInternal(String user, List<Pair<String, String>> properties, boolean isReplay) throws UserException {
        this.writeLock();
        try {
            this.propertyMgr.updateUserProperty(user, properties);
            if (!isReplay) {
                UserPropertyInfo propertyInfo = new UserPropertyInfo(user, properties);
                Catalog.getCurrentCatalog().getEditLog().logUpdateUserProperty(propertyInfo);
            }
            LOG.info("finished to set properties for user: {}", (Object)user);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxConn(String qualifiedUser) {
        this.readLock();
        try {
            long l = this.propertyMgr.getMaxConn(qualifiedUser);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxQueryInstances(String qualifiedUser) {
        this.readLock();
        try {
            long l = this.propertyMgr.getMaxQueryInstances(qualifiedUser);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    public String[] getSqlBlockRules(String qualifiedUser) {
        this.readLock();
        try {
            String[] stringArray = this.propertyMgr.getSqlBlockRules(qualifiedUser);
            return stringArray;
        }
        finally {
            this.readUnlock();
        }
    }

    public int getCpuResourceLimit(String qualifiedUser) {
        this.readLock();
        try {
            int n = this.propertyMgr.getCpuResourceLimit(qualifiedUser);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public Set<Tag> getResourceTags(String qualifiedUser) {
        this.readLock();
        try {
            Set<Tag> set = this.propertyMgr.getResourceTags(qualifiedUser);
            return set;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecMemLimit(String qualifiedUser) {
        this.readLock();
        try {
            long l = this.propertyMgr.getExecMemLimit(qualifiedUser);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLoadMemLimit(String qualifiedUser) {
        this.readLock();
        try {
            long l = this.propertyMgr.getLoadMemLimit(qualifiedUser);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    public void getAllDomains(Set<String> allDomains) {
        this.readLock();
        try {
            this.propertyMgr.getAllDomains(allDomains);
        }
        finally {
            this.readUnlock();
        }
    }

    public void refreshUserPrivEntriesByResovledIPs(Map<String, Set<String>> resolvedIPsMap) {
        this.writeLock();
        try {
            this.userPrivTable.clearEntriesSetByResolver();
            this.propertyMgr.addUserPrivEntriesByResolvedIPs(resolvedIPsMap);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getAuthInfo(UserIdentity specifiedUserIdent) {
        ArrayList userAuthInfos = Lists.newArrayList();
        this.readLock();
        try {
            if (specifiedUserIdent == null) {
                Set<UserIdentity> userIdents = this.getAllUserIdents(false);
                for (UserIdentity userIdent : userIdents) {
                    this.getUserAuthInfo(userAuthInfos, userIdent);
                }
            } else {
                this.getUserAuthInfo(userAuthInfos, specifiedUserIdent);
            }
        }
        finally {
            this.readUnlock();
        }
        return userAuthInfos;
    }

    private void getUserAuthInfo(List<List<String>> userAuthInfos, UserIdentity userIdent) {
        ArrayList userAuthInfo = Lists.newArrayList();
        PrivBitSet ldapGlobalPrivs = LdapPrivsChecker.getGlobalPrivFromLdap(userIdent);
        for (PrivEntry entry : this.userPrivTable.entries) {
            if (!entry.match(userIdent, true)) continue;
            GlobalPrivEntry gEntry = (GlobalPrivEntry)entry;
            userAuthInfo.add(userIdent.toString());
            if (userIdent.isDomain()) {
                userAuthInfo.add(this.propertyMgr.doesUserHasPassword(userIdent) ? "No" : "Yes");
            } else {
                userAuthInfo.add(gEntry.getPassword() == null || gEntry.getPassword().length == 0 ? "No" : "Yes");
            }
            PrivBitSet savedPrivs = gEntry.getPrivSet().copy();
            savedPrivs.or(ldapGlobalPrivs);
            userAuthInfo.add(savedPrivs.toString() + " (" + gEntry.isSetByDomainResolver() + ")");
            break;
        }
        if (userAuthInfo.isEmpty()) {
            userAuthInfo.add(userIdent.toString());
            if (LdapPrivsChecker.hasLdapPrivs(userIdent)) {
                userAuthInfo.add("No");
                userAuthInfo.add(ldapGlobalPrivs.toString() + " (false)");
            } else if (!userIdent.isDomain()) {
                LOG.warn("user identity does not have global priv entry: {}", (Object)userIdent);
                userAuthInfo.add(FeConstants.null_string);
                userAuthInfo.add(FeConstants.null_string);
            } else {
                userAuthInfo.add(this.propertyMgr.doesUserHasPassword(userIdent) ? "No" : "Yes");
                userAuthInfo.add(FeConstants.null_string);
            }
        }
        ArrayList dbPrivs = Lists.newArrayList();
        HashSet addedDbs = Sets.newHashSet();
        for (Object entry : this.dbPrivTable.entries) {
            if (!((PrivEntry)entry).match(userIdent, true)) continue;
            DbPrivEntry dbPrivEntry = (DbPrivEntry)entry;
            PrivBitSet savedPrivs = dbPrivEntry.getPrivSet().copy();
            savedPrivs.or(LdapPrivsChecker.getDbPrivFromLdap(userIdent, dbPrivEntry.getOrigDb()));
            addedDbs.add(dbPrivEntry.getOrigDb());
            dbPrivs.add(dbPrivEntry.getOrigDb() + ": " + savedPrivs.toString() + " (" + ((PrivEntry)entry).isSetByDomainResolver() + ")");
        }
        if (LdapPrivsChecker.hasLdapPrivs(userIdent)) {
            Map<TablePattern, PrivBitSet> ldapDbPrivs = LdapPrivsChecker.getLdapAllDbPrivs(userIdent);
            for (Map.Entry entry : ldapDbPrivs.entrySet()) {
                if (addedDbs.contains(((TablePattern)entry.getKey()).getQualifiedDb())) continue;
                dbPrivs.add(((TablePattern)entry.getKey()).getQualifiedDb() + ": " + ((PrivBitSet)entry.getValue()).toString() + " (" + false + ")");
            }
        }
        if (dbPrivs.isEmpty()) {
            userAuthInfo.add(FeConstants.null_string);
        } else {
            userAuthInfo.add(Joiner.on((String)"; ").join((Iterable)dbPrivs));
        }
        ArrayList tblPrivs = Lists.newArrayList();
        HashSet addedtbls = Sets.newHashSet();
        for (Object entry : this.tablePrivTable.entries) {
            if (!((PrivEntry)entry).match(userIdent, true)) continue;
            TablePrivEntry tablePrivEntry = (TablePrivEntry)entry;
            PrivBitSet savedPrivs = tablePrivEntry.getPrivSet().copy();
            savedPrivs.or(LdapPrivsChecker.getTblPrivFromLdap(userIdent, tablePrivEntry.getOrigDb(), tablePrivEntry.getOrigTbl()));
            addedtbls.add(tablePrivEntry.getOrigDb().concat(".").concat(tablePrivEntry.getOrigTbl()));
            tblPrivs.add(tablePrivEntry.getOrigDb() + "." + tablePrivEntry.getOrigTbl() + ": " + savedPrivs.toString() + " (" + ((PrivEntry)entry).isSetByDomainResolver() + ")");
        }
        if (LdapPrivsChecker.hasLdapPrivs(userIdent)) {
            Map<TablePattern, PrivBitSet> map = LdapPrivsChecker.getLdapAllTblPrivs(userIdent);
            for (Map.Entry entry : map.entrySet()) {
                if (addedtbls.contains(((TablePattern)entry.getKey()).getQualifiedDb().concat(".").concat(((TablePattern)entry.getKey()).getTbl()))) continue;
                tblPrivs.add(((TablePattern)entry.getKey()).getQualifiedDb().concat(".").concat(((TablePattern)entry.getKey()).getTbl()).concat(": ").concat(((PrivBitSet)entry.getValue()).toString()).concat(" (false)"));
            }
        }
        if (tblPrivs.isEmpty()) {
            userAuthInfo.add(FeConstants.null_string);
        } else {
            userAuthInfo.add(Joiner.on((String)"; ").join((Iterable)tblPrivs));
        }
        ArrayList arrayList = Lists.newArrayList();
        HashSet addedResources = Sets.newHashSet();
        for (PrivEntry entry : this.resourcePrivTable.entries) {
            if (!entry.match(userIdent, true)) continue;
            ResourcePrivEntry rEntry = (ResourcePrivEntry)entry;
            PrivBitSet savedPrivs = rEntry.getPrivSet().copy();
            savedPrivs.or(LdapPrivsChecker.getResourcePrivFromLdap(userIdent, rEntry.getOrigResource()));
            addedResources.add(rEntry.getOrigResource());
            arrayList.add(rEntry.getOrigResource() + ": " + savedPrivs.toString() + " (" + entry.isSetByDomainResolver() + ")");
        }
        if (LdapPrivsChecker.hasLdapPrivs(userIdent)) {
            Map<ResourcePattern, PrivBitSet> map = LdapPrivsChecker.getLdapAllResourcePrivs(userIdent);
            for (Map.Entry<ResourcePattern, PrivBitSet> entry : map.entrySet()) {
                if (addedResources.contains(entry.getKey().getResourceName())) continue;
                tblPrivs.add(entry.getKey().getResourceName().concat(": ").concat(entry.getValue().toString()).concat(" (false)"));
            }
        }
        if (arrayList.isEmpty()) {
            userAuthInfo.add(FeConstants.null_string);
        } else {
            userAuthInfo.add(Joiner.on((String)"; ").join((Iterable)arrayList));
        }
        userAuthInfos.add(userAuthInfo);
    }

    private Set<UserIdentity> getAllUserIdents(boolean includeEntrySetByResolver) {
        HashSet userIdents = Sets.newHashSet();
        for (PrivEntry entry : this.userPrivTable.entries) {
            if (!includeEntrySetByResolver && entry.isSetByDomainResolver()) continue;
            userIdents.add(entry.getUserIdent());
        }
        for (PrivEntry entry : this.dbPrivTable.entries) {
            if (!includeEntrySetByResolver && entry.isSetByDomainResolver()) continue;
            userIdents.add(entry.getUserIdent());
        }
        for (PrivEntry entry : this.tablePrivTable.entries) {
            if (!includeEntrySetByResolver && entry.isSetByDomainResolver()) continue;
            userIdents.add(entry.getUserIdent());
        }
        for (PrivEntry entry : this.resourcePrivTable.entries) {
            if (!includeEntrySetByResolver && entry.isSetByDomainResolver()) continue;
            userIdents.add(entry.getUserIdent());
        }
        return userIdents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getUserProperties(String qualifiedUser) {
        this.readLock();
        try {
            List<List<String>> list = this.propertyMgr.fetchUserProperty(qualifiedUser);
            return list;
        }
        catch (AnalysisException e) {
            ArrayList arrayList = Lists.newArrayList();
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUserOfCluster(String clusterName, boolean isReplay) throws DdlException {
        this.writeLock();
        try {
            Set<UserIdentity> allUserIdents = this.getAllUserIdents(true);
            for (UserIdentity userIdent : allUserIdents) {
                if (!userIdent.getQualifiedUser().startsWith(clusterName)) continue;
                this.dropUserInternal(userIdent, false, isReplay);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, DppConfig> getLoadClusterInfo(String qualifiedUser, String cluster) throws DdlException {
        this.readLock();
        try {
            Pair<String, DppConfig> pair = this.propertyMgr.getLoadClusterInfo(qualifiedUser, cluster);
            return pair;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCanEnterCluster(ConnectContext ctx, String clusterName) {
        this.readLock();
        try {
            if (this.checkGlobalPriv(ctx, PrivPredicate.ALL)) {
                boolean bl = true;
                return bl;
            }
            if (this.dbPrivTable.hasClusterPriv(ctx, clusterName)) {
                boolean bl = true;
                return bl;
            }
            if (this.tablePrivTable.hasClusterPriv(ctx, clusterName)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    private void initUser() {
        try {
            UserIdentity rootUser = new UserIdentity(ROOT_USER, "%");
            rootUser.setIsAnalyzed();
            this.createUserInternal(rootUser, PaloRole.OPERATOR_ROLE, new byte[0], false, true);
            UserIdentity adminUser = new UserIdentity(ADMIN_USER, "%");
            adminUser.setIsAnalyzed();
            this.createUserInternal(adminUser, PaloRole.ADMIN_ROLE, new byte[0], false, true);
        }
        catch (DdlException e) {
            LOG.error("should not happened", (Throwable)e);
        }
    }

    public TFetchResourceResult toResourceThrift() {
        this.readLock();
        try {
            TFetchResourceResult tFetchResourceResult = this.propertyMgr.toResourceThrift();
            return tFetchResourceResult;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<List<String>> getRoleInfo() {
        this.readLock();
        try {
            ArrayList results = Lists.newArrayList();
            this.roleManager.getRoleInfo(results);
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTablePrivStatus(List<TPrivilegeStatus> tblPrivResult, UserIdentity currentUser) {
        this.readLock();
        try {
            for (PrivEntry entry : this.tablePrivTable.getEntries()) {
                TablePrivEntry tblPrivEntry = (TablePrivEntry)entry;
                String dbName = ClusterNamespace.getNameFromFullName(tblPrivEntry.getOrigDb());
                String tblName = tblPrivEntry.getOrigTbl();
                if (dbName.equals("information_schema") || !this.checkTblPriv(currentUser, tblPrivEntry.getOrigDb(), tblName, PrivPredicate.SHOW)) continue;
                String grantee = new String("'").concat(ClusterNamespace.getNameFromFullName(tblPrivEntry.getOrigUser())).concat("'@'").concat(tblPrivEntry.getOrigHost()).concat("'");
                String isGrantable = tblPrivEntry.getPrivSet().get(2) ? "YES" : "NO";
                for (PaloPrivilege paloPriv : tblPrivEntry.getPrivSet().toPrivilegeList()) {
                    if (!PaloPrivilege.privInPaloToMysql.containsKey((Object)paloPriv)) continue;
                    TPrivilegeStatus status = new TPrivilegeStatus();
                    status.setTableName(tblName);
                    status.setPrivilegeType(PaloPrivilege.privInPaloToMysql.get((Object)paloPriv));
                    status.setGrantee(grantee);
                    status.setSchema(dbName);
                    status.setIsGrantable(isGrantable);
                    tblPrivResult.add(status);
                }
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSchemaPrivStatus(List<TPrivilegeStatus> dbPrivResult, UserIdentity currentUser) {
        this.readLock();
        try {
            for (PrivEntry entry : this.dbPrivTable.getEntries()) {
                DbPrivEntry dbPrivEntry = (DbPrivEntry)entry;
                String origDb = dbPrivEntry.getOrigDb();
                String dbName = ClusterNamespace.getNameFromFullName(dbPrivEntry.getOrigDb());
                if (dbName.equals("information_schema") || !this.checkDbPriv(currentUser, origDb, PrivPredicate.SHOW)) continue;
                String grantee = new String("'").concat(ClusterNamespace.getNameFromFullName(dbPrivEntry.getOrigUser())).concat("'@'").concat(dbPrivEntry.getOrigHost()).concat("'");
                String isGrantable = dbPrivEntry.getPrivSet().get(2) ? "YES" : "NO";
                for (PaloPrivilege paloPriv : dbPrivEntry.getPrivSet().toPrivilegeList()) {
                    if (!PaloPrivilege.privInPaloToMysql.containsKey((Object)paloPriv)) continue;
                    TPrivilegeStatus status = new TPrivilegeStatus();
                    status.setPrivilegeType(PaloPrivilege.privInPaloToMysql.get((Object)paloPriv));
                    status.setGrantee(grantee);
                    status.setSchema(dbName);
                    status.setIsGrantable(isGrantable);
                    dbPrivResult.add(status);
                }
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getGlobalPrivStatus(List<TPrivilegeStatus> userPrivResult, UserIdentity currentUser) {
        this.readLock();
        try {
            if (!this.checkGlobalPriv(currentUser, PrivPredicate.SHOW)) {
                return;
            }
            block4: for (PrivEntry userPrivEntry : this.userPrivTable.getEntries()) {
                String grantee = new String("'").concat(ClusterNamespace.getNameFromFullName(userPrivEntry.getOrigUser())).concat("'@'").concat(userPrivEntry.getOrigHost()).concat("'");
                String isGrantable = userPrivEntry.getPrivSet().get(2) ? "YES" : "NO";
                for (PaloPrivilege paloPriv : userPrivEntry.getPrivSet().toPrivilegeList()) {
                    if (paloPriv == PaloPrivilege.ADMIN_PRIV) {
                        for (String priv : PaloPrivilege.privInPaloToMysql.values()) {
                            TPrivilegeStatus status = new TPrivilegeStatus();
                            status.setPrivilegeType(priv);
                            status.setGrantee(grantee);
                            status.setIsGrantable("YES");
                            userPrivResult.add(status);
                        }
                        continue block4;
                    }
                    if (!PaloPrivilege.privInPaloToMysql.containsKey((Object)paloPriv)) continue;
                    TPrivilegeStatus status = new TPrivilegeStatus();
                    status.setPrivilegeType(PaloPrivilege.privInPaloToMysql.get((Object)paloPriv));
                    status.setGrantee(grantee);
                    status.setIsGrantable(isGrantable);
                    userPrivResult.add(status);
                }
            }
        }
        finally {
            this.readUnlock();
        }
    }

    public static PaloAuth read(DataInput in) throws IOException {
        PaloAuth auth = new PaloAuth();
        auth.readFields(in);
        return auth;
    }

    public void write(DataOutput out) throws IOException {
        this.roleManager.write(out);
        this.userPrivTable.write(out);
        this.dbPrivTable.write(out);
        this.tablePrivTable.write(out);
        this.resourcePrivTable.write(out);
        this.propertyMgr.write(out);
        this.ldapInfo.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.roleManager = RoleManager.read(in);
        this.userPrivTable = (UserPrivTable)PrivTable.read(in);
        this.dbPrivTable = (DbPrivTable)PrivTable.read(in);
        this.tablePrivTable = (TablePrivTable)PrivTable.read(in);
        this.resourcePrivTable = (ResourcePrivTable)PrivTable.read(in);
        this.propertyMgr = UserPropertyMgr.read(in);
        if (Catalog.getCurrentCatalogJournalVersion() >= 106) {
            this.ldapInfo = LdapInfo.read(in);
        }
        if (this.userPrivTable.isEmpty()) {
            this.initUser();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.userPrivTable).append("\n");
        sb.append(this.dbPrivTable).append("\n");
        sb.append(this.tablePrivTable).append("\n");
        sb.append(this.resourcePrivTable).append("\n");
        sb.append(this.roleManager).append("\n");
        sb.append(this.propertyMgr).append("\n");
        sb.append(this.ldapInfo).append("\n");
        return sb.toString();
    }

    public static enum PrivLevel {
        GLOBAL,
        DATABASE,
        TABLE,
        RESOURCE;

    }
}

