/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalPrivEntry
extends PrivEntry {
    private static final Logger LOG = LogManager.getLogger(GlobalPrivEntry.class);
    private byte[] password;
    private UserIdentity domainUserIdent;

    protected GlobalPrivEntry() {
    }

    protected GlobalPrivEntry(PatternMatcher hostPattern, String origHost, PatternMatcher userPattern, String origUser, boolean isDomain, byte[] password, PrivBitSet privSet) {
        super(hostPattern, origHost, userPattern, origUser, isDomain, privSet);
        this.password = password;
    }

    public static GlobalPrivEntry create(String host, String user, boolean isDomain, byte[] password, PrivBitSet privs) throws AnalysisException {
        PatternMatcher hostPattern = PatternMatcher.createMysqlPattern(host, CaseSensibility.HOST.getCaseSensibility());
        PatternMatcher userPattern = PatternMatcher.createMysqlPattern(user, CaseSensibility.USER.getCaseSensibility());
        return new GlobalPrivEntry(hostPattern, host, userPattern, user, isDomain, password, privs);
    }

    public byte[] getPassword() {
        return this.password;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public void setDomainUserIdent(UserIdentity domainUserIdent) {
        this.domainUserIdent = domainUserIdent;
    }

    public UserIdentity getDomainUserIdent() {
        if (this.isSetByDomainResolver()) {
            return this.domainUserIdent;
        }
        return this.getUserIdent();
    }

    @Override
    public int compareTo(PrivEntry other) {
        if (!(other instanceof GlobalPrivEntry)) {
            throw new ClassCastException("cannot cast " + other.getClass().toString() + " to " + this.getClass());
        }
        GlobalPrivEntry otherEntry = (GlobalPrivEntry)other;
        int res = this.origHost.compareTo(otherEntry.origHost);
        if (res != 0) {
            return -res;
        }
        return -this.origUser.compareTo(otherEntry.origUser);
    }

    @Override
    public boolean keyMatch(PrivEntry other) {
        if (!(other instanceof GlobalPrivEntry)) {
            return false;
        }
        GlobalPrivEntry otherEntry = (GlobalPrivEntry)other;
        return this.origHost.equals(otherEntry.origHost) && this.origUser.equals(otherEntry.origUser) && this.isDomain == otherEntry.isDomain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("global priv. host: ").append(this.origHost).append(", user: ").append(this.origUser);
        sb.append(", priv: ").append(this.privSet).append(", set by resolver: ").append(this.isSetByDomainResolver);
        sb.append(", domain user ident: ").append(this.domainUserIdent);
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = GlobalPrivEntry.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        LOG.info("global priv: {}", (Object)this.toString());
        super.write(out);
        out.writeInt(this.password.length);
        out.write(this.password);
        this.isClassNameWrote = false;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int passwordLen = in.readInt();
        this.password = new byte[passwordLen];
        in.readFully(this.password);
    }
}

