/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.privilege.DbPrivEntry;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.mysql.privilege.PrivTable;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbPrivTable
extends PrivTable {
    private static final Logger LOG = LogManager.getLogger(DbPrivTable.class);

    public void getPrivs(UserIdentity currentUser, String db, PrivBitSet savedPrivs) {
        PrivEntry matchedEntry = null;
        for (PrivEntry entry : this.entries) {
            DbPrivEntry dbPrivEntry = (DbPrivEntry)entry;
            if (!dbPrivEntry.match(currentUser, true) || !dbPrivEntry.isAnyDb() && !dbPrivEntry.getDbPattern().match(db)) continue;
            matchedEntry = dbPrivEntry;
            break;
        }
        if (matchedEntry == null) {
            return;
        }
        savedPrivs.or(matchedEntry.getPrivSet());
    }

    public boolean hasPriv(String host, String user, PrivPredicate wanted) {
        for (PrivEntry entry : this.entries) {
            DbPrivEntry dbPrivEntry = (DbPrivEntry)entry;
            if (!dbPrivEntry.isAnyHost() && !dbPrivEntry.getHostPattern().match(host) || !dbPrivEntry.isAnyUser() && !dbPrivEntry.getUserPattern().match(user) || !dbPrivEntry.privSet.satisfy(wanted)) continue;
            return true;
        }
        return false;
    }

    public boolean hasClusterPriv(ConnectContext ctx, String clusterName) {
        for (PrivEntry entry : this.entries) {
            DbPrivEntry dbPrivEntry = (DbPrivEntry)entry;
            if (!dbPrivEntry.getOrigDb().startsWith(clusterName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = DbPrivTable.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        super.write(out);
    }
}

