/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;

public class DbPrivEntry
extends PrivEntry {
    protected static final String ANY_DB = "*";
    protected PatternMatcher dbPattern;
    protected String origDb;
    protected boolean isAnyDb;

    protected DbPrivEntry() {
    }

    protected DbPrivEntry(PatternMatcher hostPattern, String origHost, PatternMatcher dbPattern, String origDb, PatternMatcher userPattern, String user, boolean isDomain, PrivBitSet privSet) {
        super(hostPattern, origHost, userPattern, user, isDomain, privSet);
        this.dbPattern = dbPattern;
        this.origDb = origDb;
        if (origDb.equals(ANY_DB)) {
            this.isAnyDb = true;
        }
    }

    public static DbPrivEntry create(String host, String db, String user, boolean isDomain, PrivBitSet privs) throws AnalysisException {
        PatternMatcher hostPattern = PatternMatcher.createMysqlPattern(host, CaseSensibility.HOST.getCaseSensibility());
        PatternMatcher dbPattern = DbPrivEntry.createDbPatternMatcher(db);
        PatternMatcher userPattern = PatternMatcher.createMysqlPattern(user, CaseSensibility.USER.getCaseSensibility());
        if (privs.containsNodePriv() || privs.containsResourcePriv()) {
            throw new AnalysisException("Db privilege can not contains global or resource privileges: " + privs);
        }
        return new DbPrivEntry(hostPattern, host, dbPattern, db, userPattern, user, isDomain, privs);
    }

    private static PatternMatcher createDbPatternMatcher(String db) throws AnalysisException {
        boolean dbCaseSensibility = CaseSensibility.DATABASE.getCaseSensibility();
        if (ClusterNamespace.getNameFromFullName(db).equalsIgnoreCase("information_schema")) {
            dbCaseSensibility = false;
        }
        PatternMatcher dbPattern = PatternMatcher.createMysqlPattern(db.equals(ANY_DB) ? "%" : db, dbCaseSensibility);
        return dbPattern;
    }

    public PatternMatcher getDbPattern() {
        return this.dbPattern;
    }

    public String getOrigDb() {
        return this.origDb;
    }

    public boolean isAnyDb() {
        return this.isAnyDb;
    }

    @Override
    public int compareTo(PrivEntry other) {
        if (!(other instanceof DbPrivEntry)) {
            throw new ClassCastException("cannot cast " + other.getClass().toString() + " to " + this.getClass());
        }
        DbPrivEntry otherEntry = (DbPrivEntry)other;
        int res = this.origHost.compareTo(otherEntry.origHost);
        if (res != 0) {
            return -res;
        }
        res = this.origDb.compareTo(otherEntry.origDb);
        if (res != 0) {
            return -res;
        }
        return -this.origUser.compareTo(otherEntry.origUser);
    }

    @Override
    public boolean keyMatch(PrivEntry other) {
        if (!(other instanceof DbPrivEntry)) {
            return false;
        }
        DbPrivEntry otherEntry = (DbPrivEntry)other;
        return this.origHost.equals(otherEntry.origHost) && this.origUser.equals(otherEntry.origUser) && this.origDb.equals(otherEntry.origDb) && this.isDomain == otherEntry.isDomain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("db priv. host: ").append(this.origHost).append(", db: ").append(this.origDb);
        sb.append(", user: ").append(this.origUser);
        sb.append(", priv: ").append(this.privSet).append(", set by resolver: ").append(this.isSetByDomainResolver);
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = DbPrivEntry.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.origDb);
        this.isClassNameWrote = false;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.origDb = Text.readString((DataInput)in);
        try {
            this.dbPattern = DbPrivEntry.createDbPatternMatcher(this.origDb);
        }
        catch (AnalysisException e) {
            throw new IOException(e);
        }
        this.isAnyDb = this.origDb.equals(ANY_DB);
    }
}

