/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.resource.Tag;

public class CommonUserProperties
implements Writable {
    @SerializedName(value="maxConn")
    private long maxConn = 100L;
    @SerializedName(value="maxQueryInstances")
    private long maxQueryInstances = -1L;
    @SerializedName(value="sqlBlockRules")
    private String sqlBlockRules = "";
    @SerializedName(value="cpuResourceLimit")
    private int cpuResourceLimit = -1;
    @SerializedName(value="resourceTags")
    private Set<Tag> resourceTags = Sets.newHashSet();
    @SerializedName(value="execMemLimit")
    private long execMemLimit = -1L;
    @SerializedName(value="loadMemLimit")
    private long loadMemLimit = -1L;
    private String[] sqlBlockRulesSplit = new String[0];

    long getMaxConn() {
        return this.maxConn;
    }

    long getMaxQueryInstances() {
        return this.maxQueryInstances;
    }

    String getSqlBlockRules() {
        return this.sqlBlockRules;
    }

    String[] getSqlBlockRulesSplit() {
        return this.sqlBlockRulesSplit;
    }

    void setMaxConn(long maxConn) {
        this.maxConn = maxConn;
    }

    void setMaxQueryInstances(long maxQueryInstances) {
        this.maxQueryInstances = maxQueryInstances;
    }

    void setSqlBlockRules(String sqlBlockRules) {
        this.sqlBlockRules = sqlBlockRules;
        this.setSqlBlockRulesSplit(sqlBlockRules);
    }

    void setSqlBlockRulesSplit(String sqlBlockRules) {
        this.sqlBlockRulesSplit = sqlBlockRules.replace(" ", "").split(",");
    }

    public int getCpuResourceLimit() {
        return this.cpuResourceLimit;
    }

    public void setCpuResourceLimit(int cpuResourceLimit) {
        this.cpuResourceLimit = cpuResourceLimit;
    }

    public void setResourceTags(Set<Tag> resourceTags) {
        this.resourceTags = resourceTags;
    }

    public Set<Tag> getResourceTags() {
        return this.resourceTags;
    }

    public long getExecMemLimit() {
        return this.execMemLimit;
    }

    public void setExecMemLimit(long execMemLimit) {
        this.execMemLimit = execMemLimit;
    }

    public long getLoadMemLimit() {
        return this.loadMemLimit;
    }

    public void setLoadMemLimit(long loadMemLimit) {
        this.loadMemLimit = loadMemLimit;
    }

    public static CommonUserProperties read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        CommonUserProperties commonUserProperties = (CommonUserProperties)GsonUtils.GSON.fromJson(json, CommonUserProperties.class);
        commonUserProperties.setSqlBlockRulesSplit(commonUserProperties.getSqlBlockRules());
        return commonUserProperties;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }
}

