/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.nio;

import org.apache.doris.mysql.nio.NConnectContext;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ConnectProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xnio.ChannelListener;
import org.xnio.XnioIoThread;
import org.xnio.conduits.ConduitStreamSourceChannel;

public class ReadListener
implements ChannelListener<ConduitStreamSourceChannel> {
    private final Logger LOG = LogManager.getLogger(this.getClass());
    private NConnectContext ctx;
    private ConnectProcessor connectProcessor;

    public ReadListener(NConnectContext nConnectContext, ConnectProcessor connectProcessor) {
        this.ctx = nConnectContext;
        this.connectProcessor = connectProcessor;
    }

    public void handleEvent(ConduitStreamSourceChannel channel) {
        XnioIoThread.requireCurrentThread();
        this.ctx.suspendAcceptQuery();
        channel.getWorker().execute(() -> {
            this.ctx.setThreadLocalInfo();
            try {
                this.connectProcessor.processOnce();
                if (!this.ctx.isKilled()) {
                    this.ctx.resumeAcceptQuery();
                } else {
                    this.ctx.stopAcceptQuery();
                    this.ctx.cleanup();
                }
            }
            catch (Exception e) {
                this.LOG.warn("Exception happened in one session(" + this.ctx + ").", (Throwable)e);
                this.ctx.setKilled();
                this.ctx.cleanup();
            }
            finally {
                ConnectContext.remove();
            }
        });
    }
}

