/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import org.apache.doris.common.Config;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.mysql.MysqlServer;
import org.apache.doris.mysql.nio.AcceptListener;
import org.apache.doris.qe.ConnectScheduler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class NMysqlServer
extends MysqlServer {
    private final Logger LOG = LogManager.getLogger(this.getClass());
    private XnioWorker xnioWorker;
    private AcceptListener acceptListener;
    private AcceptingChannel<StreamConnection> server;
    private ExecutorService taskService = ThreadPoolManager.newDaemonCacheThreadPool(Config.max_mysql_service_task_threads_num, "doris-mysql-nio-pool", true);

    public NMysqlServer(int port, ConnectScheduler connectScheduler) {
        this.port = port;
        this.xnioWorker = Xnio.getInstance().createWorkerBuilder().setWorkerName("doris-mysql-nio").setWorkerIoThreads(Config.mysql_service_io_threads_num).setExternalExecutorService(this.taskService).build();
        this.acceptListener = new AcceptListener(connectScheduler);
    }

    @Override
    public boolean start() {
        try {
            this.server = this.xnioWorker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(this.port), (ChannelListener)this.acceptListener, OptionMap.create((Option)Options.TCP_NODELAY, (Object)true, (Option)Options.BACKLOG, (Object)Config.mysql_nio_backlog_num));
            this.server.resumeAccepts();
            this.running = true;
            this.LOG.info("Open mysql server success on {}", (Object)this.port);
            return true;
        }
        catch (IOException e) {
            this.LOG.warn("Open MySQL network service failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            this.running = false;
            try {
                this.server.close();
            }
            catch (IOException e) {
                this.LOG.warn("close server channel failed.", (Throwable)e);
            }
        }
    }

    public void setTaskService(ExecutorService taskService) {
        this.taskService = taskService;
    }
}

