/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.doris.mysql.MysqlChannel;
import org.apache.doris.mysql.nio.NConnectContext;
import org.apache.doris.mysql.nio.ReadListener;
import org.apache.doris.qe.ConnectProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;
import org.xnio.channels.Channels;
import org.xnio.channels.SuspendableWriteChannel;

public class NMysqlChannel
extends MysqlChannel {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private StreamConnection conn;

    public NMysqlChannel(StreamConnection connection) {
        this.conn = connection;
        if (connection.getPeerAddress() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)connection.getPeerAddress();
            this.remoteHostPortString = address.getHostString() + ":" + address.getPort();
            this.remoteIp = address.getAddress().getHostAddress();
        } else {
            this.remoteHostPortString = connection.getPeerAddress().toString();
            this.remoteIp = connection.getPeerAddress().toString();
        }
    }

    @Override
    protected int readAll(ByteBuffer dstBuf) {
        int readLen = 0;
        try {
            while (dstBuf.remaining() != 0) {
                int ret = Channels.readBlocking((ReadableByteChannel)this.conn.getSourceChannel(), (ByteBuffer)dstBuf);
                if (ret == -1) {
                    return readLen;
                }
                readLen += ret;
            }
        }
        catch (IOException e) {
            this.LOG.debug("Read channel exception, ignore.", (Throwable)e);
            return 0;
        }
        return readLen;
    }

    @Override
    protected void realNetSend(ByteBuffer buffer) throws IOException {
        long writeLen;
        long bufLen = buffer.remaining();
        if (bufLen != (writeLen = (long)Channels.writeBlocking((WritableByteChannel)this.conn.getSinkChannel(), (ByteBuffer)buffer))) {
            throw new IOException("Write mysql packet failed.[write=" + writeLen + ", needToWrite=" + bufLen + "]");
        }
        Channels.flushBlocking((SuspendableWriteChannel)this.conn.getSinkChannel());
        this.isSend = true;
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (IOException e) {
            this.LOG.warn("Close channel exception, ignore.");
        }
    }

    public void startAcceptQuery(NConnectContext nConnectContext, ConnectProcessor connectProcessor) {
        this.conn.getSourceChannel().setReadListener((ChannelListener)new ReadListener(nConnectContext, connectProcessor));
        this.conn.getSourceChannel().resumeReads();
    }

    public void suspendAcceptQuery() {
        this.conn.getSourceChannel().suspendReads();
    }

    public void resumeAcceptQuery() {
        this.conn.getSourceChannel().resumeReads();
    }

    public void stopAcceptQuery() throws IOException {
        this.conn.getSourceChannel().shutdownReads();
    }
}

