/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.nio;

import java.io.IOException;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.mysql.MysqlProto;
import org.apache.doris.mysql.nio.NConnectContext;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ConnectProcessor;
import org.apache.doris.qe.ConnectScheduler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;
import org.xnio.channels.AcceptingChannel;

public class AcceptListener
implements ChannelListener<AcceptingChannel<StreamConnection>> {
    private final Logger LOG = LogManager.getLogger(this.getClass());
    private ConnectScheduler connectScheduler;

    public AcceptListener(ConnectScheduler connectScheduler) {
        this.connectScheduler = connectScheduler;
    }

    public void handleEvent(AcceptingChannel<StreamConnection> channel) {
        try {
            StreamConnection connection = (StreamConnection)channel.accept();
            if (connection == null) {
                return;
            }
            this.LOG.debug("Connection established. remote={}", (Object)connection.getPeerAddress());
            NConnectContext context = new NConnectContext(connection);
            context.setCatalog(Catalog.getCurrentCatalog());
            this.connectScheduler.submit(context);
            channel.getWorker().execute(() -> {
                try {
                    context.setThreadLocalInfo();
                    context.setConnectScheduler(this.connectScheduler);
                    if (!MysqlProto.negotiate(context)) {
                        throw new AfterConnectedException("mysql negotiate failed");
                    }
                    if (!this.connectScheduler.registerConnection(context)) {
                        context.getState().setError(ErrorCode.ERR_TOO_MANY_USER_CONNECTIONS, "Reach limit of connections");
                        MysqlProto.sendResponsePacket(context);
                        throw new AfterConnectedException("Reach limit of connections");
                    }
                    MysqlProto.sendResponsePacket(context);
                    connection.setCloseListener(streamConnection -> this.connectScheduler.unregisterConnection(context));
                    context.setStartTime();
                    ConnectProcessor processor = new ConnectProcessor(context);
                    context.startAcceptQuery(processor);
                }
                catch (AfterConnectedException e) {
                    context.cleanup();
                }
                catch (Throwable e) {
                    if (context.getCurrentUserIdentity() != null) {
                        this.LOG.warn("connect processor exception because ", e);
                    } else if (e instanceof Error) {
                        this.LOG.error("connect processor exception because ", e);
                    } else {
                        this.LOG.debug("connect processor exception because ", e);
                    }
                    context.cleanup();
                }
                finally {
                    ConnectContext.remove();
                }
            });
        }
        catch (IOException e) {
            this.LOG.warn("Connection accept failed.", (Throwable)e);
        }
    }

    private static class AfterConnectedException
    extends Exception {
        public AfterConnectedException(String msg) {
            super(msg);
        }
    }
}

