/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ConnectScheduler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlServer {
    private static final Logger LOG = LogManager.getLogger(MysqlServer.class);
    protected int port;
    protected volatile boolean running;
    private ServerSocketChannel serverChannel = null;
    private ConnectScheduler scheduler = null;
    private ThreadPoolExecutor listener;
    private Future listenerFuture;

    public MysqlServer(int port, ConnectScheduler scheduler) {
        this.port = port;
        this.scheduler = scheduler;
    }

    protected MysqlServer() {
    }

    public boolean start() {
        if (this.scheduler == null) {
            LOG.warn("scheduler is NULL.");
            return false;
        }
        try {
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.socket().bind(new InetSocketAddress("0.0.0.0", this.port), 2048);
            this.serverChannel.configureBlocking(true);
        }
        catch (IOException e) {
            LOG.warn("Open MySQL network service failed.", (Throwable)e);
            return false;
        }
        this.listener = ThreadPoolManager.newDaemonCacheThreadPool(1, "MySQL-Protocol-Listener", true);
        this.running = true;
        this.listenerFuture = this.listener.submit(new Listener());
        return true;
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            try {
                this.serverChannel.close();
            }
            catch (IOException e) {
                LOG.warn("close server channel failed.", (Throwable)e);
            }
        }
    }

    public void join() {
        try {
            this.listenerFuture.get();
        }
        catch (Exception e) {
            LOG.warn("Join MySQL server exception.", (Throwable)e);
        }
    }

    public ConnectScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ConnectScheduler scheduler) {
        this.scheduler = scheduler;
    }

    private class Listener
    implements Runnable {
        private Listener() {
        }

        @Override
        public void run() {
            while (MysqlServer.this.running && MysqlServer.this.serverChannel.isOpen()) {
                try {
                    SocketChannel clientChannel = MysqlServer.this.serverChannel.accept();
                    if (clientChannel == null) continue;
                    ConnectContext context = new ConnectContext(clientChannel);
                    context.setCatalog(Catalog.getCurrentCatalog());
                    if (MysqlServer.this.scheduler.submit(context)) continue;
                    LOG.warn("Submit one connect request failed. Client=" + clientChannel.toString());
                    context.cleanup();
                }
                catch (IOException e) {
                    LOG.warn("Query server encounter exception.", (Throwable)e);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Query server failed when calling accept.", e);
                }
            }
        }
    }
}

