/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.mysql.MysqlCapability;

public class MysqlSerializer {
    private ByteArrayOutputStream out;
    private MysqlCapability capability;

    public MysqlSerializer(ByteArrayOutputStream out) {
        this(out, MysqlCapability.DEFAULT_CAPABILITY);
    }

    public MysqlSerializer(ByteArrayOutputStream out, MysqlCapability capability) {
        this.out = out;
        this.capability = capability;
    }

    public static MysqlSerializer newInstance() {
        return new MysqlSerializer(new ByteArrayOutputStream());
    }

    public static MysqlSerializer newInstance(MysqlCapability capability) {
        return new MysqlSerializer(new ByteArrayOutputStream(), capability);
    }

    public void setCapability(MysqlCapability capability) {
        this.capability = capability;
    }

    public MysqlCapability getCapability() {
        return this.capability;
    }

    public void writeByte(byte value) {
        this.out.write(value);
    }

    public void writeNull() {
        this.writeByte((byte)-5);
    }

    public void writeBytes(byte[] value, int offset, int length) {
        this.out.write(value, offset, length);
    }

    public void reset() {
        this.out.reset();
    }

    public byte[] toArray() {
        return this.out.toByteArray();
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.out.toByteArray());
    }

    public void writeBytes(byte[] value) {
        this.writeBytes(value, 0, value.length);
    }

    public void writeInt1(int value) {
        this.writeByte((byte)(value & 0xFF));
    }

    public void writeInt2(int value) {
        this.writeByte((byte)value);
        this.writeByte((byte)(value >> 8));
    }

    public void writeInt3(int value) {
        this.writeByte((byte)value);
        this.writeByte((byte)(value >> 8));
        this.writeByte((byte)(value >> 16));
    }

    public void writeInt4(int value) {
        this.writeByte((byte)value);
        this.writeByte((byte)(value >> 8));
        this.writeByte((byte)(value >> 16));
        this.writeByte((byte)(value >> 24));
    }

    public void writeInt6(long value) {
        this.writeInt4((int)value);
        this.writeInt2((byte)(value >> 32));
    }

    public void writeInt8(long value) {
        this.writeInt4((int)value);
        this.writeInt4((int)(value >> 32));
    }

    public void writeVInt(long value) {
        if (value < 251L) {
            this.writeByte((byte)value);
        } else if (value < 65536L) {
            this.writeInt1(252);
            this.writeInt2((int)value);
        } else if (value < 0x1000000L) {
            this.writeInt1(253);
            this.writeInt3((int)value);
        } else {
            this.writeInt1(254);
            this.writeInt8(value);
        }
    }

    public void writeLenEncodedString(String value) {
        try {
            byte[] buf = value.getBytes("UTF-8");
            this.writeVInt(buf.length);
            this.writeBytes(buf);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void writeEofString(String value) {
        try {
            byte[] buf = value.getBytes("UTF-8");
            this.writeBytes(buf);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void writeNulTerminateString(String value) {
        try {
            byte[] buf = value.getBytes("UTF-8");
            this.writeBytes(buf);
            this.writeByte((byte)0);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void writeField(String db, String table, Column column, boolean sendDefault) {
        this.writeLenEncodedString("def");
        this.writeLenEncodedString(db);
        this.writeLenEncodedString(table);
        this.writeLenEncodedString(table);
        this.writeLenEncodedString(column.getName());
        this.writeLenEncodedString(column.getName());
        this.writeVInt(12L);
        this.writeInt2(33);
        this.writeInt4(255);
        this.writeInt1(column.getDataType().toMysqlType().getCode());
        this.writeInt2(0);
        this.writeInt1(0);
        this.writeInt2(0);
        if (sendDefault) {
            this.writeLenEncodedString(Strings.nullToEmpty((String)column.getDefaultValue()));
        }
    }

    public void writeField(String colName, PrimitiveType type) {
        this.writeLenEncodedString("def");
        this.writeLenEncodedString("");
        this.writeLenEncodedString("");
        this.writeLenEncodedString("");
        this.writeLenEncodedString(colName);
        this.writeLenEncodedString(colName);
        this.writeVInt(12L);
        this.writeInt2(33);
        this.writeInt4(this.getMysqlTypeLength(type));
        this.writeInt1(type.toMysqlType().getCode());
        this.writeInt2(0);
        this.writeInt1(0);
        this.writeInt2(0);
    }

    private int getMysqlTypeLength(PrimitiveType type) {
        switch (type) {
            case BOOLEAN: {
                return 1;
            }
            case TINYINT: {
                return 4;
            }
            case SMALLINT: {
                return 6;
            }
            case INT: {
                return 11;
            }
            case BIGINT: {
                return 20;
            }
            case FLOAT: {
                return 12;
            }
            case DOUBLE: {
                return 22;
            }
            case TIME: {
                return 10;
            }
            case DATE: {
                return 10;
            }
            case DATETIME: {
                if (type.isTimeType()) {
                    return 10;
                }
                return 19;
            }
        }
        return 255;
    }
}

