/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.LdapConfig;
import org.apache.doris.ldap.LdapAuthenticate;
import org.apache.doris.ldap.LdapClient;
import org.apache.doris.mysql.MysqlAuthPacket;
import org.apache.doris.mysql.MysqlAuthSwitchPacket;
import org.apache.doris.mysql.MysqlCapability;
import org.apache.doris.mysql.MysqlChannel;
import org.apache.doris.mysql.MysqlClearTextPacket;
import org.apache.doris.mysql.MysqlHandshakePacket;
import org.apache.doris.mysql.MysqlPacket;
import org.apache.doris.mysql.MysqlSerializer;
import org.apache.doris.mysql.privilege.UserResource;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlProto {
    private static final Logger LOG = LogManager.getLogger(MysqlProto.class);

    private static boolean authenticate(ConnectContext context, byte[] scramble, byte[] randomString, String qualifiedUser) {
        String usePasswd = scramble.length == 0 ? "NO" : "YES";
        String remoteIp = context.getMysqlChannel().getRemoteIp();
        ArrayList currentUserIdentity = Lists.newArrayList();
        if (!Catalog.getCurrentCatalog().getAuth().checkPassword(qualifiedUser, remoteIp, scramble, randomString, currentUserIdentity)) {
            ErrorReport.report(ErrorCode.ERR_ACCESS_DENIED_ERROR, qualifiedUser, context.getRemoteIP(), usePasswd);
            return false;
        }
        context.setCurrentUserIdentity((UserIdentity)currentUserIdentity.get(0));
        context.setRemoteIP(remoteIp);
        return true;
    }

    private static String parseUser(ConnectContext context, byte[] scramble, String user) {
        String usePasswd = scramble.length == 0 ? "NO" : "YES";
        String tmpUser = user;
        if (tmpUser == null || tmpUser.isEmpty()) {
            ErrorReport.report(ErrorCode.ERR_ACCESS_DENIED_ERROR, "anonym@" + context.getRemoteIP(), usePasswd);
            return null;
        }
        String clusterName = "";
        String[] strList = tmpUser.split("@", 2);
        if (strList.length > 1) {
            tmpUser = strList[0];
            clusterName = strList[1];
            try {
                if (Catalog.getCurrentCatalog().getCluster(clusterName) == null && Integer.valueOf(strList[1]).intValue() != context.getCatalog().getClusterId()) {
                    ErrorReport.report(ErrorCode.ERR_UNKNOWN_CLUSTER_ID, strList[1]);
                    return null;
                }
            }
            catch (Throwable e) {
                ErrorReport.report(ErrorCode.ERR_UNKNOWN_CLUSTER_ID, strList[1]);
                return null;
            }
        }
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default_cluster";
        }
        context.setCluster(clusterName);
        strList = tmpUser.split("#", 2);
        if (strList.length > 1) {
            tmpUser = strList[0];
            if (UserResource.isValidGroup(strList[1])) {
                context.getSessionVariable().setResourceGroup(strList[1]);
            }
        }
        LOG.debug("parse cluster: {}", (Object)clusterName);
        String qualifiedUser = ClusterNamespace.getFullName(clusterName, tmpUser);
        context.setQualifiedUser(qualifiedUser);
        return qualifiedUser;
    }

    public static void sendResponsePacket(ConnectContext context) throws IOException {
        MysqlSerializer serializer = context.getSerializer();
        MysqlChannel channel = context.getMysqlChannel();
        MysqlPacket packet = context.getState().toResponsePacket();
        serializer.reset();
        packet.writeTo(serializer);
        channel.sendAndFlush(serializer.toByteBuffer());
    }

    private static boolean useLdapAuthenticate(String qualifiedUser) {
        if (qualifiedUser.equals("root") || qualifiedUser.equals("admin")) {
            return false;
        }
        return LdapConfig.ldap_authentication_enabled && LdapClient.doesUserExist(ClusterNamespace.getNameFromFullName(qualifiedUser));
    }

    public static boolean negotiate(ConnectContext context) throws IOException {
        String db;
        boolean useLdapAuthenticate;
        MysqlSerializer serializer = context.getSerializer();
        MysqlChannel channel = context.getMysqlChannel();
        context.getState().setOk();
        serializer.reset();
        MysqlHandshakePacket handshakePacket = new MysqlHandshakePacket(context.getConnectionId());
        handshakePacket.writeTo(serializer);
        try {
            channel.sendAndFlush(serializer.toByteBuffer());
        }
        catch (IOException e) {
            LOG.debug("Send and flush channel exception, ignore.", (Throwable)e);
            return false;
        }
        ByteBuffer handshakeResponse = channel.fetchOnePacket();
        if (handshakeResponse == null) {
            return false;
        }
        MysqlAuthPacket authPacket = new MysqlAuthPacket();
        if (!authPacket.readFrom(handshakeResponse)) {
            ErrorReport.report(ErrorCode.ERR_NOT_SUPPORTED_AUTH_MODE, new Object[0]);
            MysqlProto.sendResponsePacket(context);
            return false;
        }
        if (!MysqlCapability.isCompatible(context.getServerCapability(), authPacket.getCapability())) {
            ErrorReport.report(ErrorCode.ERR_NOT_SUPPORTED_AUTH_MODE, new Object[0]);
            MysqlProto.sendResponsePacket(context);
            return false;
        }
        context.setCapability(context.getServerCapability());
        serializer.setCapability(context.getCapability());
        String qualifiedUser = MysqlProto.parseUser(context, authPacket.getAuthResponse(), authPacket.getUser());
        if (qualifiedUser == null) {
            MysqlProto.sendResponsePacket(context);
            return false;
        }
        try {
            useLdapAuthenticate = MysqlProto.useLdapAuthenticate(qualifiedUser);
        }
        catch (Exception e) {
            LOG.debug("Check if user exists in ldap error.", (Throwable)e);
            MysqlProto.sendResponsePacket(context);
            return false;
        }
        if (useLdapAuthenticate) {
            LOG.debug("user:{} start to ldap authenticate.", (Object)qualifiedUser);
            serializer.reset();
            MysqlAuthSwitchPacket mysqlAuthSwitchPacket = new MysqlAuthSwitchPacket();
            mysqlAuthSwitchPacket.writeTo(serializer);
            channel.sendAndFlush(serializer.toByteBuffer());
            ByteBuffer authSwitchResponse = channel.fetchOnePacket();
            if (authSwitchResponse == null) {
                return false;
            }
            MysqlClearTextPacket clearTextPacket = new MysqlClearTextPacket();
            if (!clearTextPacket.readFrom(authSwitchResponse)) {
                ErrorReport.report(ErrorCode.ERR_NOT_SUPPORTED_AUTH_MODE, new Object[0]);
                MysqlProto.sendResponsePacket(context);
                return false;
            }
            if (!LdapAuthenticate.authenticate(context, clearTextPacket.getPassword(), qualifiedUser)) {
                MysqlProto.sendResponsePacket(context);
                return false;
            }
        } else {
            if (authPacket.getCapability().isPluginAuth() && !handshakePacket.checkAuthPluginSameAsDoris(authPacket.getPluginName())) {
                serializer.reset();
                handshakePacket.buildAuthSwitchRequest(serializer);
                channel.sendAndFlush(serializer.toByteBuffer());
                ByteBuffer authSwitchResponse = channel.fetchOnePacket();
                if (authSwitchResponse == null) {
                    return false;
                }
                authPacket.setAuthResponse(MysqlProto.readEofString(authSwitchResponse));
            }
            byte[] randomString = handshakePacket.getAuthPluginData();
            if (Config.proxy_auth_enable && authPacket.getRandomString() != null) {
                randomString = authPacket.getRandomString();
            }
            if (!MysqlProto.authenticate(context, authPacket.getAuthResponse(), randomString, qualifiedUser)) {
                MysqlProto.sendResponsePacket(context);
                return false;
            }
        }
        if (!Strings.isNullOrEmpty((String)(db = authPacket.getDb()))) {
            try {
                String dbFullName = ClusterNamespace.getFullName(context.getClusterName(), db);
                Catalog.getCurrentCatalog().changeDb(context, dbFullName);
            }
            catch (DdlException e) {
                MysqlProto.sendResponsePacket(context);
                return false;
            }
        }
        context.setResourceTags(Catalog.getCurrentCatalog().getAuth().getResourceTags(qualifiedUser));
        return true;
    }

    public static byte readByte(ByteBuffer buffer) {
        return buffer.get();
    }

    public static int readInt1(ByteBuffer buffer) {
        return MysqlProto.readByte(buffer) & 0xFF;
    }

    public static int readInt2(ByteBuffer buffer) {
        return MysqlProto.readByte(buffer) & 0xFF | (MysqlProto.readByte(buffer) & 0xFF) << 8;
    }

    public static int readInt3(ByteBuffer buffer) {
        return MysqlProto.readByte(buffer) & 0xFF | (MysqlProto.readByte(buffer) & 0xFF) << 8 | (MysqlProto.readByte(buffer) & 0xFF) << 16;
    }

    public static int readInt4(ByteBuffer buffer) {
        return MysqlProto.readByte(buffer) & 0xFF | (MysqlProto.readByte(buffer) & 0xFF) << 8 | (MysqlProto.readByte(buffer) & 0xFF) << 16 | (MysqlProto.readByte(buffer) & 0xFF) << 24;
    }

    public static long readInt6(ByteBuffer buffer) {
        return (long)MysqlProto.readInt4(buffer) & 0xFFFFFFFFL | (long)MysqlProto.readInt2(buffer) << 32;
    }

    public static long readInt8(ByteBuffer buffer) {
        return (long)MysqlProto.readInt4(buffer) & 0xFFFFFFFFL | (long)MysqlProto.readInt4(buffer) << 32;
    }

    public static long readVInt(ByteBuffer buffer) {
        int b = MysqlProto.readInt1(buffer);
        if (b < 251) {
            return b;
        }
        if (b == 252) {
            return MysqlProto.readInt2(buffer);
        }
        if (b == 253) {
            return MysqlProto.readInt3(buffer);
        }
        if (b == 254) {
            return MysqlProto.readInt8(buffer);
        }
        if (b == 251) {
            throw new NullPointerException();
        }
        return 0L;
    }

    public static byte[] readFixedString(ByteBuffer buffer, int len) {
        byte[] buf = new byte[len];
        buffer.get(buf);
        return buf;
    }

    public static byte[] readEofString(ByteBuffer buffer) {
        byte[] buf = new byte[buffer.remaining()];
        buffer.get(buf);
        return buf;
    }

    public static byte[] readLenEncodedString(ByteBuffer buffer) {
        long length = MysqlProto.readVInt(buffer);
        byte[] buf = new byte[(int)length];
        buffer.get(buf);
        return buf;
    }

    public static byte[] readNulTerminateString(ByteBuffer buffer) {
        int oldPos;
        int nullPos = oldPos = buffer.position();
        for (nullPos = oldPos; nullPos < buffer.limit() && buffer.get(nullPos) != 0; ++nullPos) {
        }
        byte[] buf = new byte[nullPos - oldPos];
        buffer.get(buf);
        buffer.get();
        return buf;
    }
}

