/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlPassword {
    private static final Logger LOG = LogManager.getLogger(MysqlPassword.class);
    public static final byte[] EMPTY_PASSWORD = new byte[0];
    public static final int SCRAMBLE_LENGTH = 20;
    public static final int SCRAMBLE_LENGTH_HEX_LENGTH = 41;
    public static final byte PVERSION41_CHAR = 42;
    private static final byte[] DIG_VEC_UPPER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static Random random = new Random(System.currentTimeMillis());

    public static byte[] createRandomString(int len) {
        byte[] bytes = new byte[len];
        random.nextBytes(bytes);
        for (int i = 0; i < len; ++i) {
            if (bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 65 && bytes[i] <= 90) continue;
            bytes[i] = (byte)(97 + bytes[i] % 26);
        }
        return bytes;
    }

    private static byte[] xorCrypt(byte[] s1, byte[] s2) {
        if (s1.length != s2.length) {
            return null;
        }
        byte[] res = new byte[s1.length];
        for (int i = 0; i < s1.length; ++i) {
            res[i] = (byte)(s1[i] ^ s2[i]);
        }
        return res;
    }

    public static boolean checkScramble(byte[] scramble, byte[] message, byte[] hashStage2) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("No SHA-1 Algorithm when compute password.");
            return false;
        }
        md.update(message);
        md.update(hashStage2);
        byte[] hashStage1 = MysqlPassword.xorCrypt(md.digest(), scramble);
        md.reset();
        byte[] candidateHash2 = md.digest(hashStage1);
        return Arrays.equals(candidateHash2, hashStage2);
    }

    public static byte[] scramble(byte[] seed, String password) {
        byte[] scramblePassword = null;
        try {
            byte[] passBytes = password.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hashStage1 = md.digest(passBytes);
            md.reset();
            byte[] hashStage2 = md.digest(hashStage1);
            md.reset();
            md.update(seed);
            scramblePassword = MysqlPassword.xorCrypt(hashStage1, md.digest(hashStage2));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("No UTF-8 character set when compute password.");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("No SHA-1 Algorithm when compute password.");
        }
        return scramblePassword;
    }

    private static byte[] twoStageHash(String password) {
        try {
            byte[] passBytes = password.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hashStage1 = md.digest(passBytes);
            md.reset();
            byte[] hashStage2 = md.digest(hashStage1);
            return hashStage2;
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("No UTF-8 character set when compute password.");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("No SHA-1 Algorithm when compute password.");
        }
        return null;
    }

    private static void octetToHexSafe(byte[] to, int toOff, byte[] from) {
        int j = toOff;
        for (int i = 0; i < from.length; ++i) {
            int val = from[i] & 0xFF;
            to[j++] = DIG_VEC_UPPER[val >> 4];
            to[j++] = DIG_VEC_UPPER[val & 0xF];
        }
    }

    private static int fromByte(int b) {
        return b >= 48 && b <= 57 ? b - 48 : (b >= 65 && b <= 70 ? b - 65 + 10 : b - 97 + 10);
    }

    private static void hexToOctetSafe(byte[] to, byte[] from, int fromOff) {
        int j = 0;
        for (int i = fromOff; i < from.length; ++i) {
            int val = MysqlPassword.fromByte(from[i++] & 0xFF);
            to[j++] = (byte)((val << 4) + MysqlPassword.fromByte(from[i] & 0xFF));
        }
    }

    public static byte[] makeScrambledPassword(String plainPasswd) {
        if (Strings.isNullOrEmpty((String)plainPasswd)) {
            return EMPTY_PASSWORD;
        }
        byte[] hashStage2 = MysqlPassword.twoStageHash(plainPasswd);
        byte[] passwd = new byte[41];
        passwd[0] = 42;
        MysqlPassword.octetToHexSafe(passwd, 1, hashStage2);
        return passwd;
    }

    public static byte[] getSaltFromPassword(byte[] password) {
        if (password == null || password.length == 0) {
            return EMPTY_PASSWORD;
        }
        byte[] hashStage2 = new byte[20];
        MysqlPassword.hexToOctetSafe(hashStage2, password, 1);
        return hashStage2;
    }

    public static boolean checkPlainPass(byte[] scrambledPass, String plainPass) {
        byte[] pass = MysqlPassword.makeScrambledPassword(plainPass);
        if (pass.length != scrambledPass.length) {
            return false;
        }
        for (int i = 0; i < pass.length; ++i) {
            if (pass[i] == scrambledPass[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] checkPassword(String passwdString) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)passwdString)) {
            return EMPTY_PASSWORD;
        }
        byte[] passwd = null;
        try {
            passwdString = passwdString.toUpperCase();
            passwd = passwdString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_ERROR, new Object[0]);
        }
        if (passwd.length != 41 || passwd[0] != 42) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_PASSWD_LENGTH, 41);
        }
        for (int i = 1; i < passwd.length; ++i) {
            if (passwd[i] <= 57 && passwd[i] >= 48 || passwd[i] >= 65 && passwd[i] <= 70) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_PASSWD_LENGTH, 41);
        }
        return passwd;
    }
}

