/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import com.google.common.base.Strings;
import org.apache.doris.mysql.MysqlCapability;
import org.apache.doris.mysql.MysqlPacket;
import org.apache.doris.mysql.MysqlSerializer;
import org.apache.doris.qe.QueryState;

public class MysqlOkPacket
extends MysqlPacket {
    private static final int PACKET_OK_INDICATOR = 0;
    private static final long LAST_INSERT_ID = 0L;
    private final String infoMessage;
    private long affectedRows = 0L;
    private int warningRows = 0;
    private int serverStatus = 0;

    public MysqlOkPacket(QueryState state) {
        this.infoMessage = state.getInfoMessage();
        this.affectedRows = state.getAffectedRows();
        this.warningRows = state.getWarningRows();
        this.serverStatus = state.serverStatus;
    }

    @Override
    public void writeTo(MysqlSerializer serializer) {
        MysqlCapability capability = serializer.getCapability();
        serializer.writeInt1(0);
        serializer.writeVInt(this.affectedRows);
        serializer.writeVInt(0L);
        if (capability.isProtocol41()) {
            serializer.writeInt2(this.serverStatus);
            serializer.writeInt2(this.warningRows);
        } else if (capability.isTransactions()) {
            serializer.writeInt2(this.serverStatus);
        }
        if (capability.isSessionTrack()) {
            serializer.writeLenEncodedString(this.infoMessage);
        } else if (!Strings.isNullOrEmpty((String)this.infoMessage)) {
            serializer.writeLenEncodedString(this.infoMessage);
        }
    }
}

