/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import org.apache.doris.mysql.MysqlCapability;
import org.apache.doris.mysql.MysqlPacket;
import org.apache.doris.mysql.MysqlPassword;
import org.apache.doris.mysql.MysqlSerializer;

public class MysqlHandshakePacket
extends MysqlPacket {
    private static final int SCRAMBLE_LENGTH = 20;
    private static final int PROTOCOL_VERSION = 10;
    public static final String SERVER_VERSION = "5.7.37";
    private static final int CHARACTER_SET = 33;
    private static final MysqlCapability CAPABILITY = MysqlCapability.DEFAULT_CAPABILITY;
    private static final int STATUS_FLAGS = 0;
    private static final String AUTH_PLUGIN_NAME = "mysql_native_password";
    private int connectionId;
    private byte[] authPluginData;

    public MysqlHandshakePacket(int connectionId) {
        this.connectionId = connectionId;
        this.authPluginData = MysqlPassword.createRandomString(20);
    }

    public byte[] getAuthPluginData() {
        return this.authPluginData;
    }

    @Override
    public void writeTo(MysqlSerializer serializer) {
        MysqlCapability capability = CAPABILITY;
        serializer.writeInt1(10);
        serializer.writeNulTerminateString(SERVER_VERSION);
        serializer.writeInt4(this.connectionId);
        serializer.writeBytes(this.authPluginData, 0, 8);
        serializer.writeInt1(0);
        serializer.writeInt2(capability.getFlags() & 0xFFFF);
        serializer.writeInt1(33);
        serializer.writeInt2(0);
        serializer.writeInt2(capability.getFlags() >> 16);
        if (capability.isPluginAuth()) {
            serializer.writeInt1(this.authPluginData.length + 1);
        } else {
            serializer.writeInt1(0);
        }
        serializer.writeBytes(new byte[10]);
        if (capability.isSecureConnection()) {
            serializer.writeBytes(this.authPluginData, 8, 12);
            serializer.writeInt1(0);
        }
        if (capability.isPluginAuth()) {
            serializer.writeNulTerminateString(AUTH_PLUGIN_NAME);
        }
    }

    public boolean checkAuthPluginSameAsDoris(String pluginName) {
        return AUTH_PLUGIN_NAME.equals(pluginName);
    }

    public void buildAuthSwitchRequest(MysqlSerializer serializer) {
        serializer.writeInt1(-2);
        serializer.writeNulTerminateString(AUTH_PLUGIN_NAME);
        serializer.writeBytes(this.authPluginData);
        serializer.writeInt1(0);
    }
}

