/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import org.apache.doris.common.ErrorCode;
import org.apache.doris.mysql.MysqlCapability;
import org.apache.doris.mysql.MysqlPacket;
import org.apache.doris.mysql.MysqlSerializer;
import org.apache.doris.qe.QueryState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlErrPacket
extends MysqlPacket {
    private static final Logger LOG = LogManager.getLogger(MysqlErrPacket.class);
    private static final int ERROR_PACKET_INDICATOR = 255;
    private byte[] sqlState = new byte[]{72, 89, 48, 48, 48};
    private int errorCode = 1064;
    private String errorMessage;

    public MysqlErrPacket(QueryState state) {
        this.errorMessage = state.getErrorMessage();
        ErrorCode code = state.getErrorCode();
        if (code != null) {
            this.errorCode = code.getCode();
            this.sqlState = code.getSqlState();
        }
    }

    @Override
    public void writeTo(MysqlSerializer serializer) {
        MysqlCapability capability = serializer.getCapability();
        serializer.writeInt1(255);
        serializer.writeInt2(this.errorCode);
        if (capability.isProtocol41()) {
            serializer.writeByte((byte)35);
            serializer.writeBytes(this.sqlState, 0, 5);
        }
        if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            serializer.writeEofString("Unknown error");
        } else {
            serializer.writeEofString(this.errorMessage);
        }
    }
}

