/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import org.apache.doris.analysis.Expr;
import org.apache.doris.mysql.MysqlColType;
import org.apache.doris.mysql.MysqlSerializer;

public class MysqlColDef {
    private static final String CATALOG = "def";
    private static final int CHARACTER_SET = 33;
    private static final String SCHEMA = "";
    private static final String TABLE = "";
    private static final String ORIG_TABLE = "";
    private static final int FLAGS = 0;
    private static final int DECIMALS = 0;
    private String name;
    private String origName;
    private int colLen;
    private int colType;
    private String defaultValue;

    public static MysqlColDef fromExpr(Expr expr, String alias) {
        MysqlColDef def = new MysqlColDef();
        def.name = alias;
        def.origName = alias;
        MysqlColType type = expr.getType().getPrimitiveType().toMysqlType();
        def.colType = type.getCode();
        def.colLen = 255;
        return def;
    }

    public static MysqlColDef fromName(String alias) {
        MysqlColDef def = new MysqlColDef();
        def.name = alias;
        def.origName = alias;
        def.colType = MysqlColType.MYSQL_TYPE_STRING.getCode();
        def.colLen = 255;
        return def;
    }

    public void writeTo(MysqlSerializer serializer) {
        serializer.writeLenEncodedString(CATALOG);
        serializer.writeLenEncodedString("");
        serializer.writeLenEncodedString("");
        serializer.writeLenEncodedString("");
        serializer.writeLenEncodedString(this.name);
        serializer.writeLenEncodedString(this.origName);
        serializer.writeVInt(12L);
        serializer.writeInt2(33);
        serializer.writeInt4(this.colLen);
        serializer.writeInt1(this.colType);
        serializer.writeInt2(0);
        serializer.writeInt1(0);
        serializer.writeInt2(0);
    }
}

