/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlChannel {
    public static final int MAX_PHYSICAL_PACKET_LENGTH = 0xFFFFFF;
    protected static final int PACKET_HEADER_LEN = 4;
    protected static final Logger LOG = LogManager.getLogger(MysqlChannel.class);
    protected int sequenceId = 0;
    protected SocketChannel channel;
    protected ByteBuffer headerByteBuffer = ByteBuffer.allocate(4);
    protected ByteBuffer defaultBuffer = ByteBuffer.allocate(16384);
    protected ByteBuffer sendBuffer;
    protected String remoteHostPortString;
    protected String remoteIp;
    protected boolean isSend;

    protected MysqlChannel() {
        this.sendBuffer = ByteBuffer.allocate(0x200000);
        this.isSend = false;
        this.remoteHostPortString = "";
        this.remoteIp = "";
    }

    public MysqlChannel(SocketChannel channel) {
        this.channel = channel;
        this.sendBuffer = ByteBuffer.allocate(0x200000);
        this.isSend = false;
        this.remoteHostPortString = "";
        this.remoteIp = "";
        if (channel != null) {
            try {
                if (channel.getRemoteAddress() instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)channel.getRemoteAddress();
                    this.remoteHostPortString = address.getHostString() + ":" + address.getPort();
                    this.remoteIp = address.getAddress().getHostAddress();
                } else {
                    this.remoteHostPortString = channel.getRemoteAddress().toString();
                    this.remoteIp = channel.getRemoteAddress().toString();
                }
            }
            catch (Exception e) {
                LOG.warn("get remote host string failed: ", (Throwable)e);
            }
        }
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    private int packetId() {
        byte[] header = this.headerByteBuffer.array();
        return header[3] & 0xFF;
    }

    private int packetLen() {
        byte[] header = this.headerByteBuffer.array();
        return header[0] & 0xFF | (header[1] & 0xFF) << 8 | (header[2] & 0xFF) << 16;
    }

    private void accSequenceId() {
        ++this.sequenceId;
        if (this.sequenceId > 255) {
            this.sequenceId = 0;
        }
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            LOG.warn("Close channel exception, ignore.");
        }
    }

    protected int readAll(ByteBuffer dstBuf) throws IOException {
        int readLen = 0;
        while (dstBuf.remaining() != 0) {
            int ret = this.channel.read(dstBuf);
            if (ret == -1) {
                return readLen;
            }
            readLen += ret;
        }
        return readLen;
    }

    public ByteBuffer fetchOnePacket() throws IOException {
        int packetLen;
        ByteBuffer result = this.defaultBuffer;
        result.clear();
        do {
            this.headerByteBuffer.clear();
            int readLen = this.readAll(this.headerByteBuffer);
            if (readLen != 4) {
                LOG.debug("Receive packet header failed, remote may close the channel.");
                return null;
            }
            if (this.packetId() != this.sequenceId) {
                LOG.warn("receive packet sequence id[" + this.packetId() + "] want to get[" + this.sequenceId + "]");
                throw new IOException("Bad packet sequence.");
            }
            packetLen = this.packetLen();
            if (result.capacity() - result.position() < packetLen) {
                ByteBuffer tmp = packetLen < 0xFFFFFF ? ByteBuffer.allocate(packetLen + result.position()) : ByteBuffer.allocate(2 * packetLen + result.position());
                tmp.put(result.array(), 0, result.position());
                result = tmp;
            }
            result.limit(result.position() + packetLen);
            readLen = this.readAll(result);
            if (readLen != packetLen) {
                LOG.warn("Length of received packet content(" + readLen + ") is not equal with length in head.(" + packetLen + ")");
                return null;
            }
            this.accSequenceId();
        } while (packetLen == 0xFFFFFF);
        result.flip();
        return result;
    }

    protected void realNetSend(ByteBuffer buffer) throws IOException {
        long writeLen;
        long bufLen = buffer.remaining();
        if (bufLen != (writeLen = (long)this.channel.write(buffer))) {
            throw new IOException("Write mysql packet failed.[write=" + writeLen + ", needToWrite=" + bufLen + "]");
        }
        this.channel.write(buffer);
        this.isSend = true;
    }

    public void flush() throws IOException {
        if (null == this.sendBuffer || this.sendBuffer.position() == 0) {
            return;
        }
        this.sendBuffer.flip();
        this.realNetSend(this.sendBuffer);
        this.sendBuffer.clear();
        this.isSend = true;
    }

    private void writeHeader(int length) throws IOException {
        if (null == this.sendBuffer) {
            return;
        }
        long leftLength = this.sendBuffer.capacity() - this.sendBuffer.position();
        if (leftLength < 4L) {
            this.flush();
        }
        long newLen = length;
        for (int i = 0; i < 3; ++i) {
            this.sendBuffer.put((byte)newLen);
            newLen >>= 8;
        }
        this.sendBuffer.put((byte)this.sequenceId);
    }

    private void writeBuffer(ByteBuffer buffer) throws IOException {
        if (null == this.sendBuffer) {
            return;
        }
        long leftLength = this.sendBuffer.capacity() - this.sendBuffer.position();
        if (leftLength < (long)buffer.remaining()) {
            this.flush();
        }
        if (buffer.remaining() > this.sendBuffer.capacity()) {
            this.realNetSend(buffer);
            return;
        }
        this.sendBuffer.put(buffer);
    }

    public void sendOnePacket(ByteBuffer packet) throws IOException {
        int oldLimit = packet.limit();
        while (oldLimit - packet.position() >= 0xFFFFFF) {
            int bufLen = 0xFFFFFF;
            packet.limit(packet.position() + bufLen);
            this.writeHeader(bufLen);
            this.writeBuffer(packet);
            this.accSequenceId();
        }
        this.writeHeader(oldLimit - packet.position());
        packet.limit(oldLimit);
        this.writeBuffer(packet);
        this.accSequenceId();
    }

    public void sendAndFlush(ByteBuffer packet) throws IOException {
        this.sendOnePacket(packet);
        this.flush();
    }

    public void reset() {
        this.isSend = false;
        if (null != this.sendBuffer) {
            this.sendBuffer.clear();
        }
    }

    public boolean isSend() {
        return this.isSend;
    }

    public String getRemoteHostPortString() {
        return this.remoteHostPortString;
    }
}

