/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import java.util.EnumSet;

public class MysqlCapability {
    private static final EnumSet<Flag> FLAG_SET = EnumSet.allOf(Flag.class);
    private static final int DEFAULT_FLAGS = Flag.CLIENT_PROTOCOL_41.getFlagBit() | Flag.CLIENT_CONNECT_WITH_DB.getFlagBit() | Flag.CLIENT_SECURE_CONNECTION.getFlagBit() | Flag.CLIENT_PLUGIN_AUTH.getFlagBit();
    public static final MysqlCapability DEFAULT_CAPABILITY = new MysqlCapability(DEFAULT_FLAGS);
    private int flags;

    public MysqlCapability(int flags) {
        this.flags = flags;
    }

    public static boolean isCompatible(MysqlCapability server, MysqlCapability client) {
        return true;
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        for (Flag flag : FLAG_SET) {
            if ((this.flags & flag.getFlagBit()) == 0) continue;
            if (idx != 0) {
                sb.append(" | ");
            }
            sb.append(flag.getComment());
            ++idx;
        }
        return sb.toString();
    }

    public boolean isProtocol41() {
        return (this.flags & Flag.CLIENT_PROTOCOL_41.getFlagBit()) != 0;
    }

    public boolean isTransactions() {
        return (this.flags & Flag.CLIENT_TRANSACTIONS.getFlagBit()) != 0;
    }

    public boolean isConnectedWithDb() {
        return (this.flags & Flag.CLIENT_CONNECT_WITH_DB.getFlagBit()) != 0;
    }

    public boolean isPluginAuthDataLengthEncoded() {
        return (this.flags & Flag.CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA.getFlagBit()) != 0;
    }

    public boolean isConnectAttrs() {
        return (this.flags & Flag.CLIENT_CONNECT_ATTRS.getFlagBit()) != 0;
    }

    public boolean isPluginAuth() {
        return (this.flags & Flag.CLIENT_PLUGIN_AUTH.getFlagBit()) != 0;
    }

    public boolean isSecureConnection() {
        return (this.flags & Flag.CLIENT_SECURE_CONNECTION.getFlagBit()) != 0;
    }

    public boolean isSessionTrack() {
        return (this.flags & Flag.CLIENT_SESSION_TRACK.getFlagBit()) != 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MysqlCapability)) {
            return false;
        }
        return this.flags == ((MysqlCapability)obj).flags;
    }

    public static enum Flag {
        CLIENT_LONG_PASSWORD(1, "CLIENT_LONG_PASSWORD"),
        CLIENT_FOUND_ROWS(2, "CLIENT_FOUND_ROWS"),
        CLIENT_LONG_FLAG(4, "CLIENT_LONG_FLAG"),
        CLIENT_CONNECT_WITH_DB(8, "CLIENT_CONNECT_WITH_DB"),
        CLIENT_NO_SCHEMA(16, "CLIENT_NO_SCHEMA"),
        CLIENT_COMPRESS(32, "CLIENT_COMPRESS"),
        CLIENT_ODBC(64, "CLIENT_ODBC"),
        CLIENT_LOCAL_FILES(128, "CLIENT_LOCAL_FILES"),
        CLIENT_IGNORE_SPACE(256, "CLIENT_IGNORE_SPACE"),
        CLIENT_PROTOCOL_41(512, "CLIENT_PROTOCOL_41"),
        CLIENT_INTERACTIVE(1024, "CLIENT_INTERACTIVE"),
        CLIENT_SSL(2048, "CLIENT_SSL"),
        CLIENT_IGNORE_SIGPIPE(4096, "CLIENT_IGNORE_SIGPIPE"),
        CLIENT_TRANSACTIONS(8192, "CLIENT_TRANSACTIONS"),
        CLIENT_RESERVED(16384, "CLIENT_RESERVED"),
        CLIENT_SECURE_CONNECTION(32768, "CLIENT_SECURE_CONNECTION"),
        CLIENT_MULTI_STATEMENTS(65536, "CLIENT_MULTI_STATEMENTS"),
        CLIENT_MULTI_RESULTS(131072, "CLIENT_MULTI_RESULTS"),
        CLIENT_PS_MULTI_RESULTS(262144, "CLIENT_PS_MULTI_RESULTS"),
        CLIENT_PLUGIN_AUTH(524288, "CLIENT_PLUGIN_AUTH"),
        CLIENT_CONNECT_ATTRS(0x100000, "CLIENT_CONNECT_ATTRS"),
        CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA(0x200000, "CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA"),
        CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS(0x400000, "CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS"),
        CLIENT_SESSION_TRACK(0x800000, "CLIENT_SESSION_TRACK"),
        CLIENT_DEPRECATE_EOF(0x1000000, "CLIENT_DEPRECATE_EOF");

        private int flagBit;
        private String description;

        private Flag(int flagBit, String description) {
            this.flagBit = flagBit;
            this.description = description;
        }

        public int getFlagBit() {
            return this.flagBit;
        }

        public String getComment() {
            return this.description;
        }

        public String toString() {
            return this.getComment();
        }
    }
}

