/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.doris.common.Config;
import org.apache.doris.mysql.MysqlCapability;
import org.apache.doris.mysql.MysqlPacket;
import org.apache.doris.mysql.MysqlProto;
import org.apache.doris.mysql.MysqlSerializer;

public class MysqlAuthPacket
extends MysqlPacket {
    private int maxPacketSize;
    private int characterSet;
    private String userName;
    private byte[] authResponse;
    private String database;
    private String pluginName;
    private MysqlCapability capability;
    private Map<String, String> connectAttributes;
    private byte[] randomString;

    public String getUser() {
        return this.userName;
    }

    public byte[] getAuthResponse() {
        return this.authResponse;
    }

    public void setAuthResponse(byte[] bytes) {
        this.authResponse = bytes;
    }

    public String getDb() {
        return this.database;
    }

    public byte[] getRandomString() {
        return this.randomString;
    }

    public MysqlCapability getCapability() {
        return this.capability;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public boolean readFrom(ByteBuffer buffer) {
        this.capability = new MysqlCapability(MysqlProto.readInt4(buffer));
        if (!this.capability.isProtocol41()) {
            return false;
        }
        this.maxPacketSize = MysqlProto.readInt4(buffer);
        this.characterSet = MysqlProto.readInt1(buffer);
        if (new String(MysqlProto.readFixedString(buffer, 3)).equals(Config.proxy_auth_magic_prefix)) {
            this.randomString = new byte[20];
            buffer.get(this.randomString);
        } else {
            buffer.position(buffer.position() + 20);
        }
        this.userName = new String(MysqlProto.readNulTerminateString(buffer));
        if (this.capability.isPluginAuthDataLengthEncoded()) {
            this.authResponse = MysqlProto.readLenEncodedString(buffer);
        } else if (this.capability.isSecureConnection()) {
            int len = MysqlProto.readInt1(buffer);
            this.authResponse = MysqlProto.readFixedString(buffer, len);
        } else {
            this.authResponse = MysqlProto.readNulTerminateString(buffer);
        }
        if (buffer.remaining() > 0 && this.capability.isConnectedWithDb()) {
            this.database = new String(MysqlProto.readNulTerminateString(buffer));
        }
        if (buffer.remaining() > 0 && this.capability.isPluginAuth()) {
            this.pluginName = new String(MysqlProto.readNulTerminateString(buffer));
        }
        if (buffer.remaining() > 0 && this.capability.isConnectAttrs()) {
            this.connectAttributes = Maps.newHashMap();
            long numPair = MysqlProto.readVInt(buffer);
            for (long i = 0L; i < numPair; ++i) {
                String key = new String(MysqlProto.readLenEncodedString(buffer));
                String value = new String(MysqlProto.readLenEncodedString(buffer));
                this.connectAttributes.put(key, value);
            }
        }
        return true;
    }

    @Override
    public void writeTo(MysqlSerializer serializer) {
    }
}

