/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.monitor.unit;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.doris.monitor.utils.Strings;

public class TimeValue
implements Comparable<TimeValue> {
    public static final long NSEC_PER_MSEC = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private static Map<TimeUnit, Byte> TIME_UNIT_BYTE_MAP;
    private static Map<Byte, TimeUnit> BYTE_TIME_UNIT_MAP;
    public static final TimeValue MINUS_ONE;
    public static final TimeValue ZERO;
    private final long duration;
    private final TimeUnit timeUnit;
    private static final long C0 = 1L;
    private static final long C1 = 1000L;
    private static final long C2 = 1000000L;
    private static final long C3 = 1000000000L;
    private static final long C4 = 60000000000L;
    private static final long C5 = 3600000000000L;
    private static final long C6 = 86400000000000L;

    public static TimeValue timeValueNanos(long nanos) {
        return new TimeValue(nanos, TimeUnit.NANOSECONDS);
    }

    public static TimeValue timeValueMillis(long millis) {
        return new TimeValue(millis, TimeUnit.MILLISECONDS);
    }

    public static TimeValue timeValueSeconds(long seconds) {
        return new TimeValue(seconds, TimeUnit.SECONDS);
    }

    public static TimeValue timeValueMinutes(long minutes) {
        return new TimeValue(minutes, TimeUnit.MINUTES);
    }

    public static TimeValue timeValueHours(long hours) {
        return new TimeValue(hours, TimeUnit.HOURS);
    }

    long duration() {
        return this.duration;
    }

    TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public TimeValue(long millis) {
        this(millis, TimeUnit.MILLISECONDS);
    }

    public TimeValue(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public long nanos() {
        return this.timeUnit.toNanos(this.duration);
    }

    public long getNanos() {
        return this.nanos();
    }

    public long micros() {
        return this.timeUnit.toMicros(this.duration);
    }

    public long getMicros() {
        return this.micros();
    }

    public long millis() {
        return this.timeUnit.toMillis(this.duration);
    }

    public long getMillis() {
        return this.millis();
    }

    public long seconds() {
        return this.timeUnit.toSeconds(this.duration);
    }

    public long getSeconds() {
        return this.seconds();
    }

    public long minutes() {
        return this.timeUnit.toMinutes(this.duration);
    }

    public long getMinutes() {
        return this.minutes();
    }

    public long hours() {
        return this.timeUnit.toHours(this.duration);
    }

    public long getHours() {
        return this.hours();
    }

    public long days() {
        return this.timeUnit.toDays(this.duration);
    }

    public long getDays() {
        return this.days();
    }

    public double microsFrac() {
        return (double)this.nanos() / 1000.0;
    }

    public double getMicrosFrac() {
        return this.microsFrac();
    }

    public double millisFrac() {
        return (double)this.nanos() / 1000000.0;
    }

    public double getMillisFrac() {
        return this.millisFrac();
    }

    public double secondsFrac() {
        return (double)this.nanos() / 1.0E9;
    }

    public double getSecondsFrac() {
        return this.secondsFrac();
    }

    public double minutesFrac() {
        return (double)this.nanos() / 6.0E10;
    }

    public double getMinutesFrac() {
        return this.minutesFrac();
    }

    public double hoursFrac() {
        return (double)this.nanos() / 3.6E12;
    }

    public double getHoursFrac() {
        return this.hoursFrac();
    }

    public double daysFrac() {
        return (double)this.nanos() / 8.64E13;
    }

    public double getDaysFrac() {
        return this.daysFrac();
    }

    public String toString() {
        if (this.duration < 0L) {
            return Long.toString(this.duration);
        }
        long nanos = this.nanos();
        if (nanos == 0L) {
            return "0s";
        }
        double value = nanos;
        String suffix = "nanos";
        if (nanos >= 86400000000000L) {
            value = this.daysFrac();
            suffix = "d";
        } else if (nanos >= 3600000000000L) {
            value = this.hoursFrac();
            suffix = "h";
        } else if (nanos >= 60000000000L) {
            value = this.minutesFrac();
            suffix = "m";
        } else if (nanos >= 1000000000L) {
            value = this.secondsFrac();
            suffix = "s";
        } else if (nanos >= 1000000L) {
            value = this.millisFrac();
            suffix = "ms";
        } else if (nanos >= 1000L) {
            value = this.microsFrac();
            suffix = "micros";
        }
        return Strings.format1Decimals(value, suffix);
    }

    public String getStringRep() {
        if (this.duration < 0L) {
            return Long.toString(this.duration);
        }
        switch (this.timeUnit) {
            case NANOSECONDS: {
                return this.duration + "nanos";
            }
            case MICROSECONDS: {
                return this.duration + "micros";
            }
            case MILLISECONDS: {
                return this.duration + "ms";
            }
            case SECONDS: {
                return this.duration + "s";
            }
            case MINUTES: {
                return this.duration + "m";
            }
            case HOURS: {
                return this.duration + "h";
            }
            case DAYS: {
                return this.duration + "d";
            }
        }
        throw new IllegalArgumentException("unknown time unit: " + this.timeUnit.name());
    }

    public static TimeValue parseTimeValue(String sValue, String settingName) throws Exception {
        Objects.requireNonNull(settingName);
        Objects.requireNonNull(sValue);
        return TimeValue.parseTimeValue(sValue, null, settingName);
    }

    public static TimeValue parseTimeValue(String sValue, TimeValue defaultValue, String settingName) throws Exception {
        settingName = Objects.requireNonNull(settingName);
        if (sValue == null) {
            return defaultValue;
        }
        String normalized = sValue.toLowerCase(Locale.ROOT).trim();
        if (normalized.endsWith("nanos")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "nanos"), TimeUnit.NANOSECONDS);
        }
        if (normalized.endsWith("micros")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "micros"), TimeUnit.MICROSECONDS);
        }
        if (normalized.endsWith("ms")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "ms"), TimeUnit.MILLISECONDS);
        }
        if (normalized.endsWith("s")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "s"), TimeUnit.SECONDS);
        }
        if (sValue.endsWith("m")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "m"), TimeUnit.MINUTES);
        }
        if (normalized.endsWith("h")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "h"), TimeUnit.HOURS);
        }
        if (normalized.endsWith("d")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "d"), TimeUnit.DAYS);
        }
        if (normalized.matches("-0*1")) {
            return MINUS_ONE;
        }
        if (normalized.matches("0+")) {
            return ZERO;
        }
        throw new Exception("failed to parse setting [{}] with value [{}] as a time value: unit is missing or unrecognized");
    }

    private static long parse(String initialInput, String normalized, String suffix) {
        String s = normalized.substring(0, normalized.length() - suffix.length()).trim();
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            try {
                double ignored = Double.parseDouble(s);
                throw new NumberFormatException("failed to parse, fractional time values are not supported");
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("failed to parse");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((TimeValue)o) == 0;
    }

    public int hashCode() {
        return Double.hashCode((double)this.duration * (double)this.timeUnit.toNanos(1L));
    }

    public static long nsecToMSec(long ns) {
        return ns / NSEC_PER_MSEC;
    }

    @Override
    public int compareTo(TimeValue timeValue) {
        double thisValue = (double)this.duration * (double)this.timeUnit.toNanos(1L);
        double otherValue = (double)timeValue.duration * (double)timeValue.timeUnit.toNanos(1L);
        return Double.compare(thisValue, otherValue);
    }

    static {
        EnumMap<TimeUnit, Byte> timeUnitByteMap = new EnumMap<TimeUnit, Byte>(TimeUnit.class);
        timeUnitByteMap.put(TimeUnit.NANOSECONDS, (byte)0);
        timeUnitByteMap.put(TimeUnit.MICROSECONDS, (byte)1);
        timeUnitByteMap.put(TimeUnit.MILLISECONDS, (byte)2);
        timeUnitByteMap.put(TimeUnit.SECONDS, (byte)3);
        timeUnitByteMap.put(TimeUnit.MINUTES, (byte)4);
        timeUnitByteMap.put(TimeUnit.HOURS, (byte)5);
        timeUnitByteMap.put(TimeUnit.DAYS, (byte)6);
        HashSet<Byte> bytes = new HashSet<Byte>();
        for (TimeUnit value : TimeUnit.values()) {
            assert (timeUnitByteMap.containsKey((Object)value)) : value;
            assert (bytes.add((Byte)timeUnitByteMap.get((Object)value)));
        }
        HashMap<Byte, TimeUnit> byteTimeUnitMap = new HashMap<Byte, TimeUnit>();
        for (Map.Entry entry : timeUnitByteMap.entrySet()) {
            byteTimeUnitMap.put((Byte)entry.getValue(), (TimeUnit)((Object)entry.getKey()));
        }
        TIME_UNIT_BYTE_MAP = Collections.unmodifiableMap(timeUnitByteMap);
        BYTE_TIME_UNIT_MAP = Collections.unmodifiableMap(byteTimeUnitMap);
        MINUS_ONE = TimeValue.timeValueMillis(-1L);
        ZERO = TimeValue.timeValueMillis(0L);
    }
}

