/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.monitor.jvm;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.doris.monitor.jvm.GcNames;
import org.apache.doris.monitor.unit.ByteSizeValue;
import org.apache.doris.monitor.unit.TimeValue;

public class JvmStats {
    private static final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private final long timestamp;
    private final long uptime;
    private final Mem mem;
    private final Threads threads;
    private final GarbageCollectors gc;
    private final List<BufferPool> bufferPools;
    private final Classes classes;

    public static JvmStats jvmStats() {
        MemoryUsage memUsage = memoryMXBean.getHeapMemoryUsage();
        long heapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        long heapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        long heapMax = memUsage.getMax() < 0L ? 0L : memUsage.getMax();
        memUsage = memoryMXBean.getNonHeapMemoryUsage();
        long nonHeapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        long nonHeapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<MemoryPool> pools = new ArrayList<MemoryPool>();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            try {
                MemoryUsage usage = memoryPoolMXBean.getUsage();
                MemoryUsage peakUsage = memoryPoolMXBean.getPeakUsage();
                String name = GcNames.getByMemoryPoolName(memoryPoolMXBean.getName(), null);
                if (name == null) continue;
                pools.add(new MemoryPool(name, usage.getUsed() < 0L ? 0L : usage.getUsed(), usage.getMax() < 0L ? 0L : usage.getMax(), peakUsage.getUsed() < 0L ? 0L : peakUsage.getUsed(), peakUsage.getMax() < 0L ? 0L : peakUsage.getMax()));
            }
            catch (Exception usage) {}
        }
        Mem mem = new Mem(heapCommitted, heapUsed, heapMax, nonHeapCommitted, nonHeapUsed, Collections.unmodifiableList(pools));
        int threadsNew = 0;
        int threadsRunnable = 0;
        int threadsBlocked = 0;
        int threadsWaiting = 0;
        int threadsTimedWaiting = 0;
        int threadsTerminated = 0;
        long[] threadIds = threadMXBean.getAllThreadIds();
        block13: for (ThreadInfo threadInfo : threadMXBean.getThreadInfo(threadIds, 0)) {
            if (threadInfo == null) continue;
            switch (threadInfo.getThreadState()) {
                case NEW: {
                    ++threadsNew;
                    continue block13;
                }
                case RUNNABLE: {
                    ++threadsRunnable;
                    continue block13;
                }
                case BLOCKED: {
                    ++threadsBlocked;
                    continue block13;
                }
                case WAITING: {
                    ++threadsWaiting;
                    continue block13;
                }
                case TIMED_WAITING: {
                    ++threadsTimedWaiting;
                    continue block13;
                }
                case TERMINATED: {
                    ++threadsTerminated;
                    continue block13;
                }
            }
        }
        Threads threads = new Threads(threadMXBean.getThreadCount(), threadMXBean.getPeakThreadCount(), threadsNew, threadsRunnable, threadsBlocked, threadsWaiting, threadsTimedWaiting, threadsTerminated);
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        GarbageCollector[] collectors = new GarbageCollector[gcMxBeans.size()];
        for (int i = 0; i < collectors.length; ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            collectors[i] = new GarbageCollector(GcNames.getByGcName(gcMxBean.getName(), gcMxBean.getName()), gcMxBean.getCollectionCount(), gcMxBean.getCollectionTime());
        }
        GarbageCollectors garbageCollectors = new GarbageCollectors(collectors);
        List<BufferPool> bufferPoolsList = Collections.emptyList();
        try {
            List<BufferPoolMXBean> bufferPools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
            bufferPoolsList = new ArrayList(bufferPools.size());
            for (BufferPoolMXBean bufferPool : bufferPools) {
                bufferPoolsList.add(new BufferPool(bufferPool.getName(), bufferPool.getCount(), bufferPool.getTotalCapacity(), bufferPool.getMemoryUsed()));
            }
        }
        catch (Exception bufferPools) {
            // empty catch block
        }
        Classes classes = new Classes(classLoadingMXBean.getLoadedClassCount(), classLoadingMXBean.getTotalLoadedClassCount(), classLoadingMXBean.getUnloadedClassCount());
        return new JvmStats(System.currentTimeMillis(), runtimeMXBean.getUptime(), mem, threads, garbageCollectors, bufferPoolsList, classes);
    }

    public JvmStats(long timestamp, long uptime, Mem mem, Threads threads, GarbageCollectors gc, List<BufferPool> bufferPools, Classes classes) {
        this.timestamp = timestamp;
        this.uptime = uptime;
        this.mem = mem;
        this.threads = threads;
        this.gc = gc;
        this.bufferPools = bufferPools;
        this.classes = classes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TimeValue getUptime() {
        return new TimeValue(this.uptime);
    }

    public Mem getMem() {
        return this.mem;
    }

    public Threads getThreads() {
        return this.threads;
    }

    public GarbageCollectors getGc() {
        return this.gc;
    }

    public List<BufferPool> getBufferPools() {
        return this.bufferPools;
    }

    public Classes getClasses() {
        return this.classes;
    }

    public static class Classes {
        private final long loadedClassCount;
        private final long totalLoadedClassCount;
        private final long unloadedClassCount;

        public Classes(long loadedClassCount, long totalLoadedClassCount, long unloadedClassCount) {
            this.loadedClassCount = loadedClassCount;
            this.totalLoadedClassCount = totalLoadedClassCount;
            this.unloadedClassCount = unloadedClassCount;
        }

        public long getLoadedClassCount() {
            return this.loadedClassCount;
        }

        public long getTotalLoadedClassCount() {
            return this.totalLoadedClassCount;
        }

        public long getUnloadedClassCount() {
            return this.unloadedClassCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Classes: ").append("loaded: ").append(this.loadedClassCount);
            sb.append(", total loaded: ").append(this.totalLoadedClassCount);
            sb.append(", unloaded: ").append(this.unloadedClassCount);
            return sb.toString();
        }
    }

    public static class BufferPool {
        private final String name;
        private final long count;
        private final long totalCapacity;
        private final long used;

        public BufferPool(String name, long count, long totalCapacity, long used) {
            this.name = name;
            this.count = count;
            this.totalCapacity = totalCapacity;
            this.used = used;
        }

        public String getName() {
            return this.name;
        }

        public long getCount() {
            return this.count;
        }

        public ByteSizeValue getTotalCapacity() {
            return new ByteSizeValue(this.totalCapacity);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.used);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("name: ").append(this.name).append(", count: ").append(this.count);
            sb.append("total capacity: ").append(this.totalCapacity).append(", used: ").append(this.used);
            return sb.toString();
        }
    }

    public static class Mem
    implements Iterable<MemoryPool> {
        private final long heapCommitted;
        private final long heapUsed;
        private final long heapMax;
        private final long nonHeapCommitted;
        private final long nonHeapUsed;
        private final List<MemoryPool> pools;

        public Mem(long heapCommitted, long heapUsed, long heapMax, long nonHeapCommitted, long nonHeapUsed, List<MemoryPool> pools) {
            this.heapCommitted = heapCommitted;
            this.heapUsed = heapUsed;
            this.heapMax = heapMax;
            this.nonHeapCommitted = nonHeapCommitted;
            this.nonHeapUsed = nonHeapUsed;
            this.pools = pools;
        }

        @Override
        public Iterator<MemoryPool> iterator() {
            return this.pools.iterator();
        }

        public ByteSizeValue getHeapCommitted() {
            return new ByteSizeValue(this.heapCommitted);
        }

        public ByteSizeValue getHeapUsed() {
            return new ByteSizeValue(this.heapUsed);
        }

        public ByteSizeValue getHeapMax() {
            return new ByteSizeValue(this.heapMax);
        }

        public short getHeapUsedPercent() {
            if (this.heapMax == 0L) {
                return -1;
            }
            return (short)(this.heapUsed * 100L / this.heapMax);
        }

        public ByteSizeValue getNonHeapCommitted() {
            return new ByteSizeValue(this.nonHeapCommitted);
        }

        public ByteSizeValue getNonHeapUsed() {
            return new ByteSizeValue(this.nonHeapUsed);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("heap committed: ").append(this.getHeapCommitted().toString());
            sb.append(", heap used: ").append(this.getHeapUsed().toString());
            sb.append(", heap max: ").append(this.getHeapMax().toString());
            sb.append(", non heap committed: ").append(this.getNonHeapCommitted().toString());
            sb.append(", non heap used: ").append(this.getNonHeapUsed().toString());
            sb.append("\nMem pools: ");
            for (MemoryPool memoryPool : this.pools) {
                sb.append(memoryPool.toString()).append("\n");
            }
            return sb.toString();
        }
    }

    public static class MemoryPool {
        private final String name;
        private final long used;
        private final long max;
        private final long peakUsed;
        private final long peakMax;

        public MemoryPool(String name, long used, long max, long peakUsed, long peakMax) {
            this.name = name;
            this.used = used;
            this.max = max;
            this.peakUsed = peakUsed;
            this.peakMax = peakMax;
        }

        public String getName() {
            return this.name;
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getMax() {
            return new ByteSizeValue(this.max);
        }

        public ByteSizeValue getPeakUsed() {
            return new ByteSizeValue(this.peakUsed);
        }

        public ByteSizeValue getPeakMax() {
            return new ByteSizeValue(this.peakMax);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("name: ").append(this.name).append(", used: ").append(this.getUsed().toString());
            sb.append(", max: ").append(this.getMax().toString()).append(", peak used: ").append(this.getPeakUsed().toString());
            sb.append(", peak max: ").append(this.getPeakMax().toString());
            return sb.toString();
        }
    }

    public static class Threads {
        private final int count;
        private final int peakCount;
        private final int threadsNewCount;
        private final int threadsRunnableCount;
        private final int threadsBlockedCount;
        private final int threadsWaitingCount;
        private final int threadsTimedWaitingCount;
        private final int threadsTerminatedCount;

        public Threads(int count, int peakCount, int threadsNewCount, int threadsRunnableCount, int threadsBlockedCount, int threadsWaitingCount, int threadsTimedWaitingCount, int threadsTerminatedCount) {
            this.count = count;
            this.peakCount = peakCount;
            this.threadsNewCount = threadsNewCount;
            this.threadsRunnableCount = threadsRunnableCount;
            this.threadsBlockedCount = threadsBlockedCount;
            this.threadsWaitingCount = threadsWaitingCount;
            this.threadsTimedWaitingCount = threadsTimedWaitingCount;
            this.threadsTerminatedCount = threadsTerminatedCount;
        }

        public int getCount() {
            return this.count;
        }

        public int getPeakCount() {
            return this.peakCount;
        }

        public int getThreadsNewCount() {
            return this.threadsNewCount;
        }

        public int getThreadsRunnableCount() {
            return this.threadsRunnableCount;
        }

        public int getThreadsBlockedCount() {
            return this.threadsBlockedCount;
        }

        public int getThreadsWaitingCount() {
            return this.threadsWaitingCount;
        }

        public int getThreadsTimedWaitingCount() {
            return this.threadsTimedWaitingCount;
        }

        public int getThreadsTerminatedCount() {
            return this.threadsTerminatedCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("count: ").append(this.count).append(", peak count: ").append(this.peakCount);
            return sb.toString();
        }
    }

    public static class GarbageCollector {
        private final String name;
        private final long collectionCount;
        private final long collectionTime;

        public GarbageCollector(String name, long collectionCount, long collectionTime) {
            this.name = name;
            this.collectionCount = collectionCount;
            this.collectionTime = collectionTime;
        }

        public String getName() {
            return this.name;
        }

        public long getCollectionCount() {
            return this.collectionCount;
        }

        public TimeValue getCollectionTime() {
            return new TimeValue(this.collectionTime, TimeUnit.MILLISECONDS);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append(": collection count: ").append(this.collectionCount);
            sb.append(", collection time: ").append(this.getCollectionTime().getStringRep());
            return sb.toString();
        }
    }

    public static class GarbageCollectors
    implements Iterable<GarbageCollector> {
        private final GarbageCollector[] collectors;

        public GarbageCollectors(GarbageCollector[] collectors) {
            this.collectors = collectors;
        }

        public GarbageCollector[] getCollectors() {
            return this.collectors;
        }

        @Override
        public Iterator<GarbageCollector> iterator() {
            return Arrays.stream(this.collectors).iterator();
        }
    }

    static final class Fields {
        static final String JVM = "jvm";
        static final String TIMESTAMP = "timestamp";
        static final String UPTIME = "uptime";
        static final String UPTIME_IN_MILLIS = "uptime_in_millis";
        static final String MEM = "mem";
        static final String HEAP_USED = "heap_used";
        static final String HEAP_USED_IN_BYTES = "heap_used_in_bytes";
        static final String HEAP_USED_PERCENT = "heap_used_percent";
        static final String HEAP_MAX = "heap_max";
        static final String HEAP_MAX_IN_BYTES = "heap_max_in_bytes";
        static final String HEAP_COMMITTED = "heap_committed";
        static final String HEAP_COMMITTED_IN_BYTES = "heap_committed_in_bytes";
        static final String NON_HEAP_USED = "non_heap_used";
        static final String NON_HEAP_USED_IN_BYTES = "non_heap_used_in_bytes";
        static final String NON_HEAP_COMMITTED = "non_heap_committed";
        static final String NON_HEAP_COMMITTED_IN_BYTES = "non_heap_committed_in_bytes";
        static final String POOLS = "pools";
        static final String USED = "used";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String MAX = "max";
        static final String MAX_IN_BYTES = "max_in_bytes";
        static final String PEAK_USED = "peak_used";
        static final String PEAK_USED_IN_BYTES = "peak_used_in_bytes";
        static final String PEAK_MAX = "peak_max";
        static final String PEAK_MAX_IN_BYTES = "peak_max_in_bytes";
        static final String THREADS = "threads";
        static final String COUNT = "count";
        static final String PEAK_COUNT = "peak_count";
        static final String NEW_COUNT = "new_count";
        static final String RUNNING_COUNT = "runnable_count";
        static final String BLOCKED_COUNT = "blocked_count";
        static final String WAITING_COUNT = "waiting_count";
        static final String TIMED_WAITING_COUNT = "timed_waiting_count";
        static final String TERMINATED_COUNT = "terminated_count";
        static final String GC = "gc";
        static final String COLLECTORS = "collectors";
        static final String COLLECTION_COUNT = "collection_count";
        static final String COLLECTION_TIME = "collection_time";
        static final String COLLECTION_TIME_IN_MILLIS = "collection_time_in_millis";
        static final String BUFFER_POOLS = "buffer_pools";
        static final String TOTAL_CAPACITY = "total_capacity";
        static final String TOTAL_CAPACITY_IN_BYTES = "total_capacity_in_bytes";
        static final String CLASSES = "classes";
        static final String CURRENT_LOADED_COUNT = "current_loaded_count";
        static final String TOTAL_LOADED_COUNT = "total_loaded_count";
        static final String TOTAL_UNLOADED_COUNT = "total_unloaded_count";

        Fields() {
        }
    }
}

