/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.monitor.jvm;

import com.google.common.base.Joiner;
import java.util.List;
import org.apache.doris.monitor.jvm.JvmInfo;
import org.apache.doris.monitor.jvm.JvmStats;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JvmService {
    private static final Logger LOG = LogManager.getLogger(JvmService.class);
    private final JvmInfo jvmInfo = JvmInfo.jvmInfo();
    private JvmStats jvmStats = JvmStats.jvmStats();

    public JvmInfo info() {
        return this.jvmInfo;
    }

    public synchronized JvmStats stats() {
        this.jvmStats = JvmStats.jvmStats();
        return this.jvmStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        JvmStats jvmStats = this.stats();
        List<JvmStats.BufferPool> bufferPools = jvmStats.getBufferPools();
        sb.append("JVM Stats: \nBuffer pools:\n");
        for (JvmStats.BufferPool bufferPool : bufferPools) {
            sb.append("\t").append(bufferPool.toString()).append("\n");
        }
        JvmStats.Classes classes = jvmStats.getClasses();
        sb.append(classes.toString()).append("\n");
        JvmStats.GarbageCollectors gc = jvmStats.getGc();
        JvmStats.GarbageCollector[] gcs = gc.getCollectors();
        sb.append("Garbage Collectors: \n");
        for (JvmStats.GarbageCollector garbageCollector : gcs) {
            sb.append("\t").append(garbageCollector.toString());
        }
        JvmStats.Mem mem = jvmStats.getMem();
        sb.append("\nMem: ").append(mem.toString());
        JvmStats.Threads threads = jvmStats.getThreads();
        sb.append("\nThreads: ").append(threads.toString());
        sb.append("\nUpTime: ").append(jvmStats.getUptime().toString());
        sb.append("\nTimestamp: ").append(jvmStats.getTimestamp());
        LOG.info(sb.toString());
        JvmInfo jvmInfo = this.info();
        sb.append("\nJVM Info: \nboot class path: ").append(jvmInfo.getBootClassPath());
        sb.append("\nclass path: ").append(jvmInfo.getClassPath());
        sb.append("\nconfigured init heap size: ").append(jvmInfo.getConfiguredInitialHeapSize());
        sb.append("\nconfigured max heap size: ").append(jvmInfo.getConfiguredMaxHeapSize());
        sb.append("\npid: ").append(jvmInfo.getPid());
        sb.append("\nstart time: ").append(jvmInfo.getStartTime());
        sb.append("\nversion: ").append(jvmInfo.getVersion());
        sb.append("\nvm name").append(jvmInfo.getVmName());
        sb.append("\nvm vendor: ").append(jvmInfo.getVmVendor());
        sb.append("\nvm version").append(jvmInfo.getVmVersion());
        sb.append("\ngcs: ").append(Joiner.on((String)", ").join((Object[])jvmInfo.getGcCollectors()));
        sb.append("\ninput arguments: ").append(Joiner.on((String)", ").join((Object[])jvmInfo.getInputArguments()));
        sb.append("\nmem: ").append(jvmInfo.getMem().toString());
        sb.append("\nmem pools: ").append(Joiner.on((String)", ").join((Object[])jvmInfo.getMemoryPools()));
        sb.append("\nsystem props: ").append(jvmInfo.getSystemProperties());
        return sb.toString();
    }
}

