/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.metric;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import org.apache.doris.common.FeConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemMetrics {
    private static final Logger LOG = LogManager.getLogger(SystemMetrics.class);
    protected long tcpRetransSegs = 0L;
    protected long tcpInErrs = 0L;
    protected long tcpInSegs = 0L;
    protected long tcpOutSegs = 0L;
    protected long memTotal = 0L;
    protected long memFree = 0L;
    protected long memAvailable = 0L;
    protected long buffers = 0L;
    protected long cached = 0L;

    public synchronized void update() {
        this.updateSnmpMetrics();
        this.updateMemoryMetrics();
    }

    private void updateSnmpMetrics() {
        String procFile = "/proc/net/snmp";
        if (FeConstants.runningUnitTest) {
            procFile = this.getClass().getClassLoader().getResource("data/net_snmp_normal").getFile();
        }
        try (FileReader fileReader = new FileReader(procFile);
             BufferedReader br = new BufferedReader(fileReader);){
            String line = null;
            boolean found = false;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("Tcp: ")) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new Exception("can not find tcp metrics");
            }
            String[] headers = line.split(" ");
            HashMap headerMap = Maps.newHashMap();
            int pos = 0;
            for (int i = 0; i < headers.length; ++i) {
                headerMap.put(headers[i], pos++);
            }
            line = br.readLine();
            if (line == null) {
                throw new Exception("failed to read metrics of TCP");
            }
            String[] parts = line.split(" ");
            if (parts.length != headerMap.size()) {
                throw new Exception("invalid tcp metrics: " + line + ". header size: " + headerMap.size());
            }
            this.tcpRetransSegs = Long.valueOf(parts[(Integer)headerMap.get("RetransSegs")]);
            this.tcpInErrs = Long.valueOf(parts[(Integer)headerMap.get("InErrs")]);
            this.tcpInSegs = Long.valueOf(parts[(Integer)headerMap.get("InSegs")]);
            this.tcpOutSegs = Long.valueOf(parts[(Integer)headerMap.get("OutSegs")]);
        }
        catch (Exception e) {
            LOG.warn("failed to get /proc/net/snmp", (Throwable)e);
        }
    }

    private void updateMemoryMetrics() {
        String procFile = "/proc/meminfo";
        String[] memoryMetrics = new String[]{"MemTotal", "MemFree", "MemAvailable", "Buffers", "Cached"};
        HashMap memInfoMap = Maps.newHashMap();
        try (FileReader fileReader = new FileReader(procFile);
             BufferedReader br = new BufferedReader(fileReader);){
            String line = null;
            while ((line = br.readLine()) != null) {
                for (String memoryMetric : memoryMetrics) {
                    if (memInfoMap.containsKey(memoryMetric) || !line.startsWith(memoryMetric)) continue;
                    String[] parts = line.split("\\s+");
                    if (parts.length != 3) {
                        throw new Exception("invalid memory metrics: " + line);
                    }
                    memInfoMap.put(memoryMetric, new Long(parts[1]) * 1024L);
                    break;
                }
                if (memInfoMap.size() != memoryMetrics.length) continue;
            }
            this.memTotal = memInfoMap.getOrDefault("MemTotal", -1L);
            this.memFree = memInfoMap.getOrDefault("MemFree", -1L);
            this.memAvailable = memInfoMap.getOrDefault("MemAvailable", -1L);
            this.buffers = memInfoMap.getOrDefault("Buffers", -1L);
            this.cached = memInfoMap.getOrDefault("Cached", -1L);
        }
        catch (Exception e) {
            LOG.warn("failed to get /proc/meminfo", (Throwable)e);
        }
    }
}

