/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.metric;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Snapshot;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.metric.Metric;
import org.apache.doris.metric.MetricVisitor;
import org.apache.doris.monitor.jvm.JvmStats;

public class SimpleCoreMetricVisitor
extends MetricVisitor {
    private static final String TYPE_LONG = "LONG";
    private static final String TYPE_DOUBLE = "DOUBLE";
    public static final String JVM_YOUNG_USED_PERCENT = "jvm_young_used_percent";
    public static final String JVM_OLD_USED_PERCENT = "jvm_old_used_percent";
    public static final String JVM_THREAD = "jvm_thread";
    public static final String MAX_JOURMAL_ID = "max_journal_id";
    public static final String CONNECTION_TOTAL = "connection_total";
    public static final String QUERY_LATENCY_MS = "query_latency_ms";
    public static final String QUERY_PER_SECOND = "qps";
    public static final String REQUEST_PER_SECOND = "rps";
    public static final String QUERY_ERR_RATE = "query_err_rate";
    public static final String MAX_TABLET_COMPACTION_SCORE = "max_tablet_compaction_score";
    private int ordinal = 0;
    private int metricNumber = 0;
    private static final Map<String, String> CORE_METRICS = Maps.newHashMap();

    public SimpleCoreMetricVisitor(String prefix) {
        super(prefix);
    }

    @Override
    public void setMetricNumber(int metricNumber) {
        this.metricNumber = metricNumber;
    }

    @Override
    public void visitJvm(StringBuilder sb, JvmStats jvmStats) {
        for (JvmStats.MemoryPool memPool : jvmStats.getMem()) {
            String percent;
            long max;
            long used;
            if (memPool.getName().equalsIgnoreCase("young")) {
                used = memPool.getUsed().getBytes();
                max = memPool.getMax().getBytes();
                percent = String.format("%.1f", (double)used / (double)(max + 1L) * 100.0);
                sb.append(Joiner.on((String)" ").join((Object)JVM_YOUNG_USED_PERCENT, (Object)TYPE_DOUBLE, new Object[]{percent})).append("\n");
                continue;
            }
            if (!memPool.getName().equalsIgnoreCase("old")) continue;
            used = memPool.getUsed().getBytes();
            max = memPool.getMax().getBytes();
            percent = String.format("%.1f", (double)used / (double)(max + 1L) * 100.0);
            sb.append(Joiner.on((String)" ").join((Object)JVM_OLD_USED_PERCENT, (Object)TYPE_DOUBLE, new Object[]{percent})).append("\n");
        }
        JvmStats.Threads threads = jvmStats.getThreads();
        sb.append(Joiner.on((String)" ").join((Object)JVM_THREAD, (Object)TYPE_LONG, new Object[]{threads.getCount()})).append("\n");
    }

    @Override
    public void visit(StringBuilder sb, Metric metric) {
        if (!CORE_METRICS.containsKey(metric.getName())) {
            return;
        }
        if (CORE_METRICS.get(metric.getName()).equals(TYPE_DOUBLE)) {
            sb.append(Joiner.on((String)" ").join((Object)(this.prefix + "_" + metric.getName()), (Object)TYPE_DOUBLE, new Object[]{String.format("%.2f", Double.valueOf(metric.getValue().toString()))})).append("\n");
        } else {
            sb.append(Joiner.on((String)" ").join((Object)(this.prefix + "_" + metric.getName()), (Object)CORE_METRICS.get(metric.getName()), new Object[]{metric.getValue().toString()})).append("\n");
        }
    }

    @Override
    public void visitHistogram(StringBuilder sb, String name, Histogram histogram) {
        if (!CORE_METRICS.containsKey(name)) {
            return;
        }
        Snapshot snapshot = histogram.getSnapshot();
        sb.append(Joiner.on((String)" ").join((Object)(this.prefix + "_" + name + "_75"), (Object)CORE_METRICS.get(name), new Object[]{String.format("%.0f", snapshot.get75thPercentile())})).append("\n");
        sb.append(Joiner.on((String)" ").join((Object)(this.prefix + "_" + name + "_95"), (Object)CORE_METRICS.get(name), new Object[]{String.format("%.0f", snapshot.get95thPercentile())})).append("\n");
        sb.append(Joiner.on((String)" ").join((Object)(this.prefix + "_" + name + "_99"), (Object)CORE_METRICS.get(name), new Object[]{String.format("%.0f", snapshot.get99thPercentile())})).append("\n");
    }

    @Override
    public void getNodeInfo(StringBuilder sb) {
        long feDeadNum = Catalog.getCurrentCatalog().getFrontends(null).stream().filter(f -> !f.isAlive()).count();
        long beDeadNum = Catalog.getCurrentSystemInfo().getIdToBackend().values().stream().filter(b -> !b.isAlive()).count();
        long brokerDeadNum = Catalog.getCurrentCatalog().getBrokerMgr().getAllBrokers().stream().filter(b -> !b.isAlive).count();
        sb.append(this.prefix + "_frontend_dead_num").append(" ").append(String.valueOf(feDeadNum)).append("\n");
        sb.append(this.prefix + "_backend_dead_num").append(" ").append(String.valueOf(beDeadNum)).append("\n");
        sb.append(this.prefix + "_broker_dead_num").append(" ").append(String.valueOf(brokerDeadNum)).append("\n");
    }

    static {
        CORE_METRICS.put(MAX_JOURMAL_ID, TYPE_LONG);
        CORE_METRICS.put(CONNECTION_TOTAL, TYPE_LONG);
        CORE_METRICS.put(QUERY_LATENCY_MS, TYPE_LONG);
        CORE_METRICS.put(QUERY_PER_SECOND, TYPE_DOUBLE);
        CORE_METRICS.put(REQUEST_PER_SECOND, TYPE_DOUBLE);
        CORE_METRICS.put(QUERY_ERR_RATE, TYPE_DOUBLE);
        CORE_METRICS.put(MAX_TABLET_COMPACTION_SCORE, TYPE_LONG);
    }
}

