/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.metric;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Snapshot;
import com.google.common.base.Joiner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.metric.Metric;
import org.apache.doris.metric.MetricLabel;
import org.apache.doris.metric.MetricVisitor;
import org.apache.doris.monitor.jvm.JvmStats;

public class PrometheusMetricVisitor
extends MetricVisitor {
    private static final String JVM_HEAP_SIZE_BYTES = "jvm_heap_size_bytes";
    private static final String JVM_NON_HEAP_SIZE_BYTES = "jvm_non_heap_size_bytes";
    private static final String JVM_YOUNG_SIZE_BYTES = "jvm_young_size_bytes";
    private static final String JVM_OLD_SIZE_BYTES = "jvm_old_size_bytes";
    private static final String JVM_DIRECT_BUFFER_POOL_SIZE_BYTES = "jvm_direct_buffer_pool_size_bytes";
    private static final String JVM_YOUNG_GC = "jvm_young_gc";
    private static final String JVM_OLD_GC = "jvm_old_gc";
    private static final String JVM_THREAD = "jvm_thread";
    private static final String HELP = "# HELP ";
    private static final String TYPE = "# TYPE ";
    private int ordinal = 0;
    private int metricNumber = 0;
    private Set<String> metricNames = new HashSet<String>();

    public PrometheusMetricVisitor(String prefix) {
        super(prefix);
    }

    @Override
    public void setMetricNumber(int metricNumber) {
        this.metricNumber = metricNumber;
    }

    @Override
    public void visitJvm(StringBuilder sb, JvmStats jvmStats) {
        sb.append(Joiner.on((String)" ").join((Object)HELP, (Object)JVM_HEAP_SIZE_BYTES, new Object[]{"jvm heap stat\n"}));
        sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)JVM_HEAP_SIZE_BYTES, new Object[]{"gauge\n"}));
        sb.append(JVM_HEAP_SIZE_BYTES).append("{type=\"max\"} ").append(jvmStats.getMem().getHeapMax().getBytes()).append("\n");
        sb.append(JVM_HEAP_SIZE_BYTES).append("{type=\"committed\"} ").append(jvmStats.getMem().getHeapCommitted().getBytes()).append("\n");
        sb.append(JVM_HEAP_SIZE_BYTES).append("{type=\"used\"} ").append(jvmStats.getMem().getHeapUsed().getBytes()).append("\n");
        sb.append(Joiner.on((String)" ").join((Object)HELP, (Object)JVM_NON_HEAP_SIZE_BYTES, new Object[]{"jvm non heap stat\n"}));
        sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)JVM_NON_HEAP_SIZE_BYTES, new Object[]{"gauge\n"}));
        sb.append(JVM_NON_HEAP_SIZE_BYTES).append("{type=\"committed\"} ").append(jvmStats.getMem().getNonHeapCommitted().getBytes()).append("\n");
        sb.append(JVM_NON_HEAP_SIZE_BYTES).append("{type=\"used\"} ").append(jvmStats.getMem().getNonHeapUsed().getBytes()).append("\n");
        for (JvmStats.MemoryPool memPool : jvmStats.getMem()) {
            if (memPool.getName().equalsIgnoreCase("young")) {
                sb.append(Joiner.on((String)" ").join((Object)HELP, (Object)JVM_YOUNG_SIZE_BYTES, new Object[]{"jvm young mem pool stat\n"}));
                sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)JVM_YOUNG_SIZE_BYTES, new Object[]{"gauge\n"}));
                sb.append(JVM_YOUNG_SIZE_BYTES).append("{type=\"used\"} ").append(memPool.getUsed().getBytes()).append("\n");
                sb.append(JVM_YOUNG_SIZE_BYTES).append("{type=\"peak_used\"} ").append(memPool.getPeakUsed().getBytes()).append("\n");
                sb.append(JVM_YOUNG_SIZE_BYTES).append("{type=\"max\"} ").append(memPool.getMax().getBytes()).append("\n");
                continue;
            }
            if (!memPool.getName().equalsIgnoreCase("old")) continue;
            sb.append(Joiner.on((String)" ").join((Object)HELP, (Object)JVM_OLD_SIZE_BYTES, new Object[]{"jvm old mem pool stat\n"}));
            sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)JVM_OLD_SIZE_BYTES, new Object[]{"gauge\n"}));
            sb.append(JVM_OLD_SIZE_BYTES).append("{type=\"used\"} ").append(memPool.getUsed().getBytes()).append("\n");
            sb.append(JVM_OLD_SIZE_BYTES).append("{type=\"peak_used\"} ").append(memPool.getPeakUsed().getBytes()).append("\n");
            sb.append(JVM_OLD_SIZE_BYTES).append("{type=\"max\"} ").append(memPool.getMax().getBytes()).append("\n");
        }
        for (JvmStats.BufferPool pool : jvmStats.getBufferPools()) {
            if (!pool.getName().equalsIgnoreCase("direct")) continue;
            sb.append(Joiner.on((String)" ").join((Object)HELP, (Object)JVM_DIRECT_BUFFER_POOL_SIZE_BYTES, new Object[]{"jvm direct buffer pool stat\n"}));
            sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)JVM_DIRECT_BUFFER_POOL_SIZE_BYTES, new Object[]{"gauge\n"}));
            sb.append(JVM_DIRECT_BUFFER_POOL_SIZE_BYTES).append("{type=\"count\"} ").append(pool.getCount()).append("\n");
            sb.append(JVM_DIRECT_BUFFER_POOL_SIZE_BYTES).append("{type=\"used\"} ").append(pool.getUsed().getBytes()).append("\n");
            sb.append(JVM_DIRECT_BUFFER_POOL_SIZE_BYTES).append("{type=\"capacity\"} ").append(pool.getTotalCapacity().getBytes()).append("\n");
        }
        for (JvmStats.GarbageCollector gc : jvmStats.getGc()) {
            if (gc.getName().equalsIgnoreCase("young")) {
                sb.append(Joiner.on((String)" ").join((Object)HELP, (Object)JVM_YOUNG_GC, new Object[]{"jvm young gc stat\n"}));
                sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)JVM_YOUNG_GC, new Object[]{"gauge\n"}));
                sb.append(JVM_YOUNG_GC).append("{type=\"count\"} ").append(gc.getCollectionCount()).append("\n");
                sb.append(JVM_YOUNG_GC).append("{type=\"time\"} ").append(gc.getCollectionTime().getMillis()).append("\n");
                continue;
            }
            if (!gc.getName().equalsIgnoreCase("old")) continue;
            sb.append(Joiner.on((String)" ").join((Object)HELP, (Object)JVM_OLD_GC, new Object[]{"jvm old gc stat\n"}));
            sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)JVM_OLD_GC, new Object[]{"gauge\n"}));
            sb.append(JVM_OLD_GC).append("{type=\"count\"} ").append(gc.getCollectionCount()).append("\n");
            sb.append(JVM_OLD_GC).append("{type=\"time\"} ").append(gc.getCollectionTime().getMillis()).append("\n");
        }
        JvmStats.Threads threads = jvmStats.getThreads();
        sb.append(Joiner.on((String)" ").join((Object)HELP, (Object)JVM_THREAD, new Object[]{"jvm thread stat\n"}));
        sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)JVM_THREAD, new Object[]{"gauge\n"}));
        sb.append(JVM_THREAD).append("{type=\"count\"} ").append(threads.getCount()).append("\n");
        sb.append(JVM_THREAD).append("{type=\"peak_count\"} ").append(threads.getPeakCount()).append("\n");
        sb.append(JVM_THREAD).append("{type=\"new_count\"} ").append(threads.getThreadsNewCount()).append("\n");
        sb.append(JVM_THREAD).append("{type=\"runnable_count\"} ").append(threads.getThreadsRunnableCount()).append("\n");
        sb.append(JVM_THREAD).append("{type=\"blocked_count\"} ").append(threads.getThreadsBlockedCount()).append("\n");
        sb.append(JVM_THREAD).append("{type=\"waiting_count\"} ").append(threads.getThreadsWaitingCount()).append("\n");
        sb.append(JVM_THREAD).append("{type=\"timed_waiting_count\"} ").append(threads.getThreadsTimedWaitingCount()).append("\n");
        sb.append(JVM_THREAD).append("{type=\"terminated_count\"} ").append(threads.getThreadsTerminatedCount()).append("\n");
    }

    @Override
    public void visit(StringBuilder sb, Metric metric) {
        String fullName = this.prefix + "_" + metric.getName();
        if (!this.metricNames.contains(fullName)) {
            sb.append(HELP).append(fullName).append(" ").append(metric.getDescription()).append("\n");
            sb.append(TYPE).append(fullName).append(" ").append(metric.getType().name().toLowerCase()).append("\n");
            this.metricNames.add(fullName);
        }
        sb.append(fullName);
        List<MetricLabel> labels = metric.getLabels();
        if (!labels.isEmpty()) {
            sb.append("{");
            List labelStrs = labels.stream().map(l -> l.getKey() + "=\"" + l.getValue() + "\"").collect(Collectors.toList());
            sb.append(Joiner.on((String)", ").join(labelStrs));
            sb.append("}");
        }
        sb.append(" ").append(metric.getValue().toString()).append("\n");
    }

    @Override
    public void visitHistogram(StringBuilder sb, String name, Histogram histogram) {
        String fullName = this.prefix + "_" + name.replaceAll("\\.", "_");
        sb.append(HELP).append(fullName).append(" ").append("\n");
        sb.append(TYPE).append(fullName).append(" ").append("summary\n");
        Snapshot snapshot = histogram.getSnapshot();
        sb.append(fullName).append("{quantile=\"0.75\"} ").append(snapshot.get75thPercentile()).append("\n");
        sb.append(fullName).append("{quantile=\"0.95\"} ").append(snapshot.get95thPercentile()).append("\n");
        sb.append(fullName).append("{quantile=\"0.98\"} ").append(snapshot.get98thPercentile()).append("\n");
        sb.append(fullName).append("{quantile=\"0.99\"} ").append(snapshot.get99thPercentile()).append("\n");
        sb.append(fullName).append("{quantile=\"0.999\"} ").append(snapshot.get999thPercentile()).append("\n");
        sb.append(fullName).append("_sum ").append((double)histogram.getCount() * snapshot.getMean()).append("\n");
        sb.append(fullName).append("_count ").append(histogram.getCount()).append("\n");
    }

    @Override
    public void getNodeInfo(StringBuilder sb) {
        String NODE_INFO = "node_info";
        sb.append(Joiner.on((String)" ").join((Object)TYPE, (Object)"node_info", new Object[]{"gauge\n"}));
        sb.append("node_info").append("{type=\"fe_node_num\", state=\"total\"} ").append(Catalog.getCurrentCatalog().getFrontends(null).size()).append("\n");
        sb.append("node_info").append("{type=\"be_node_num\", state=\"total\"} ").append(Catalog.getCurrentSystemInfo().getBackendIds(false).size()).append("\n");
        sb.append("node_info").append("{type=\"be_node_num\", state=\"alive\"} ").append(Catalog.getCurrentSystemInfo().getBackendIds(true).size()).append("\n");
        sb.append("node_info").append("{type=\"be_node_num\", state=\"decommissioned\"} ").append(Catalog.getCurrentSystemInfo().getDecommissionedBackendIds().size()).append("\n");
        sb.append("node_info").append("{type=\"broker_node_num\", state=\"dead\"} ").append(Catalog.getCurrentCatalog().getBrokerMgr().getAllBrokers().stream().filter(b -> !b.isAlive).count()).append("\n");
        if (Catalog.getCurrentCatalog().isMaster()) {
            sb.append("node_info").append("{type=\"is_master\"} ").append(1).append("\n");
        }
    }
}

