/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import org.apache.doris.alter.Alter;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.common.Config;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.load.loadv2.LoadManager;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.routineload.RoutineLoadManager;
import org.apache.doris.metric.DorisMetricRegistry;
import org.apache.doris.metric.GaugeMetric;
import org.apache.doris.metric.GaugeMetricImpl;
import org.apache.doris.metric.LongCounterMetric;
import org.apache.doris.metric.Metric;
import org.apache.doris.metric.MetricCalculator;
import org.apache.doris.metric.MetricLabel;
import org.apache.doris.metric.MetricVisitor;
import org.apache.doris.metric.SystemMetrics;
import org.apache.doris.monitor.jvm.JvmService;
import org.apache.doris.monitor.jvm.JvmStats;
import org.apache.doris.persist.EditLog;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.service.ExecuteEnv;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MetricRepo {
    private static final Logger LOG = LogManager.getLogger(MetricRepo.class);
    private static final MetricRegistry METRIC_REGISTER = new MetricRegistry();
    public static final DorisMetricRegistry PALO_METRIC_REGISTER = new DorisMetricRegistry();
    public static volatile boolean isInit = false;
    public static final SystemMetrics SYSTEM_METRICS = new SystemMetrics();
    public static final String TABLET_NUM = "tablet_num";
    public static final String TABLET_MAX_COMPACTION_SCORE = "tablet_max_compaction_score";
    public static LongCounterMetric COUNTER_REQUEST_ALL;
    public static LongCounterMetric COUNTER_QUERY_BEGIN;
    public static LongCounterMetric COUNTER_QUERY_ALL;
    public static LongCounterMetric COUNTER_QUERY_ERR;
    public static LongCounterMetric COUNTER_QUERY_TABLE;
    public static LongCounterMetric COUNTER_QUERY_OLAP_TABLE;
    public static LongCounterMetric COUNTER_CACHE_MODE_SQL;
    public static LongCounterMetric COUNTER_CACHE_HIT_SQL;
    public static LongCounterMetric COUNTER_CACHE_MODE_PARTITION;
    public static LongCounterMetric COUNTER_CACHE_HIT_PARTITION;
    public static LongCounterMetric COUNTER_CACHE_PARTITION_ALL;
    public static LongCounterMetric COUNTER_CACHE_PARTITION_HIT;
    public static LongCounterMetric COUNTER_LOAD_ADD;
    public static LongCounterMetric COUNTER_LOAD_FINISHED;
    public static LongCounterMetric COUNTER_EDIT_LOG_WRITE;
    public static LongCounterMetric COUNTER_EDIT_LOG_READ;
    public static LongCounterMetric COUNTER_EDIT_LOG_SIZE_BYTES;
    public static LongCounterMetric COUNTER_IMAGE_WRITE_SUCCESS;
    public static LongCounterMetric COUNTER_IMAGE_WRITE_FAILED;
    public static LongCounterMetric COUNTER_IMAGE_PUSH_SUCCESS;
    public static LongCounterMetric COUNTER_IMAGE_PUSH_FAILED;
    public static LongCounterMetric COUNTER_IMAGE_CLEAN_SUCCESS;
    public static LongCounterMetric COUNTER_IMAGE_CLEAN_FAILED;
    public static LongCounterMetric COUNTER_EDIT_LOG_CLEAN_SUCCESS;
    public static LongCounterMetric COUNTER_EDIT_LOG_CLEAN_FAILED;
    public static LongCounterMetric COUNTER_TXN_REJECT;
    public static LongCounterMetric COUNTER_TXN_BEGIN;
    public static LongCounterMetric COUNTER_TXN_FAILED;
    public static LongCounterMetric COUNTER_TXN_SUCCESS;
    public static LongCounterMetric COUNTER_ROUTINE_LOAD_ROWS;
    public static LongCounterMetric COUNTER_ROUTINE_LOAD_RECEIVED_BYTES;
    public static LongCounterMetric COUNTER_ROUTINE_LOAD_ERROR_ROWS;
    public static LongCounterMetric COUNTER_HIT_SQL_BLOCK_RULE;
    public static Histogram HISTO_QUERY_LATENCY;
    public static Histogram HISTO_EDIT_LOG_WRITE_LATENCY;
    public static GaugeMetricImpl<Double> GAUGE_QUERY_PER_SECOND;
    public static GaugeMetricImpl<Double> GAUGE_REQUEST_PER_SECOND;
    public static GaugeMetricImpl<Double> GAUGE_QUERY_ERR_RATE;
    public static GaugeMetricImpl<Long> GAUGE_MAX_TABLET_COMPACTION_SCORE;
    private static ScheduledThreadPoolExecutor metricTimer;
    private static MetricCalculator metricCalculator;

    public static synchronized void init() {
        if (isInit) {
            return;
        }
        final LoadManager loadManger = Catalog.getCurrentCatalog().getLoadManager();
        for (final EtlJobType jobType : EtlJobType.values()) {
            for (final JobState state : JobState.values()) {
                GaugeMetric<Long> gauge = new GaugeMetric<Long>("job", Metric.MetricUnit.NOUNIT, "job statistics"){

                    @Override
                    public Long getValue() {
                        if (!Catalog.getCurrentCatalog().isMaster()) {
                            return 0L;
                        }
                        return loadManger.getLoadJobNum(state, jobType);
                    }
                };
                gauge.addLabel(new MetricLabel("job", "load")).addLabel(new MetricLabel("type", jobType.name())).addLabel(new MetricLabel("state", state.name()));
                PALO_METRIC_REGISTER.addPaloMetrics(gauge);
            }
        }
        final RoutineLoadManager routineLoadManager = Catalog.getCurrentCatalog().getRoutineLoadManager();
        for (final RoutineLoadJob.JobState jobState : RoutineLoadJob.JobState.values()) {
            GaugeMetric<Long> gauge = new GaugeMetric<Long>("job", Metric.MetricUnit.NOUNIT, "routine load job statistics"){

                @Override
                public Long getValue() {
                    if (!Catalog.getCurrentCatalog().isMaster()) {
                        return 0L;
                    }
                    HashSet states = Sets.newHashSet();
                    states.add(jobState);
                    List<RoutineLoadJob> jobs = routineLoadManager.getRoutineLoadJobByState(states);
                    return jobs.size();
                }
            };
            gauge.addLabel(new MetricLabel("job", "load")).addLabel(new MetricLabel("type", "ROUTINE_LOAD")).addLabel(new MetricLabel("state", jobState.name()));
            PALO_METRIC_REGISTER.addPaloMetrics(gauge);
        }
        final Alter alter = Catalog.getCurrentCatalog().getAlterInstance();
        for (final AlterJobV2.JobType jobType : AlterJobV2.JobType.values()) {
            if (jobType != AlterJobV2.JobType.SCHEMA_CHANGE && jobType != AlterJobV2.JobType.ROLLUP) continue;
            GaugeMetric<Long> gauge = new GaugeMetric<Long>("job", Metric.MetricUnit.NOUNIT, "job statistics"){

                @Override
                public Long getValue() {
                    if (!Catalog.getCurrentCatalog().isMaster()) {
                        return 0L;
                    }
                    if (jobType == AlterJobV2.JobType.SCHEMA_CHANGE) {
                        return alter.getSchemaChangeHandler().getAlterJobV2Num(AlterJobV2.JobState.RUNNING);
                    }
                    return alter.getMaterializedViewHandler().getAlterJobV2Num(AlterJobV2.JobState.RUNNING);
                }
            };
            gauge.addLabel(new MetricLabel("job", "alter")).addLabel(new MetricLabel("type", jobType.name())).addLabel(new MetricLabel("state", "running"));
            PALO_METRIC_REGISTER.addPaloMetrics(gauge);
        }
        MetricRepo.generateBackendsTabletMetrics();
        GaugeMetric<Integer> connections = new GaugeMetric<Integer>("connection_total", Metric.MetricUnit.CONNECTIONS, "total connections"){

            @Override
            public Integer getValue() {
                return ExecuteEnv.getInstance().getScheduler().getConnectionNum();
            }
        };
        PALO_METRIC_REGISTER.addPaloMetrics(connections);
        GaugeMetric<Long> maxJournalId = new GaugeMetric<Long>("max_journal_id", Metric.MetricUnit.NOUNIT, "max journal id of this frontends"){

            @Override
            public Long getValue() {
                EditLog editLog = Catalog.getCurrentCatalog().getEditLog();
                if (editLog == null) {
                    return -1L;
                }
                return editLog.getMaxJournalId();
            }
        };
        PALO_METRIC_REGISTER.addPaloMetrics(maxJournalId);
        GaugeMetric<Long> scheduledTabletNum = new GaugeMetric<Long>("scheduled_tablet_num", Metric.MetricUnit.NOUNIT, "number of tablets being scheduled"){

            @Override
            public Long getValue() {
                if (!Catalog.getCurrentCatalog().isMaster()) {
                    return 0L;
                }
                return Catalog.getCurrentCatalog().getTabletScheduler().getTotalNum();
            }
        };
        PALO_METRIC_REGISTER.addPaloMetrics(scheduledTabletNum);
        GAUGE_QUERY_PER_SECOND = new GaugeMetricImpl("qps", Metric.MetricUnit.NOUNIT, "query per second");
        GAUGE_QUERY_PER_SECOND.setValue(0.0);
        PALO_METRIC_REGISTER.addPaloMetrics(GAUGE_QUERY_PER_SECOND);
        GAUGE_REQUEST_PER_SECOND = new GaugeMetricImpl("rps", Metric.MetricUnit.NOUNIT, "request per second");
        GAUGE_REQUEST_PER_SECOND.setValue(0.0);
        PALO_METRIC_REGISTER.addPaloMetrics(GAUGE_REQUEST_PER_SECOND);
        GAUGE_QUERY_ERR_RATE = new GaugeMetricImpl("query_err_rate", Metric.MetricUnit.NOUNIT, "query error rate");
        PALO_METRIC_REGISTER.addPaloMetrics(GAUGE_QUERY_ERR_RATE);
        GAUGE_QUERY_ERR_RATE.setValue(0.0);
        GAUGE_MAX_TABLET_COMPACTION_SCORE = new GaugeMetricImpl("max_tablet_compaction_score", Metric.MetricUnit.NOUNIT, "max tablet compaction score of all backends");
        PALO_METRIC_REGISTER.addPaloMetrics(GAUGE_MAX_TABLET_COMPACTION_SCORE);
        GAUGE_MAX_TABLET_COMPACTION_SCORE.setValue(0L);
        COUNTER_REQUEST_ALL = new LongCounterMetric("request_total", Metric.MetricUnit.REQUESTS, "total request");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_REQUEST_ALL);
        COUNTER_QUERY_ALL = new LongCounterMetric("query_total", Metric.MetricUnit.REQUESTS, "total query");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_QUERY_ALL);
        COUNTER_QUERY_BEGIN = new LongCounterMetric("query_begin", Metric.MetricUnit.REQUESTS, "query begin");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_QUERY_BEGIN);
        COUNTER_QUERY_ERR = new LongCounterMetric("query_err", Metric.MetricUnit.REQUESTS, "total error query");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_QUERY_ERR);
        COUNTER_LOAD_ADD = new LongCounterMetric("load_add", Metric.MetricUnit.REQUESTS, "total load submit");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_LOAD_ADD);
        COUNTER_QUERY_TABLE = new LongCounterMetric("query_table", Metric.MetricUnit.REQUESTS, "total query from table");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_QUERY_TABLE);
        COUNTER_QUERY_OLAP_TABLE = new LongCounterMetric("query_olap_table", Metric.MetricUnit.REQUESTS, "total query from olap table");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_QUERY_OLAP_TABLE);
        COUNTER_CACHE_MODE_SQL = new LongCounterMetric("cache_mode_sql", Metric.MetricUnit.REQUESTS, "total query of sql mode");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_CACHE_MODE_SQL);
        COUNTER_CACHE_HIT_SQL = new LongCounterMetric("cache_hit_sql", Metric.MetricUnit.REQUESTS, "total hits query by sql model");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_CACHE_HIT_SQL);
        COUNTER_CACHE_MODE_PARTITION = new LongCounterMetric("query_mode_partition", Metric.MetricUnit.REQUESTS, "total query of partition mode");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_CACHE_MODE_PARTITION);
        COUNTER_CACHE_HIT_PARTITION = new LongCounterMetric("cache_hit_partition", Metric.MetricUnit.REQUESTS, "total hits query by partition model");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_CACHE_HIT_PARTITION);
        COUNTER_CACHE_PARTITION_ALL = new LongCounterMetric("partition_all", Metric.MetricUnit.REQUESTS, "scan partition of cache partition model");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_CACHE_PARTITION_ALL);
        COUNTER_CACHE_PARTITION_HIT = new LongCounterMetric("partition_hit", Metric.MetricUnit.REQUESTS, "hit partition of cache partition model");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_CACHE_PARTITION_HIT);
        COUNTER_LOAD_FINISHED = new LongCounterMetric("load_finished", Metric.MetricUnit.REQUESTS, "total load finished");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_LOAD_FINISHED);
        COUNTER_EDIT_LOG_WRITE = new LongCounterMetric("edit_log_write", Metric.MetricUnit.OPERATIONS, "counter of edit log write into bdbje");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_EDIT_LOG_WRITE);
        COUNTER_EDIT_LOG_READ = new LongCounterMetric("edit_log_read", Metric.MetricUnit.OPERATIONS, "counter of edit log read from bdbje");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_EDIT_LOG_READ);
        COUNTER_EDIT_LOG_SIZE_BYTES = new LongCounterMetric("edit_log_size_bytes", Metric.MetricUnit.BYTES, "size of edit log");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_EDIT_LOG_SIZE_BYTES);
        COUNTER_IMAGE_WRITE_SUCCESS = new LongCounterMetric("image_write", Metric.MetricUnit.OPERATIONS, "counter of image succeed in write");
        COUNTER_IMAGE_WRITE_SUCCESS.addLabel(new MetricLabel("type", "success"));
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_IMAGE_WRITE_SUCCESS);
        COUNTER_IMAGE_WRITE_FAILED = new LongCounterMetric("image_write", Metric.MetricUnit.OPERATIONS, "counter of image failed to write");
        COUNTER_IMAGE_WRITE_FAILED.addLabel(new MetricLabel("type", "failed"));
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_IMAGE_WRITE_FAILED);
        COUNTER_IMAGE_PUSH_SUCCESS = new LongCounterMetric("image_push", Metric.MetricUnit.OPERATIONS, "counter of image succeeded in pushing to other frontends");
        COUNTER_IMAGE_PUSH_SUCCESS.addLabel(new MetricLabel("type", "success"));
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_IMAGE_PUSH_SUCCESS);
        COUNTER_IMAGE_PUSH_FAILED = new LongCounterMetric("image_push", Metric.MetricUnit.OPERATIONS, "counter of image failed to other frontends");
        COUNTER_IMAGE_PUSH_FAILED.addLabel(new MetricLabel("type", "failed"));
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_IMAGE_PUSH_FAILED);
        COUNTER_IMAGE_CLEAN_SUCCESS = new LongCounterMetric("image_clean", Metric.MetricUnit.OPERATIONS, "counter of image succeeded in cleaning");
        COUNTER_IMAGE_CLEAN_SUCCESS.addLabel(new MetricLabel("type", "success"));
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_IMAGE_CLEAN_SUCCESS);
        COUNTER_IMAGE_CLEAN_FAILED = new LongCounterMetric("image_clean", Metric.MetricUnit.OPERATIONS, "counter of image failed to clean");
        COUNTER_IMAGE_CLEAN_FAILED.addLabel(new MetricLabel("type", "failed"));
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_IMAGE_CLEAN_FAILED);
        COUNTER_EDIT_LOG_CLEAN_SUCCESS = new LongCounterMetric("edit_log_clean", Metric.MetricUnit.OPERATIONS, "counter of edit log succeed in cleaning");
        COUNTER_EDIT_LOG_CLEAN_SUCCESS.addLabel(new MetricLabel("type", "success"));
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_EDIT_LOG_CLEAN_SUCCESS);
        COUNTER_EDIT_LOG_CLEAN_FAILED = new LongCounterMetric("edit_log_clean", Metric.MetricUnit.OPERATIONS, "counter of edit log failed to clean");
        COUNTER_EDIT_LOG_CLEAN_FAILED.addLabel(new MetricLabel("type", "failed"));
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_EDIT_LOG_CLEAN_FAILED);
        COUNTER_TXN_REJECT = new LongCounterMetric("txn_reject", Metric.MetricUnit.REQUESTS, "counter of rejected transactions");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_TXN_REJECT);
        COUNTER_TXN_BEGIN = new LongCounterMetric("txn_begin", Metric.MetricUnit.REQUESTS, "counter of beginning transactions");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_TXN_BEGIN);
        COUNTER_TXN_SUCCESS = new LongCounterMetric("txn_success", Metric.MetricUnit.REQUESTS, "counter of success transactions");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_TXN_SUCCESS);
        COUNTER_TXN_FAILED = new LongCounterMetric("txn_failed", Metric.MetricUnit.REQUESTS, "counter of failed transactions");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_TXN_FAILED);
        COUNTER_ROUTINE_LOAD_ROWS = new LongCounterMetric("routine_load_rows", Metric.MetricUnit.ROWS, "total rows of routine load");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_ROUTINE_LOAD_ROWS);
        COUNTER_ROUTINE_LOAD_RECEIVED_BYTES = new LongCounterMetric("routine_load_receive_bytes", Metric.MetricUnit.BYTES, "total received bytes of routine load");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_ROUTINE_LOAD_RECEIVED_BYTES);
        COUNTER_ROUTINE_LOAD_ERROR_ROWS = new LongCounterMetric("routine_load_error_rows", Metric.MetricUnit.ROWS, "total error rows of routine load");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_ROUTINE_LOAD_ERROR_ROWS);
        COUNTER_HIT_SQL_BLOCK_RULE = new LongCounterMetric("counter_hit_sql_block_rule", Metric.MetricUnit.ROWS, "total hit sql block rule query");
        PALO_METRIC_REGISTER.addPaloMetrics(COUNTER_HIT_SQL_BLOCK_RULE);
        HISTO_QUERY_LATENCY = METRIC_REGISTER.histogram(MetricRegistry.name((String)"query", (String[])new String[]{"latency", "ms"}));
        HISTO_EDIT_LOG_WRITE_LATENCY = METRIC_REGISTER.histogram(MetricRegistry.name((String)"editlog", (String[])new String[]{"write", "latency", "ms"}));
        METRIC_REGISTER.register(MetricRegistry.name((String)"palo", (String[])new String[]{"fe", "query", "max_instances_num_per_user"}), (com.codahale.metrics.Metric)((Gauge)() -> {
            try {
                return ((QeProcessorImpl)QeProcessorImpl.INSTANCE).getInstancesNumPerUser().values().stream().reduce(-1, BinaryOperator.maxBy(Integer::compareTo));
            }
            catch (Throwable ex) {
                LOG.warn("Get max_instances_num_per_user error", ex);
                return -2;
            }
        }));
        MetricRepo.initSystemMetrics();
        MetricRepo.updateMetrics();
        isInit = true;
        if (Config.enable_metric_calculator) {
            metricTimer.scheduleAtFixedRate(metricCalculator, 0L, 15000L, TimeUnit.MILLISECONDS);
        }
    }

    private static void initSystemMetrics() {
        GaugeMetric<Long> tcpRetransSegs = new GaugeMetric<Long>("snmp", Metric.MetricUnit.NOUNIT, "All TCP packets retransmitted"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.tcpRetransSegs;
            }
        };
        tcpRetransSegs.addLabel(new MetricLabel("name", "tcp_retrans_segs"));
        PALO_METRIC_REGISTER.addPaloMetrics(tcpRetransSegs);
        GaugeMetric<Long> tpcInErrs = new GaugeMetric<Long>("snmp", Metric.MetricUnit.NOUNIT, "The number of all problematic TCP packets received"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.tcpInErrs;
            }
        };
        tpcInErrs.addLabel(new MetricLabel("name", "tcp_in_errs"));
        PALO_METRIC_REGISTER.addPaloMetrics(tpcInErrs);
        GaugeMetric<Long> tpcInSegs = new GaugeMetric<Long>("snmp", Metric.MetricUnit.NOUNIT, "The number of all TCP packets received"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.tcpInSegs;
            }
        };
        tpcInSegs.addLabel(new MetricLabel("name", "tcp_in_segs"));
        PALO_METRIC_REGISTER.addPaloMetrics(tpcInSegs);
        GaugeMetric<Long> tpcOutSegs = new GaugeMetric<Long>("snmp", Metric.MetricUnit.NOUNIT, "The number of all TCP packets send with RST"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.tcpOutSegs;
            }
        };
        tpcOutSegs.addLabel(new MetricLabel("name", "tcp_out_segs"));
        PALO_METRIC_REGISTER.addPaloMetrics(tpcOutSegs);
        GaugeMetric<Long> memTotal = new GaugeMetric<Long>("meminfo", Metric.MetricUnit.BYTES, "Total usable memory"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.memTotal;
            }
        };
        memTotal.addLabel(new MetricLabel("name", "memory_total"));
        PALO_METRIC_REGISTER.addPaloMetrics(memTotal);
        GaugeMetric<Long> memFree = new GaugeMetric<Long>("meminfo", Metric.MetricUnit.BYTES, "The amount of physical memory not used by the system"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.memFree;
            }
        };
        memFree.addLabel(new MetricLabel("name", "memory_free"));
        PALO_METRIC_REGISTER.addPaloMetrics(memFree);
        GaugeMetric<Long> memAvailable = new GaugeMetric<Long>("meminfo", Metric.MetricUnit.BYTES, "An estimate of how much memory is available for starting new applications, without swapping"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.memAvailable;
            }
        };
        memAvailable.addLabel(new MetricLabel("name", "memory_available"));
        PALO_METRIC_REGISTER.addPaloMetrics(memAvailable);
        GaugeMetric<Long> buffers = new GaugeMetric<Long>("meminfo", Metric.MetricUnit.BYTES, "Memory in buffer cache, so relatively temporary storage for raw disk blocks"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.buffers;
            }
        };
        buffers.addLabel(new MetricLabel("name", "buffers"));
        PALO_METRIC_REGISTER.addPaloMetrics(buffers);
        GaugeMetric<Long> cached = new GaugeMetric<Long>("meminfo", Metric.MetricUnit.BYTES, "Memory in the pagecache (Diskcache and Shared Memory)"){

            @Override
            public Long getValue() {
                return MetricRepo.SYSTEM_METRICS.cached;
            }
        };
        cached.addLabel(new MetricLabel("name", "cached"));
        PALO_METRIC_REGISTER.addPaloMetrics(cached);
    }

    public static void generateBackendsTabletMetrics() {
        PALO_METRIC_REGISTER.removeMetrics(TABLET_NUM);
        PALO_METRIC_REGISTER.removeMetrics(TABLET_MAX_COMPACTION_SCORE);
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        final TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (final Long beId : infoService.getBackendIds(false)) {
            final Backend be = infoService.getBackend(beId);
            if (be == null) continue;
            GaugeMetric<Long> tabletNum = new GaugeMetric<Long>(TABLET_NUM, Metric.MetricUnit.NOUNIT, "tablet number"){

                @Override
                public Long getValue() {
                    if (!Catalog.getCurrentCatalog().isMaster()) {
                        return 0L;
                    }
                    return invertedIndex.getTabletNumByBackendId(beId);
                }
            };
            tabletNum.addLabel(new MetricLabel("backend", be.getHost() + ":" + be.getHeartbeatPort()));
            PALO_METRIC_REGISTER.addPaloMetrics(tabletNum);
            GaugeMetric<Long> tabletMaxCompactionScore = new GaugeMetric<Long>(TABLET_MAX_COMPACTION_SCORE, Metric.MetricUnit.NOUNIT, "tablet max compaction score"){

                @Override
                public Long getValue() {
                    if (!Catalog.getCurrentCatalog().isMaster()) {
                        return 0L;
                    }
                    return be.getTabletMaxCompactionScore();
                }
            };
            tabletMaxCompactionScore.addLabel(new MetricLabel("backend", be.getHost() + ":" + be.getHeartbeatPort()));
            PALO_METRIC_REGISTER.addPaloMetrics(tabletMaxCompactionScore);
        }
    }

    public static synchronized String getMetric(MetricVisitor visitor) {
        if (!isInit) {
            return "";
        }
        MetricRepo.updateMetrics();
        StringBuilder sb = new StringBuilder();
        JvmService jvmService = new JvmService();
        JvmStats jvmStats = jvmService.stats();
        visitor.visitJvm(sb, jvmStats);
        visitor.setMetricNumber(PALO_METRIC_REGISTER.getPaloMetrics().size());
        for (Metric metric : PALO_METRIC_REGISTER.getPaloMetrics()) {
            visitor.visit(sb, metric);
        }
        SortedMap histograms = METRIC_REGISTER.getHistograms();
        for (Map.Entry entry : histograms.entrySet()) {
            visitor.visitHistogram(sb, (String)entry.getKey(), (Histogram)entry.getValue());
        }
        visitor.getNodeInfo(sb);
        return sb.toString();
    }

    private static void updateMetrics() {
        SYSTEM_METRICS.update();
    }

    public static synchronized List<Metric> getMetricsByName(String name) {
        return PALO_METRIC_REGISTER.getPaloMetricsByName(name);
    }

    static {
        metricTimer = ThreadPoolManager.newDaemonScheduledThreadPool(1, "Metric-Timer-Pool", true);
        metricCalculator = new MetricCalculator();
    }
}

