/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.metric;

import java.util.List;
import java.util.TimerTask;
import org.apache.doris.metric.GaugeMetric;
import org.apache.doris.metric.Metric;
import org.apache.doris.metric.MetricRepo;

public class MetricCalculator
extends TimerTask {
    private long lastTs = -1L;
    private long lastQueryCounter = -1L;
    private long lastRequestCounter = -1L;
    private long lastQueryErrCounter = -1L;

    @Override
    public void run() {
        this.update();
    }

    private void update() {
        long currentTs = System.currentTimeMillis();
        if (this.lastTs == -1L) {
            this.lastTs = currentTs;
            this.lastQueryCounter = MetricRepo.COUNTER_QUERY_ALL.getValue();
            this.lastRequestCounter = MetricRepo.COUNTER_REQUEST_ALL.getValue();
            this.lastQueryErrCounter = MetricRepo.COUNTER_QUERY_ERR.getValue();
            return;
        }
        long interval = (currentTs - this.lastTs) / 1000L + 1L;
        long currentQueryCounter = MetricRepo.COUNTER_QUERY_ALL.getValue();
        double qps = (double)(currentQueryCounter - this.lastQueryCounter) / (double)interval;
        MetricRepo.GAUGE_QUERY_PER_SECOND.setValue(qps < 0.0 ? 0.0 : qps);
        this.lastQueryCounter = currentQueryCounter;
        long currentRequestCounter = MetricRepo.COUNTER_REQUEST_ALL.getValue();
        double rps = (double)(currentRequestCounter - this.lastRequestCounter) / (double)interval;
        MetricRepo.GAUGE_REQUEST_PER_SECOND.setValue(rps < 0.0 ? 0.0 : rps);
        this.lastRequestCounter = currentRequestCounter;
        long currentErrCounter = MetricRepo.COUNTER_QUERY_ERR.getValue();
        double errRate = (double)(currentErrCounter - this.lastQueryErrCounter) / (double)interval;
        MetricRepo.GAUGE_QUERY_ERR_RATE.setValue(errRate < 0.0 ? 0.0 : errRate);
        this.lastQueryErrCounter = currentErrCounter;
        this.lastTs = currentTs;
        long maxCompactionScore = 0L;
        List<Metric> compactionScoreMetrics = MetricRepo.getMetricsByName("tablet_max_compaction_score");
        for (Metric metric : compactionScoreMetrics) {
            if ((Long)((GaugeMetric)metric).getValue() <= maxCompactionScore) continue;
            maxCompactionScore = (Long)((GaugeMetric)metric).getValue();
        }
        MetricRepo.GAUGE_MAX_TABLET_COMPACTION_SCORE.setValue(maxCompactionScore);
    }
}

