/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.metric;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.metric.MetricLabel;

public abstract class Metric<T> {
    protected String name;
    protected MetricType type;
    protected MetricUnit unit;
    protected List<MetricLabel> labels = Lists.newArrayList();
    protected String description;

    public Metric(String name, MetricType type, MetricUnit unit, String description) {
        this.name = name;
        this.type = type;
        this.unit = unit;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public MetricType getType() {
        return this.type;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public String getDescription() {
        return this.description;
    }

    public Metric<T> addLabel(MetricLabel label) {
        if (this.labels.contains(label)) {
            return this;
        }
        this.labels.add(label);
        return this;
    }

    public List<MetricLabel> getLabels() {
        return this.labels;
    }

    public abstract T getValue();

    public static enum MetricUnit {
        NANOSECONDS,
        MICROSECONDS,
        MILLISECONDS,
        SECONDS,
        BYTES,
        ROWS,
        PERCENT,
        REQUESTS,
        OPERATIONS,
        BLOCKS,
        ROWSETS,
        CONNECTIONS,
        PACKETS,
        NOUNIT;

    }

    public static enum MetricType {
        GAUGE,
        COUNTER;

    }
}

