/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.metric;

import com.codahale.metrics.Histogram;
import java.util.List;
import org.apache.doris.metric.Metric;
import org.apache.doris.metric.MetricLabel;
import org.apache.doris.metric.MetricVisitor;
import org.apache.doris.monitor.jvm.JvmStats;

public class JsonMetricVisitor
extends MetricVisitor {
    private int ordinal = 0;
    private int metricNumber = 0;

    public JsonMetricVisitor(String prefix) {
        super(prefix);
    }

    @Override
    public void setMetricNumber(int metricNumber) {
        this.metricNumber = metricNumber;
    }

    @Override
    public void visitJvm(StringBuilder sb, JvmStats jvmStats) {
    }

    @Override
    public void visit(StringBuilder sb, Metric metric) {
        if (this.ordinal++ == 0) {
            sb.append("[\n");
        }
        sb.append("{\n\t\"tags\":\n\t{\n");
        sb.append("\t\t\"metric\":\"").append(metric.getName()).append("\"");
        List<MetricLabel> labels = metric.getLabels();
        if (!labels.isEmpty()) {
            sb.append(",\n");
            int i = 0;
            for (MetricLabel label : labels) {
                if (i++ > 0) {
                    sb.append(",\n");
                }
                sb.append("\t\t\"").append(label.getKey()).append("\":\"").append(label.getValue()).append("\"");
            }
        }
        sb.append("\n\t},\n");
        sb.append("\t\"unit\":\"").append(metric.getUnit().name().toLowerCase()).append("\",\n");
        sb.append("\t\"value\":").append(metric.getValue().toString()).append("\n}");
        if (this.ordinal < this.metricNumber) {
            sb.append(",\n");
        } else {
            sb.append("\n]");
        }
    }

    @Override
    public void visitHistogram(StringBuilder sb, String name, Histogram histogram) {
    }

    @Override
    public void getNodeInfo(StringBuilder sb) {
    }
}

