/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.metric;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.metric.Metric;

public class DorisMetricRegistry {
    private Collection<Metric> paloMetrics = new PriorityQueue<Metric>(Comparator.comparing(Metric::getName));

    public synchronized void addPaloMetrics(Metric paloMetric) {
        if (!Catalog.isCheckpointThread()) {
            this.paloMetrics.add(paloMetric);
        }
    }

    public synchronized List<Metric> getPaloMetrics() {
        return Lists.newArrayList(this.paloMetrics);
    }

    public synchronized List<Metric> getPaloMetricsByName(String name) {
        return this.paloMetrics.stream().filter(m -> m.getName().equals(name)).collect(Collectors.toList());
    }

    public synchronized void removeMetrics(String name) {
        if (!Catalog.isCheckpointThread()) {
            this.paloMetrics = this.paloMetrics.stream().filter(m -> !m.getName().equals(name)).collect(Collectors.toList());
        }
    }
}

