/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.master;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.common.Config;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.util.Daemon;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.metric.GaugeMetric;
import org.apache.doris.metric.Metric;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.persist.BackendReplicasInfo;
import org.apache.doris.persist.BackendTabletsInfo;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.ClearTransactionTask;
import org.apache.doris.task.CreateReplicaTask;
import org.apache.doris.task.DropReplicaTask;
import org.apache.doris.task.MasterTask;
import org.apache.doris.task.PublishVersionTask;
import org.apache.doris.task.PushTask;
import org.apache.doris.task.StorageMediaMigrationTask;
import org.apache.doris.task.UpdateTabletMetaInfoTask;
import org.apache.doris.thrift.TBackend;
import org.apache.doris.thrift.TDisk;
import org.apache.doris.thrift.TMasterResult;
import org.apache.doris.thrift.TPartitionVersionInfo;
import org.apache.doris.thrift.TPushType;
import org.apache.doris.thrift.TReportRequest;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TStorageType;
import org.apache.doris.thrift.TTablet;
import org.apache.doris.thrift.TTabletInfo;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class ReportHandler
extends Daemon {
    private static final Logger LOG = LogManager.getLogger(ReportHandler.class);
    private BlockingQueue<ReportTask> reportQueue = Queues.newLinkedBlockingQueue();

    public ReportHandler() {
        GaugeMetric<Long> gauge = new GaugeMetric<Long>("report_queue_size", Metric.MetricUnit.NOUNIT, "report queue size"){

            @Override
            public Long getValue() {
                return ReportHandler.this.reportQueue.size();
            }
        };
        MetricRepo.PALO_METRIC_REGISTER.addPaloMetrics(gauge);
    }

    public TMasterResult handleReport(TReportRequest request) throws TException {
        TMasterResult result = new TMasterResult();
        TStatus tStatus = new TStatus(TStatusCode.OK);
        result.setStatus(tStatus);
        TBackend tBackend = request.getBackend();
        String host = tBackend.getHost();
        int bePort = tBackend.getBePort();
        Backend backend = Catalog.getCurrentSystemInfo().getBackendWithBePort(host, bePort);
        if (backend == null) {
            tStatus.setStatusCode(TStatusCode.INTERNAL_ERROR);
            ArrayList errorMsgs = Lists.newArrayList();
            errorMsgs.add("backend[" + host + ":" + bePort + "] does not exist.");
            tStatus.setErrorMsgs((List)errorMsgs);
            return result;
        }
        long beId = backend.getId();
        Map tasks = null;
        Map disks = null;
        Map<Long, TTablet> tablets = null;
        long reportVersion = -1L;
        ReportType reportType = ReportType.UNKNOWN;
        if (request.isSetTasks()) {
            tasks = request.getTasks();
            reportType = ReportType.TASK;
        }
        if (request.isSetDisks()) {
            disks = request.getDisks();
            reportType = ReportType.DISK;
        }
        if (request.isSetTablets()) {
            tablets = request.getTablets();
            reportVersion = request.getReportVersion();
            reportType = ReportType.TABLET;
        } else if (request.isSetTabletList()) {
            tablets = this.buildTabletMap(request.getTabletList());
            reportVersion = request.getReportVersion();
            reportType = ReportType.TABLET;
        }
        if (request.isSetTabletMaxCompactionScore()) {
            backend.setTabletMaxCompactionScore(request.getTabletMaxCompactionScore());
        }
        ReportTask reportTask = new ReportTask(beId, tasks, disks, tablets, reportVersion);
        try {
            this.putToQueue(reportTask);
        }
        catch (Exception e) {
            tStatus.setStatusCode(TStatusCode.INTERNAL_ERROR);
            ArrayList errorMsgs = Lists.newArrayList();
            errorMsgs.add("failed to put report task to queue. queue size: " + this.reportQueue.size());
            errorMsgs.add("err: " + e.getMessage());
            tStatus.setErrorMsgs((List)errorMsgs);
            return result;
        }
        LOG.info("receive report from be {}. type: {}, current queue size: {}", (Object)backend.getId(), (Object)reportType, (Object)this.reportQueue.size());
        return result;
    }

    private void putToQueue(ReportTask reportTask) throws Exception {
        int currentSize = this.reportQueue.size();
        if (currentSize > Config.report_queue_size) {
            LOG.warn("the report queue size exceeds the limit: {}. current: {}", (Object)Config.report_queue_size, (Object)currentSize);
            throw new Exception("the report queue size exceeds the limit: " + Config.report_queue_size + ". current: " + currentSize);
        }
        this.reportQueue.put(reportTask);
    }

    private Map<Long, TTablet> buildTabletMap(List<TTablet> tabletList) {
        HashMap tabletMap = Maps.newHashMap();
        for (TTablet tTablet : tabletList) {
            if (tTablet.getTabletInfos().isEmpty()) continue;
            tabletMap.put(((TTabletInfo)tTablet.getTabletInfos().get(0)).getTabletId(), tTablet);
        }
        return tabletMap;
    }

    private static void tabletReport(long backendId, Map<Long, TTablet> backendTablets, long backendReportVersion) {
        SystemInfoService currentSystemInfo;
        Backend reportBackend;
        long start = System.currentTimeMillis();
        LOG.info("backend[{}] reports {} tablet(s). report version: {}", (Object)backendId, (Object)backendTablets.size(), (Object)backendReportVersion);
        HashMap<Long, TStorageMedium> storageMediumMap = Config.disable_storage_medium_check ? Maps.newHashMap() : Catalog.getCurrentCatalog().getPartitionIdToStorageMediumMap();
        LinkedListMultimap tabletSyncMap = LinkedListMultimap.create();
        LinkedListMultimap tabletDeleteFromMeta = LinkedListMultimap.create();
        Set foundTabletsWithValidSchema = Sets.newConcurrentHashSet();
        ConcurrentMap foundTabletsWithInvalidSchema = Maps.newConcurrentMap();
        LinkedListMultimap tabletMigrationMap = LinkedListMultimap.create();
        HashMap transactionsToPublish = Maps.newHashMap();
        LinkedListMultimap transactionsToClear = LinkedListMultimap.create();
        LinkedListMultimap tabletRecoveryMap = LinkedListMultimap.create();
        ArrayList tabletToInMemory = Lists.newArrayList();
        Catalog.getCurrentInvertedIndex().tabletReport(backendId, backendTablets, storageMediumMap, (ListMultimap<Long, Long>)tabletSyncMap, (ListMultimap<Long, Long>)tabletDeleteFromMeta, foundTabletsWithValidSchema, foundTabletsWithInvalidSchema, (ListMultimap<TStorageMedium, Long>)tabletMigrationMap, transactionsToPublish, (ListMultimap<Long, Long>)transactionsToClear, (ListMultimap<Long, Long>)tabletRecoveryMap, tabletToInMemory);
        if (!tabletSyncMap.isEmpty()) {
            ReportHandler.sync(backendTablets, (ListMultimap<Long, Long>)tabletSyncMap, backendId, backendReportVersion);
        }
        if (!tabletDeleteFromMeta.isEmpty()) {
            ReportHandler.deleteFromMeta((ListMultimap<Long, Long>)tabletDeleteFromMeta, backendId, backendReportVersion);
        }
        if (foundTabletsWithValidSchema.size() != backendTablets.size()) {
            ReportHandler.deleteFromBackend(backendTablets, foundTabletsWithValidSchema, foundTabletsWithInvalidSchema, backendId);
        }
        if (!Config.disable_storage_medium_check && !tabletMigrationMap.isEmpty()) {
            ReportHandler.handleMigration((ListMultimap<TStorageMedium, Long>)tabletMigrationMap, backendId);
        }
        if (!transactionsToClear.isEmpty()) {
            ReportHandler.handleClearTransactions((ListMultimap<Long, Long>)transactionsToClear, backendId);
        }
        if (!transactionsToPublish.isEmpty()) {
            ReportHandler.handleRepublishVersionInfo(transactionsToPublish, backendId);
        }
        if (!tabletRecoveryMap.isEmpty()) {
            ReportHandler.handleRecoverTablet((ListMultimap<Long, Long>)tabletRecoveryMap, backendTablets, backendId);
        }
        if (!tabletToInMemory.isEmpty()) {
            ReportHandler.handleSetTabletInMemory(backendId, tabletToInMemory);
        }
        if ((reportBackend = (currentSystemInfo = Catalog.getCurrentSystemInfo()).getBackend(backendId)) != null) {
            Backend.BackendStatus backendStatus = reportBackend.getBackendStatus();
            backendStatus.lastSuccessReportTabletsTime = TimeUtils.longToTimeString(start);
        }
        long end = System.currentTimeMillis();
        LOG.info("finished to handle tablet report from backend[{}] cost: {} ms", (Object)backendId, (Object)(end - start));
    }

    private static void taskReport(long backendId, Map<TTaskType, Set<Long>> runningTasks) {
        LOG.debug("begin to handle task report from backend {}", (Object)backendId);
        long start = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            for (TTaskType type : runningTasks.keySet()) {
                Set<Long> taskSet = runningTasks.get(type);
                if (taskSet.isEmpty()) continue;
                String signatures = StringUtils.join(taskSet, (String)", ");
                LOG.debug("backend task[{}]: {}", (Object)type.name(), (Object)signatures);
            }
        }
        List<AgentTask> diffTasks = AgentTaskQueue.getDiffTasks(backendId, runningTasks);
        AgentBatchTask batchTask = new AgentBatchTask();
        long taskReportTime = System.currentTimeMillis();
        for (AgentTask task : diffTasks) {
            if (task.getTaskType() == TTaskType.CREATE || task.getTaskType() == TTaskType.PUSH && ((PushTask)task).getPushType() == TPushType.DELETE && ((PushTask)task).isSyncDelete() || task.getTaskType() == TTaskType.CHECK_CONSISTENCY || !task.shouldResend(taskReportTime)) continue;
            batchTask.addTask(task);
        }
        LOG.debug("get {} diff task(s) to resend", (Object)batchTask.getTaskNum());
        if (batchTask.getTaskNum() > 0) {
            AgentTaskExecutor.submit(batchTask);
        }
        LOG.info("finished to handle task report from backend {}, diff task num: {}. cost: {} ms", (Object)backendId, (Object)batchTask.getTaskNum(), (Object)(System.currentTimeMillis() - start));
    }

    private static void diskReport(long backendId, Map<String, TDisk> backendDisks) {
        LOG.info("begin to handle disk report from backend {}", (Object)backendId);
        long start = System.currentTimeMillis();
        Backend backend = Catalog.getCurrentSystemInfo().getBackend(backendId);
        if (backend == null) {
            LOG.warn("backend doesn't exist. id: " + backendId);
            return;
        }
        backend.updateDisks(backendDisks);
        LOG.info("finished to handle disk report from backend {}, cost: {} ms", (Object)backendId, (Object)(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sync(Map<Long, TTablet> backendTablets, ListMultimap<Long, Long> tabletSyncMap, long backendId, long backendReportVersion) {
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (Long dbId : tabletSyncMap.keySet()) {
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) continue;
            int syncCounter = 0;
            List tabletIds = tabletSyncMap.get((Object)dbId);
            LOG.info("before sync tablets in db[{}]. report num: {}. backend[{}]", (Object)dbId, (Object)tabletIds.size(), (Object)backendId);
            List<TabletMeta> tabletMetaList = invertedIndex.getTabletMetaList(tabletIds);
            for (int i = 0; i < tabletMetaList.size(); ++i) {
                TabletMeta tabletMeta = tabletMetaList.get(i);
                if (tabletMeta == TabletInvertedIndex.NOT_EXIST_TABLET_META) continue;
                long tabletId = (Long)tabletIds.get(i);
                long tableId = tabletMeta.getTableId();
                OlapTable olapTable = (OlapTable)db.getTableNullable(tableId);
                if (olapTable == null || !olapTable.writeLockIfExist()) continue;
                try {
                    Replica replica;
                    long indexId;
                    MaterializedIndex index;
                    long partitionId = tabletMeta.getPartitionId();
                    Partition partition = olapTable.getPartition(partitionId);
                    if (partition == null || (index = partition.getIndex(indexId = tabletMeta.getIndexId())) == null) continue;
                    int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                    Tablet tablet = index.getTablet(tabletId);
                    if (tablet == null || (replica = tablet.getReplicaByBackendId(backendId)) == null || replica.getState() != Replica.ReplicaState.NORMAL) continue;
                    long metaVersion = replica.getVersion();
                    long backendVersion = -1L;
                    long rowCount = -1L;
                    long dataSize = -1L;
                    for (TTabletInfo tabletInfo : backendTablets.get(tabletId).getTabletInfos()) {
                        if (tabletInfo.getSchemaHash() != schemaHash) continue;
                        backendVersion = tabletInfo.getVersion();
                        rowCount = tabletInfo.getRowCount();
                        dataSize = tabletInfo.getDataSize();
                        break;
                    }
                    if (backendVersion == -1L) continue;
                    if (metaVersion < backendVersion || metaVersion == backendVersion && replica.isBad()) {
                        if (backendReportVersion < Catalog.getCurrentSystemInfo().getBackendReportVersion(backendId)) continue;
                        replica.updateVersionInfo(backendVersion, dataSize, rowCount);
                        if (replica.getLastFailedVersion() < 0L) {
                            ReplicaPersistInfo info = ReplicaPersistInfo.createForClone(dbId, tableId, partitionId, indexId, tabletId, backendId, replica.getId(), replica.getVersion(), schemaHash, dataSize, rowCount, replica.getLastFailedVersion(), replica.getLastSuccessVersion());
                            Catalog.getCurrentCatalog().getEditLog().logUpdateReplica(info);
                        }
                        ++syncCounter;
                        LOG.debug("sync replica {} of tablet {} in backend {} in db {}. report version: {}", (Object)replica.getId(), (Object)tabletId, (Object)backendId, (Object)dbId, (Object)backendReportVersion);
                        continue;
                    }
                    LOG.debug("replica {} of tablet {} in backend {} version is changed between check and real sync. meta[{}]. backend[{}]", (Object)replica.getId(), (Object)tabletId, (Object)backendId, (Object)metaVersion, (Object)backendVersion);
                    continue;
                }
                finally {
                    olapTable.writeUnlock();
                }
            }
            LOG.info("sync {} tablets in db[{}]. backend[{}]", (Object)syncCounter, (Object)dbId, (Object)backendId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFromMeta(ListMultimap<Long, Long> tabletDeleteFromMeta, long backendId, long backendReportVersion) {
        AgentBatchTask createReplicaBatchTask = new AgentBatchTask();
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (Long dbId : tabletDeleteFromMeta.keySet()) {
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) continue;
            int deleteCounter = 0;
            List tabletIds = tabletDeleteFromMeta.get((Object)dbId);
            List<TabletMeta> tabletMetaList = invertedIndex.getTabletMetaList(tabletIds);
            for (int i = 0; i < tabletMetaList.size(); ++i) {
                TabletMeta tabletMeta = tabletMetaList.get(i);
                if (tabletMeta == TabletInvertedIndex.NOT_EXIST_TABLET_META) continue;
                long tabletId = (Long)tabletIds.get(i);
                long tableId = tabletMeta.getTableId();
                OlapTable olapTable = (OlapTable)db.getTableNullable(tableId);
                if (olapTable == null || !olapTable.writeLockIfExist()) continue;
                try {
                    Replica.ReplicaState state;
                    long currentBackendReportVersion;
                    Replica replica;
                    Tablet tablet;
                    long partitionId = tabletMeta.getPartitionId();
                    Partition partition = olapTable.getPartition(partitionId);
                    if (partition == null) continue;
                    short replicationNum = olapTable.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum();
                    long indexId = tabletMeta.getIndexId();
                    MaterializedIndex index = partition.getIndex(indexId);
                    if (index == null || index.getState() == MaterializedIndex.IndexState.SHADOW || (tablet = index.getTablet(tabletId)) == null || (replica = tablet.getReplicaByBackendId(backendId)) == null || backendReportVersion < (currentBackendReportVersion = Catalog.getCurrentSystemInfo().getBackendReportVersion(backendId)) || (state = replica.getState()) != Replica.ReplicaState.NORMAL && state != Replica.ReplicaState.SCHEMA_CHANGE) continue;
                    List<Replica> replicas = tablet.getReplicas();
                    if (replicas.size() <= 1) {
                        LOG.error("backend [{}] invalid situation. tablet[{}] has few replica[{}], replica num setting is [{}]", (Object)backendId, (Object)tabletId, (Object)replicas.size(), (Object)replicationNum);
                        if (replicas.size() != 1) continue;
                        if (Config.recover_with_empty_tablet) {
                            LOG.warn("tablet {} has only one replica {} on backend {} and it is lost. create an empty replica to recover it", (Object)tabletId, (Object)replica.getId(), (Object)backendId);
                            MaterializedIndexMeta indexMeta = olapTable.getIndexMetaByIndexId(indexId);
                            Set<String> bfColumns = olapTable.getCopiedBfColumns();
                            double bfFpp = olapTable.getBfFpp();
                            CreateReplicaTask createReplicaTask = new CreateReplicaTask(backendId, dbId, tableId, partitionId, indexId, tabletId, indexMeta.getShortKeyColumnCount(), indexMeta.getSchemaHash(), partition.getVisibleVersion(), indexMeta.getKeysType(), TStorageType.COLUMN, TStorageMedium.HDD, indexMeta.getSchema(), bfColumns, bfFpp, null, olapTable.getCopiedIndexes(), olapTable.isInMemory(), olapTable.getPartitionInfo().getTabletType(partitionId), olapTable.getCompressionType());
                            createReplicaTask.setIsRecoverTask(true);
                            createReplicaBatchTask.addTask(createReplicaTask);
                            continue;
                        }
                        if (!replica.setBad(true)) continue;
                        LOG.warn("tablet {} has only one replica {} on backend {} and it is lost, set it as bad", (Object)tabletId, (Object)replica.getId(), (Object)backendId);
                        BackendTabletsInfo tabletsInfo = new BackendTabletsInfo(backendId);
                        tabletsInfo.setBad(true);
                        ReplicaPersistInfo replicaPersistInfo = ReplicaPersistInfo.createForReport(dbId, tableId, partitionId, indexId, tabletId, backendId, replica.getId());
                        tabletsInfo.addReplicaInfo(replicaPersistInfo);
                        Catalog.getCurrentCatalog().getEditLog().logBackendTabletsInfo(tabletsInfo);
                        continue;
                    }
                    tablet.deleteReplicaByBackendId(backendId);
                    ++deleteCounter;
                    AgentTaskQueue.removeReplicaRelatedTasks(backendId, tabletId);
                    ReplicaPersistInfo info = ReplicaPersistInfo.createForDelete(dbId, tableId, partitionId, indexId, tabletId, backendId);
                    Catalog.getCurrentCatalog().getEditLog().logDeleteReplica(info);
                    LOG.warn("delete replica[{}] in tablet[{}] from meta. backend[{}], report version: {}, current report version: {}", (Object)replica.getId(), (Object)tabletId, (Object)backendId, (Object)backendReportVersion, (Object)currentBackendReportVersion);
                    replicas = tablet.getReplicas();
                    if (replicas.size() != 0) continue;
                    LOG.error("invalid situation. tablet[{}] is empty", (Object)tabletId);
                    continue;
                }
                finally {
                    olapTable.writeUnlock();
                }
            }
            LOG.info("delete {} replica(s) from catalog in db[{}]", (Object)deleteCounter, (Object)dbId);
        }
        if (Config.recover_with_empty_tablet && createReplicaBatchTask.getTaskNum() > 0) {
            AgentTaskQueue.addBatchTask(createReplicaBatchTask);
            AgentTaskExecutor.submit(createReplicaBatchTask);
        }
    }

    private static void deleteFromBackend(Map<Long, TTablet> backendTablets, Set<Long> foundTabletsWithValidSchema, Map<Long, TTabletInfo> foundTabletsWithInvalidSchema, long backendId) {
        int deleteFromBackendCounter = 0;
        int addToMetaCounter = 0;
        AgentBatchTask batchTask = new AgentBatchTask();
        if (foundTabletsWithValidSchema.size() + foundTabletsWithInvalidSchema.size() == backendTablets.size()) {
            for (Long tabletId : foundTabletsWithInvalidSchema.keySet()) {
                int schemaHash = foundTabletsWithInvalidSchema.get(tabletId).getSchemaHash();
                DropReplicaTask task = new DropReplicaTask(backendId, tabletId, schemaHash);
                batchTask.addTask(task);
                LOG.warn("delete tablet[" + tabletId + " - " + schemaHash + "] from backend[" + backendId + "] because invalid schema hash");
                ++deleteFromBackendCounter;
            }
        } else {
            for (Long tabletId : backendTablets.keySet()) {
                if (foundTabletsWithInvalidSchema.containsKey(tabletId)) {
                    int schemaHash = foundTabletsWithInvalidSchema.get(tabletId).getSchemaHash();
                    DropReplicaTask task = new DropReplicaTask(backendId, tabletId, schemaHash);
                    batchTask.addTask(task);
                    LOG.warn("delete tablet[" + tabletId + " - " + schemaHash + "] from backend[" + backendId + "] because invalid schema hash");
                    ++deleteFromBackendCounter;
                    continue;
                }
                TTablet backendTablet = backendTablets.get(tabletId);
                for (TTabletInfo backendTabletInfo : backendTablet.getTabletInfos()) {
                    boolean needDelete = false;
                    if (!foundTabletsWithValidSchema.contains(tabletId)) {
                        if (ReportHandler.isBackendReplicaHealthy(backendTabletInfo)) {
                            try {
                                ReportHandler.addReplica(tabletId, backendTabletInfo, backendId);
                                needDelete = false;
                                ++addToMetaCounter;
                            }
                            catch (MetaNotFoundException e) {
                                LOG.info("failed add to meta. tablet[{}], backend[{}]. {}", (Object)tabletId, (Object)backendId, (Object)e.getMessage());
                                needDelete = true;
                            }
                        } else {
                            needDelete = true;
                        }
                    }
                    if (!needDelete) continue;
                    DropReplicaTask task = new DropReplicaTask(backendId, tabletId, backendTabletInfo.getSchemaHash());
                    batchTask.addTask(task);
                    LOG.info("delete tablet[" + tabletId + " - " + backendTabletInfo.getSchemaHash() + "] from backend[" + backendId + "] because not found in meta");
                    ++deleteFromBackendCounter;
                }
            }
        }
        if (batchTask.getTaskNum() != 0) {
            AgentTaskExecutor.submit(batchTask);
        }
        LOG.info("delete {} tablet(s) and add {} replica(s) to meta from backend[{}]", (Object)deleteFromBackendCounter, (Object)addToMetaCounter, (Object)backendId);
    }

    private static boolean isBackendReplicaHealthy(TTabletInfo backendTabletInfo) {
        if (backendTabletInfo.isSetUsed() && !backendTabletInfo.isUsed()) {
            return false;
        }
        return !backendTabletInfo.isSetVersionMiss() || !backendTabletInfo.isVersionMiss();
    }

    private static void handleMigration(ListMultimap<TStorageMedium, Long> tabletMetaMigrationMap, long backendId) {
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        Backend be = infoService.getBackend(backendId);
        if (be == null) {
            return;
        }
        AgentBatchTask batchTask = new AgentBatchTask();
        for (TStorageMedium storageMedium : tabletMetaMigrationMap.keySet()) {
            List tabletIds = tabletMetaMigrationMap.get((Object)storageMedium);
            if (!be.hasSpecifiedStorageMedium(storageMedium)) {
                LOG.warn("no specified storage medium {} on backend {}, skip storage migration. sample tablet id: {}", (Object)storageMedium, (Object)backendId, (Object)(tabletIds.isEmpty() ? "-1" : tabletIds.get(0)));
                continue;
            }
            List<TabletMeta> tabletMetaList = invertedIndex.getTabletMetaList(tabletIds);
            for (int i = 0; i < tabletMetaList.size(); ++i) {
                long tabletId = (Long)tabletIds.get(i);
                TabletMeta tabletMeta = tabletMetaList.get(i);
                int effectiveSchemaHash = tabletMeta.getOldSchemaHash();
                StorageMediaMigrationTask task = new StorageMediaMigrationTask(backendId, tabletId, effectiveSchemaHash, storageMedium);
                batchTask.addTask(task);
            }
        }
        AgentTaskExecutor.submit(batchTask);
    }

    private static void handleRepublishVersionInfo(Map<Long, ListMultimap<Long, TPartitionVersionInfo>> transactionsToPublish, long backendId) {
        AgentBatchTask batchTask = new AgentBatchTask();
        long createPublishVersionTaskTime = System.currentTimeMillis();
        for (Long dbId : transactionsToPublish.keySet()) {
            ListMultimap<Long, TPartitionVersionInfo> map = transactionsToPublish.get(dbId);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                long txnId = (Long)iterator.next();
                PublishVersionTask task = new PublishVersionTask(backendId, txnId, dbId, map.get((Object)txnId), createPublishVersionTaskTime);
                batchTask.addTask(task);
                AgentTaskQueue.addTask(task);
            }
        }
        AgentTaskExecutor.submit(batchTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleRecoverTablet(ListMultimap<Long, Long> tabletRecoveryMap, Map<Long, TTablet> backendTablets, long backendId) {
        LOG.warn("find {} tablets on backend {} which is bad or misses versions that need clone or force recovery", (Object)tabletRecoveryMap.size(), (Object)backendId);
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        BackendReplicasInfo backendReplicasInfo = new BackendReplicasInfo(backendId);
        for (Long dbId : tabletRecoveryMap.keySet()) {
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) continue;
            List tabletIds = tabletRecoveryMap.get((Object)dbId);
            List<TabletMeta> tabletMetaList = invertedIndex.getTabletMetaList(tabletIds);
            block8: for (int i = 0; i < tabletMetaList.size(); ++i) {
                TabletMeta tabletMeta = tabletMetaList.get(i);
                if (tabletMeta == TabletInvertedIndex.NOT_EXIST_TABLET_META) continue;
                long tabletId = (Long)tabletIds.get(i);
                long tableId = tabletMeta.getTableId();
                OlapTable olapTable = (OlapTable)db.getTableNullable(tableId);
                if (olapTable == null || !olapTable.writeLockIfExist()) continue;
                try {
                    Replica replica;
                    long indexId;
                    MaterializedIndex index;
                    long partitionId = tabletMeta.getPartitionId();
                    Partition partition = olapTable.getPartition(partitionId);
                    if (partition == null || (index = partition.getIndex(indexId = tabletMeta.getIndexId())) == null) continue;
                    int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                    Tablet tablet = index.getTablet(tabletId);
                    if (tablet == null || (replica = tablet.getReplicaByBackendId(backendId)) == null) continue;
                    for (TTabletInfo tTabletInfo : backendTablets.get(tabletId).getTabletInfos()) {
                        if (tTabletInfo.getSchemaHash() != schemaHash) continue;
                        if (tTabletInfo.isSetUsed() && !tTabletInfo.isUsed()) {
                            if (!replica.setBad(true)) continue block8;
                            LOG.warn("set bad for replica {} of tablet {} on backend {}", (Object)replica.getId(), (Object)tabletId, (Object)backendId);
                            backendReplicasInfo.addBadReplica(tabletId);
                            continue block8;
                        }
                        if (!tTabletInfo.isSetVersionMiss() || !tTabletInfo.isVersionMiss()) continue;
                        long newLastFailedVersion = replica.getLastFailedVersion();
                        if (newLastFailedVersion < 0L) {
                            newLastFailedVersion = replica.getVersion() + 1L;
                        }
                        replica.updateLastFailedVersion(newLastFailedVersion);
                        backendReplicasInfo.addMissingVersionReplica(tabletId, newLastFailedVersion);
                        continue block8;
                    }
                    continue;
                }
                finally {
                    olapTable.writeUnlock();
                }
            }
        }
        if (!backendReplicasInfo.isEmpty()) {
            Catalog.getCurrentCatalog().getEditLog().logBackendReplicasInfo(backendReplicasInfo);
        }
    }

    private static void handleSetTabletInMemory(long backendId, List<Triple<Long, Integer, Boolean>> tabletToInMemory) {
        AgentBatchTask batchTask = new AgentBatchTask();
        UpdateTabletMetaInfoTask task = new UpdateTabletMetaInfoTask(backendId, tabletToInMemory);
        batchTask.addTask(task);
        AgentTaskExecutor.submit(batchTask);
    }

    private static void handleClearTransactions(ListMultimap<Long, Long> transactionsToClear, long backendId) {
        AgentBatchTask batchTask = new AgentBatchTask();
        for (Long transactionId : transactionsToClear.keySet()) {
            ClearTransactionTask clearTransactionTask = new ClearTransactionTask(backendId, transactionId, transactionsToClear.get((Object)transactionId));
            batchTask.addTask(clearTransactionTask);
        }
        AgentTaskExecutor.submit(batchTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addReplica(long tabletId, TTabletInfo backendTabletInfo, long backendId) throws MetaNotFoundException {
        block16: {
            TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
            SystemInfoService infoService = Catalog.getCurrentSystemInfo();
            TabletMeta tabletMeta = invertedIndex.getTabletMeta(tabletId);
            if (tabletMeta == null || tabletMeta == TabletInvertedIndex.NOT_EXIST_TABLET_META) {
                throw new MetaNotFoundException("tablet meta[" + tabletMeta + "] does not exist in tablet inverted index");
            }
            long dbId = tabletMeta.getDbId();
            long tableId = tabletMeta.getTableId();
            long partitionId = tabletMeta.getPartitionId();
            long indexId = tabletMeta.getIndexId();
            int schemaHash = backendTabletInfo.getSchemaHash();
            long version = backendTabletInfo.getVersion();
            long dataSize = backendTabletInfo.getDataSize();
            long rowCount = backendTabletInfo.getRowCount();
            Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbId);
            OlapTable olapTable = (OlapTable)db.getTableOrMetaException(tableId, Table.TableType.OLAP);
            olapTable.writeLockOrMetaException();
            try {
                Partition partition = olapTable.getPartition(partitionId);
                if (partition == null) {
                    throw new MetaNotFoundException("partition[" + partitionId + "] does not exist");
                }
                ReplicaAllocation replicaAlloc = olapTable.getPartitionInfo().getReplicaAllocation(partition.getId());
                MaterializedIndex materializedIndex = partition.getIndex(indexId);
                if (materializedIndex == null) {
                    throw new MetaNotFoundException("index[" + indexId + "] does not exist");
                }
                Tablet tablet = materializedIndex.getTablet(tabletId);
                if (tablet == null) {
                    throw new MetaNotFoundException("tablet[" + tabletId + "] does not exist");
                }
                long visibleVersion = partition.getVisibleVersion();
                if (version < visibleVersion) {
                    throw new MetaNotFoundException("version is invalid. tablet[" + version + "], visible[" + visibleVersion + "]");
                }
                if (schemaHash != olapTable.getSchemaHashByIndexId(indexId)) {
                    throw new MetaNotFoundException("schema hash is diff[" + schemaHash + "-" + olapTable.getSchemaHashByIndexId(indexId) + "]");
                }
                if (Catalog.getCurrentColocateIndex().isColocateTable(olapTable.getId())) {
                    return;
                }
                List<Long> aliveBeIdsInCluster = infoService.getClusterBackendIds(db.getClusterName(), true);
                Pair<Tablet.TabletStatus, TabletSchedCtx.Priority> status = tablet.getHealthStatusWithPriority(infoService, db.getClusterName(), visibleVersion, replicaAlloc, aliveBeIdsInCluster);
                if (status.first == Tablet.TabletStatus.VERSION_INCOMPLETE || status.first == Tablet.TabletStatus.REPLICA_MISSING || status.first == Tablet.TabletStatus.UNRECOVERABLE) {
                    long lastFailedVersion = -1L;
                    if (version > partition.getNextVersion() - 1L) {
                        throw new MetaNotFoundException("version is invalid. tablet[" + version + "], partition's max version [" + (partition.getNextVersion() - 1L) + "]");
                    }
                    if (version < partition.getCommittedVersion()) {
                        lastFailedVersion = partition.getCommittedVersion();
                    }
                    long replicaId = Catalog.getCurrentCatalog().getNextId();
                    Replica replica = new Replica(replicaId, backendId, version, schemaHash, dataSize, rowCount, Replica.ReplicaState.NORMAL, lastFailedVersion, version);
                    tablet.addReplica(replica);
                    ReplicaPersistInfo info = ReplicaPersistInfo.createForAdd(dbId, tableId, partitionId, indexId, tabletId, backendId, replicaId, version, schemaHash, dataSize, rowCount, lastFailedVersion, version);
                    Catalog.getCurrentCatalog().getEditLog().logAddReplica(info);
                    LOG.info("add replica[{}-{}] to catalog. backend[{}]", (Object)tabletId, (Object)replicaId, (Object)backendId);
                    break block16;
                }
                for (Replica replica : tablet.getReplicas()) {
                    if (replica.getBackendId() != backendId) continue;
                    return;
                }
                throw new MetaNotFoundException("replica is enough[" + tablet.getReplicas().size() + "-" + replicaAlloc.toCreateStmt() + "]");
            }
            finally {
                olapTable.writeUnlock();
            }
        }
    }

    @Override
    protected void runOneCycle() {
        while (true) {
            ReportTask task = null;
            try {
                task = this.reportQueue.take();
                task.exec();
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("got interupted exception when executing report", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private class ReportTask
    extends MasterTask {
        private long beId;
        private Map<TTaskType, Set<Long>> tasks;
        private Map<String, TDisk> disks;
        private Map<Long, TTablet> tablets;
        private long reportVersion;

        public ReportTask(long beId, Map<TTaskType, Set<Long>> tasks, Map<String, TDisk> disks, Map<Long, TTablet> tablets, long reportVersion) {
            this.beId = beId;
            this.tasks = tasks;
            this.disks = disks;
            this.tablets = tablets;
            this.reportVersion = reportVersion;
        }

        @Override
        protected void exec() {
            if (this.tasks != null) {
                ReportHandler.taskReport(this.beId, this.tasks);
            }
            if (this.disks != null) {
                ReportHandler.diskReport(this.beId, this.disks);
            }
            if (this.tablets != null) {
                long backendReportVersion = Catalog.getCurrentSystemInfo().getBackendReportVersion(this.beId);
                if (this.reportVersion < backendReportVersion) {
                    LOG.warn("out of date report version {} from backend[{}]. current report version[{}]", (Object)this.reportVersion, (Object)this.beId, (Object)backendReportVersion);
                } else {
                    ReportHandler.tabletReport(this.beId, this.tablets, this.reportVersion);
                }
            }
        }
    }

    private static enum ReportType {
        UNKNOWN,
        TASK,
        DISK,
        TABLET;

    }
}

