/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.master;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionInMemoryInfoCollector
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(PartitionInMemoryInfoCollector.class);

    public PartitionInMemoryInfoCollector() {
        super("PartitionInMemoryInfoCollector", Config.partition_in_memory_update_interval_secs * 1000);
    }

    @Override
    protected void runAfterCatalogReady() {
        this.updatePartitionInMemoryInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePartitionInMemoryInfo() {
        Catalog catalog = Catalog.getCurrentCatalog();
        TabletInvertedIndex tabletInvertedIndex = catalog.getTabletInvertedIndex();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        List<Long> dbIdList = catalog.getDbIds();
        for (Long dbId : dbIdList) {
            Database db = catalog.getDbNullable(dbId);
            if (db == null) {
                LOG.warn("Database [" + dbId + "] does not exist, skip to update database used data quota");
                continue;
            }
            if (db.isInfoSchemaDb()) continue;
            try {
                int partitionInMemoryCount = 0;
                for (Table table : db.getTables()) {
                    if (table.getType() != Table.TableType.OLAP) continue;
                    table.readLock();
                    try {
                        OlapTable olapTable = (OlapTable)table;
                        for (Partition partition : olapTable.getAllPartitions()) {
                            if (!olapTable.getPartitionInfo().getIsInMemory(partition.getId())) continue;
                            ++partitionInMemoryCount;
                            builder.add((Object)partition.getId());
                        }
                    }
                    finally {
                        table.readUnlock();
                    }
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Update database[{}] partition in memory info, partitionInMemoryCount : {}.", (Object)db.getFullName(), (Object)partitionInMemoryCount);
            }
            catch (Exception e) {
                LOG.warn("Update database[" + db.getFullName() + "] partition in memory info failed", (Throwable)e);
            }
        }
        ImmutableSet partitionIdInMemorySet = builder.build();
        tabletInvertedIndex.setPartitionIdInMemorySet((ImmutableSet<Long>)partitionIdInMemorySet);
    }
}

