/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.master;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.io.IOUtils;

public class MetaHelper {
    private static final String PART_SUFFIX = ".part";
    public static final String X_IMAGE_SIZE = "X-Image-Size";
    private static final int BUFFER_BYTES = 8192;
    private static final int CHECKPOINT_LIMIT_BYTES = 0x1E00000;

    public static File getMasterImageDir() {
        String metaDir = Catalog.getCurrentCatalog().getImageDir();
        return new File(metaDir);
    }

    public static int getLimit() {
        return 0x1E00000;
    }

    public static File complete(String filename, File dir) throws IOException {
        File newFile;
        File file = new File(dir, filename + PART_SUFFIX);
        if (!file.renameTo(newFile = new File(dir, filename))) {
            throw new IOException("Complete file" + filename + " failed");
        }
        return newFile;
    }

    public static OutputStream getOutputStream(String filename, File dir) throws FileNotFoundException {
        File file = new File(dir, filename + PART_SUFFIX);
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getRemoteFile(String urlStr, int timeout, OutputStream out) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            long imageSize = -1L;
            String imageSizeStr = conn.getHeaderField(X_IMAGE_SIZE);
            if (imageSizeStr != null) {
                imageSize = Long.parseLong(imageSizeStr);
            }
            BufferedInputStream bin = new BufferedInputStream(conn.getInputStream());
            long bytes = IOUtils.copyBytes((InputStream)bin, (OutputStream)out, (int)8192, (int)0x1E00000, (boolean)true);
            if (imageSize > 0L && bytes != imageSize) {
                throw new IOException("Unexpected image size, expected: " + imageSize + ", actual: " + bytes);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

