/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.master;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.load.DeleteJob;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.loadv2.SparkLoadJob;
import org.apache.doris.master.ReportHandler;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.system.Backend;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.AlterReplicaTask;
import org.apache.doris.task.CheckConsistencyTask;
import org.apache.doris.task.ClearAlterTask;
import org.apache.doris.task.CloneTask;
import org.apache.doris.task.CreateReplicaTask;
import org.apache.doris.task.DirMoveTask;
import org.apache.doris.task.DownloadTask;
import org.apache.doris.task.PublishVersionTask;
import org.apache.doris.task.PushTask;
import org.apache.doris.task.SnapshotTask;
import org.apache.doris.task.UpdateTabletMetaInfoTask;
import org.apache.doris.task.UploadTask;
import org.apache.doris.thrift.TBackend;
import org.apache.doris.thrift.TFetchResourceResult;
import org.apache.doris.thrift.TFinishTaskRequest;
import org.apache.doris.thrift.TMasterResult;
import org.apache.doris.thrift.TPushType;
import org.apache.doris.thrift.TReportRequest;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TTabletInfo;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class MasterImpl {
    private static final Logger LOG = LogManager.getLogger(MasterImpl.class);
    private ReportHandler reportHandler = new ReportHandler();

    public MasterImpl() {
        this.reportHandler.start();
    }

    public TMasterResult finishTask(TFinishTaskRequest request) {
        long signature;
        TTaskType taskType;
        TMasterResult result = new TMasterResult();
        TStatus tStatus = new TStatus(TStatusCode.OK);
        result.setStatus(tStatus);
        TStatus taskStatus = request.getTaskStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug("get task report: {}", (Object)request);
        }
        if (taskStatus.getStatusCode() != TStatusCode.OK) {
            LOG.warn("finish task reports bad. request: {}", (Object)request);
        }
        TBackend tBackend = request.getBackend();
        String host = tBackend.getHost();
        int bePort = tBackend.getBePort();
        Backend backend = Catalog.getCurrentSystemInfo().getBackendWithBePort(host, bePort);
        if (backend == null) {
            tStatus.setStatusCode(TStatusCode.CANCELLED);
            ArrayList<String> errorMsgs = new ArrayList<String>();
            errorMsgs.add("backend not exist.");
            tStatus.setErrorMsgs(errorMsgs);
            LOG.warn("backend does not found. host: {}, be port: {}. task: {}", (Object)host, (Object)bePort, (Object)request);
            return result;
        }
        long backendId = backend.getId();
        AgentTask task = AgentTaskQueue.getTask(backendId, taskType = request.getTaskType(), signature = request.getSignature());
        if (task == null) {
            if (taskType != TTaskType.DROP && taskType != TTaskType.STORAGE_MEDIUM_MIGRATE && taskType != TTaskType.RELEASE_SNAPSHOT && taskType != TTaskType.CLEAR_TRANSACTION_TASK) {
                String errMsg = "cannot find task. type: " + taskType + ", backendId: " + backendId + ", signature: " + signature;
                LOG.warn(errMsg);
                tStatus.setStatusCode(TStatusCode.CANCELLED);
                ArrayList<String> errorMsgs = new ArrayList<String>();
                errorMsgs.add(errMsg);
                tStatus.setErrorMsgs(errorMsgs);
            }
            return result;
        }
        if (taskStatus.getStatusCode() != TStatusCode.OK) {
            task.failed();
            String errMsg = "task type: " + taskType + ", status_code: " + taskStatus.getStatusCode().toString() + (taskStatus.isSetErrorMsgs() ? ", status_message: " + taskStatus.getErrorMsgs() : "") + ", backendId: " + backend + ", signature: " + signature;
            task.setErrorMsg(errMsg);
            if (taskType != TTaskType.MAKE_SNAPSHOT && taskType != TTaskType.UPLOAD && taskType != TTaskType.DOWNLOAD && taskType != TTaskType.MOVE && taskType != TTaskType.CLONE && taskType != TTaskType.PUBLISH_VERSION && taskType != TTaskType.CREATE && taskType != TTaskType.UPDATE_TABLET_META_INFO) {
                return result;
            }
        }
        try {
            switch (taskType) {
                case CREATE: {
                    Preconditions.checkState((boolean)request.isSetReportVersion());
                    this.finishCreateReplica(task, request);
                    break;
                }
                case PUSH: {
                    this.checkHasTabletInfo(request);
                    Preconditions.checkState((boolean)request.isSetReportVersion());
                    this.finishPush(task, request);
                    break;
                }
                case REALTIME_PUSH: {
                    this.checkHasTabletInfo(request);
                    Preconditions.checkState((boolean)request.isSetReportVersion());
                    this.finishRealtimePush(task, request);
                    break;
                }
                case PUBLISH_VERSION: {
                    this.finishPublishVersion(task, request);
                    break;
                }
                case CLEAR_ALTER_TASK: {
                    this.finishClearAlterTask(task, request);
                    break;
                }
                case DROP: {
                    this.finishDropReplica(task);
                    break;
                }
                case SCHEMA_CHANGE: 
                case ROLLUP: {
                    throw new RuntimeException("Schema change and rollup job is not used any more, use alter task instead");
                }
                case CLONE: {
                    this.finishClone(task, request);
                    break;
                }
                case CHECK_CONSISTENCY: {
                    this.finishConsistencyCheck(task, request);
                    break;
                }
                case MAKE_SNAPSHOT: {
                    this.finishMakeSnapshot(task, request);
                    break;
                }
                case UPLOAD: {
                    this.finishUpload(task, request);
                    break;
                }
                case DOWNLOAD: {
                    this.finishDownloadTask(task, request);
                    break;
                }
                case MOVE: {
                    this.finishMoveDirTask(task, request);
                    break;
                }
                case RECOVER_TABLET: {
                    this.finishRecoverTablet(task);
                    break;
                }
                case ALTER: {
                    this.finishAlterTask(task);
                    break;
                }
                case UPDATE_TABLET_META_INFO: {
                    this.finishUpdateTabletMeta(task, request);
                    break;
                }
            }
        }
        catch (Exception e) {
            tStatus.setStatusCode(TStatusCode.CANCELLED);
            String errMsg = "finish agent task error.";
            LOG.warn(errMsg, (Throwable)e);
            ArrayList<String> errorMsgs = new ArrayList<String>();
            errorMsgs.add(errMsg);
            tStatus.setErrorMsgs(errorMsgs);
        }
        if (tStatus.getStatusCode() == TStatusCode.OK) {
            LOG.debug("report task success. {}", (Object)request.toString());
        }
        return result;
    }

    private void checkHasTabletInfo(TFinishTaskRequest request) throws Exception {
        if (!request.isSetFinishTabletInfos() || request.getFinishTabletInfos().isEmpty()) {
            throw new Exception("tablet info is not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCreateReplica(AgentTask task, TFinishTaskRequest request) {
        try {
            CreateReplicaTask createReplicaTask = (CreateReplicaTask)task;
            if (request.getTaskStatus().getStatusCode() != TStatusCode.OK) {
                createReplicaTask.countDownToZero(task.getBackendId() + ": " + request.getTaskStatus().getErrorMsgs().toString());
            } else {
                long tabletId = createReplicaTask.getTabletId();
                if (request.isSetFinishTabletInfos()) {
                    Replica replica = Catalog.getCurrentInvertedIndex().getReplica(createReplicaTask.getTabletId(), createReplicaTask.getBackendId());
                    replica.setPathHash(((TTabletInfo)request.getFinishTabletInfos().get(0)).getPathHash());
                    if (createReplicaTask.isRecoverTask()) {
                        replica.setBad(false);
                        LOG.info("finish recover create replica task. set replica to good. tablet {}, replica {}, backend {}", (Object)tabletId, (Object)task.getBackendId(), (Object)replica.getId());
                    }
                }
                Catalog.getCurrentSystemInfo().updateBackendReportVersion(task.getBackendId(), request.getReportVersion(), task.getDbId(), task.getTableId());
                createReplicaTask.countDownLatch(task.getBackendId(), task.getSignature());
                LOG.debug("finish create replica. tablet id: {}, be: {}, report version: {}", (Object)tabletId, (Object)task.getBackendId(), (Object)request.getReportVersion());
            }
        }
        finally {
            AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.CREATE, task.getSignature());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUpdateTabletMeta(AgentTask task, TFinishTaskRequest request) {
        try {
            UpdateTabletMetaInfoTask tabletTask = (UpdateTabletMetaInfoTask)task;
            if (request.getTaskStatus().getStatusCode() != TStatusCode.OK) {
                tabletTask.countDownToZero(task.getBackendId() + ": " + request.getTaskStatus().getErrorMsgs().toString());
            } else {
                tabletTask.countDownLatch(task.getBackendId(), tabletTask.getTablets());
                LOG.debug("finish update tablet meta. tablet id: {}, be: {}", tabletTask.getTablets(), (Object)task.getBackendId());
            }
        }
        finally {
            AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.UPDATE_TABLET_META_INFO, task.getSignature());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRealtimePush(AgentTask task, TFinishTaskRequest request) {
        List finishTabletInfos = request.getFinishTabletInfos();
        Preconditions.checkState((finishTabletInfos != null && !finishTabletInfos.isEmpty() ? 1 : 0) != 0);
        PushTask pushTask = (PushTask)task;
        long dbId = pushTask.getDbId();
        long backendId = pushTask.getBackendId();
        long signature = task.getSignature();
        long transactionId = ((PushTask)task).getTransactionId();
        Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
        if (db == null) {
            AgentTaskQueue.removeTask(backendId, TTaskType.REALTIME_PUSH, signature);
            return;
        }
        long tableId = pushTask.getTableId();
        long partitionId = pushTask.getPartitionId();
        long pushIndexId = pushTask.getIndexId();
        long pushTabletId = pushTask.getTabletId();
        Partition.PartitionState pushState = null;
        if (finishTabletInfos.size() == 1) {
            pushState = Partition.PartitionState.NORMAL;
        } else if (finishTabletInfos.size() == 2) {
            pushState = ((TTabletInfo)finishTabletInfos.get(0)).getTabletId() == ((TTabletInfo)finishTabletInfos.get(1)).getTabletId() ? Partition.PartitionState.SCHEMA_CHANGE : Partition.PartitionState.ROLLUP;
        } else {
            LOG.warn("invalid push report infos. finishTabletInfos' size: " + finishTabletInfos.size());
            return;
        }
        LOG.debug("push report state: {}", (Object)pushState.name());
        OlapTable olapTable = (OlapTable)db.getTableNullable(tableId);
        if (olapTable == null || !olapTable.writeLockIfExist()) {
            AgentTaskQueue.removeTask(backendId, TTaskType.REALTIME_PUSH, signature);
            LOG.warn("finish push replica error, cannot find table[" + tableId + "] when push finished");
            return;
        }
        try {
            Partition partition = olapTable.getPartition(partitionId);
            if (partition == null) {
                throw new MetaNotFoundException("cannot find partition[" + partitionId + "] when push finished");
            }
            MaterializedIndex pushIndex = partition.getIndex(pushIndexId);
            if (pushIndex == null) {
                throw new MetaNotFoundException("cannot find index[" + pushIndex + "] when push finished");
            }
            long reportVersion = request.getReportVersion();
            Catalog.getCurrentSystemInfo().updateBackendReportVersion(task.getBackendId(), reportVersion, task.getDbId(), task.getTableId());
            List<Long> tabletIds = finishTabletInfos.stream().map(tTabletInfo -> tTabletInfo.getTabletId()).collect(Collectors.toList());
            List<TabletMeta> tabletMetaList = Catalog.getCurrentInvertedIndex().getTabletMetaList(tabletIds);
            if (pushTask.getPushType() == TPushType.LOAD || pushTask.getPushType() == TPushType.LOAD_DELETE) {
                long loadJobId = pushTask.getLoadJobId();
                LoadJob job = Catalog.getCurrentCatalog().getLoadInstance().getLoadJob(loadJobId);
                if (job == null) {
                    throw new MetaNotFoundException("cannot find load job, job[" + loadJobId + "]");
                }
                for (int i = 0; i < tabletMetaList.size(); ++i) {
                    TabletMeta tabletMeta = tabletMetaList.get(i);
                    this.checkReplica((TTabletInfo)finishTabletInfos.get(i), tabletMeta);
                    long tabletId = tabletIds.get(i);
                    Replica replica = this.findRelatedReplica(olapTable, partition, backendId, tabletId, tabletMeta.getIndexId());
                    if (replica == null) continue;
                    job.addFinishedReplica(replica);
                }
            } else if (pushTask.getPushType() == TPushType.DELETE) {
                DeleteJob deleteJob = Catalog.getCurrentCatalog().getDeleteHandler().getDeleteJob(transactionId);
                if (deleteJob == null) {
                    throw new MetaNotFoundException("cannot find delete job, job[" + transactionId + "]");
                }
                for (int i = 0; i < tabletMetaList.size(); ++i) {
                    TabletMeta tabletMeta = tabletMetaList.get(i);
                    long tabletId = tabletIds.get(i);
                    Replica replica = this.findRelatedReplica(olapTable, partition, backendId, tabletId, tabletMeta.getIndexId());
                    if (replica == null) continue;
                    deleteJob.addFinishedReplica(partitionId, pushTabletId, replica);
                    pushTask.countDownLatch(backendId, pushTabletId);
                }
            } else if (pushTask.getPushType() == TPushType.LOAD_V2) {
                long loadJobId = pushTask.getLoadJobId();
                org.apache.doris.load.loadv2.LoadJob job = Catalog.getCurrentCatalog().getLoadManager().getLoadJob(loadJobId);
                if (job == null) {
                    throw new MetaNotFoundException("cannot find load job, job[" + loadJobId + "]");
                }
                for (int i = 0; i < tabletMetaList.size(); ++i) {
                    TabletMeta tabletMeta = tabletMetaList.get(i);
                    this.checkReplica((TTabletInfo)finishTabletInfos.get(i), tabletMeta);
                    long tabletId = tabletIds.get(i);
                    Replica replica = this.findRelatedReplica(olapTable, partition, backendId, tabletId, tabletMeta.getIndexId());
                    if (replica == null) continue;
                    ((SparkLoadJob)job).addFinishedReplica(replica.getId(), pushTabletId, backendId);
                }
            }
            AgentTaskQueue.removeTask(backendId, TTaskType.REALTIME_PUSH, signature);
            LOG.debug("finish push replica. tabletId: {}, backendId: {}", (Object)pushTabletId, (Object)backendId);
        }
        catch (MetaNotFoundException e) {
            AgentTaskQueue.removeTask(backendId, TTaskType.REALTIME_PUSH, signature);
            LOG.warn("finish push replica error", (Throwable)e);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    private void checkReplica(TTabletInfo tTabletInfo, TabletMeta tabletMeta) throws MetaNotFoundException {
        long tabletId = tTabletInfo.getTabletId();
        int schemaHash = tTabletInfo.getSchemaHash();
        if (tabletMeta == null || tabletMeta == TabletInvertedIndex.NOT_EXIST_TABLET_META) {
            throw new MetaNotFoundException("tablet " + tabletId + " does not exist");
        }
        if (!tabletMeta.containsSchemaHash(schemaHash)) {
            throw new MetaNotFoundException("tablet[" + tabletId + "] schemaHash is not equal to index's switchSchemaHash. " + tabletMeta.toString() + " vs. " + schemaHash);
        }
    }

    private Replica findRelatedReplica(OlapTable olapTable, Partition partition, long backendId, long tabletId, long indexId) throws MetaNotFoundException {
        if (indexId == -1L) {
            LOG.warn("tablet[{}] may be dropped. push index[{}]", (Object)tabletId, (Object)indexId);
            return null;
        }
        MaterializedIndex index = partition.getIndex(indexId);
        if (index == null) {
            if (olapTable.getState() == OlapTable.OlapTableState.ROLLUP) {
                LOG.warn("Cannot find table[{}].", (Object)olapTable.getId());
                return null;
            }
            throw new MetaNotFoundException("Could not find related replica");
        }
        Tablet tablet = index.getTablet(tabletId);
        if (tablet == null) {
            LOG.warn("could not find tablet {} in rollup index {} ", (Object)tabletId, (Object)indexId);
            return null;
        }
        Replica replica = tablet.getReplicaByBackendId(backendId);
        if (replica == null) {
            LOG.warn("could not find replica with backend {} in tablet {} in rollup index {} ", (Object)backendId, (Object)tabletId, (Object)indexId);
        }
        return replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPush(AgentTask task, TFinishTaskRequest request) {
        List finishTabletInfos = request.getFinishTabletInfos();
        Preconditions.checkState((finishTabletInfos != null && !finishTabletInfos.isEmpty() ? 1 : 0) != 0);
        PushTask pushTask = (PushTask)task;
        long finishVersion = ((TTabletInfo)finishTabletInfos.get(0)).getVersion();
        long taskVersion = pushTask.getVersion();
        if (finishVersion != taskVersion) {
            LOG.debug("finish tablet version is not consistent with task. finish version: {}, task: {}", (Object)finishVersion, (Object)pushTask);
            return;
        }
        long dbId = pushTask.getDbId();
        long backendId = pushTask.getBackendId();
        long signature = task.getSignature();
        Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
        if (db == null) {
            AgentTaskQueue.removePushTask(backendId, signature, finishVersion, pushTask.getPushType(), pushTask.getTaskType());
            return;
        }
        long tableId = pushTask.getTableId();
        long partitionId = pushTask.getPartitionId();
        long pushIndexId = pushTask.getIndexId();
        long pushTabletId = pushTask.getTabletId();
        Partition.PartitionState pushState = null;
        if (finishTabletInfos.size() == 1) {
            pushState = Partition.PartitionState.NORMAL;
        } else if (finishTabletInfos.size() == 2) {
            pushState = ((TTabletInfo)finishTabletInfos.get(0)).getTabletId() == ((TTabletInfo)finishTabletInfos.get(1)).getTabletId() ? Partition.PartitionState.SCHEMA_CHANGE : Partition.PartitionState.ROLLUP;
        } else {
            LOG.warn("invalid push report infos. finishTabletInfos' size: " + finishTabletInfos.size());
            return;
        }
        LOG.debug("push report state: {}", (Object)pushState.name());
        OlapTable olapTable = (OlapTable)db.getTableNullable(tableId);
        if (olapTable == null || !olapTable.writeLockIfExist()) {
            AgentTaskQueue.removeTask(backendId, TTaskType.REALTIME_PUSH, signature);
            LOG.warn("finish push replica error, cannot find table[" + tableId + "] when push finished");
            return;
        }
        try {
            Partition partition = olapTable.getPartition(partitionId);
            if (partition == null) {
                throw new MetaNotFoundException("cannot find partition[" + partitionId + "] when push finished");
            }
            LinkedList<ReplicaPersistInfo> infos = new LinkedList<ReplicaPersistInfo>();
            List<Long> tabletIds = finishTabletInfos.stream().map(finishTabletInfo -> finishTabletInfo.getTabletId()).collect(Collectors.toList());
            List<TabletMeta> tabletMetaList = Catalog.getCurrentInvertedIndex().getTabletMetaList(tabletIds);
            for (int i = 0; i < tabletMetaList.size(); ++i) {
                TabletMeta tabletMeta = tabletMetaList.get(i);
                TTabletInfo tTabletInfo = (TTabletInfo)finishTabletInfos.get(i);
                long indexId = tabletMeta.getIndexId();
                ReplicaPersistInfo info = this.updateReplicaInfo(olapTable, partition, backendId, pushIndexId, indexId, tTabletInfo, pushState);
                if (info == null) continue;
                infos.add(info);
            }
            long reportVersion = request.getReportVersion();
            Catalog.getCurrentSystemInfo().updateBackendReportVersion(task.getBackendId(), reportVersion, task.getDbId(), task.getTableId());
            if (pushTask.getPushType() == TPushType.LOAD || pushTask.getPushType() == TPushType.LOAD_DELETE) {
                long loadJobId = pushTask.getLoadJobId();
                LoadJob job = Catalog.getCurrentCatalog().getLoadInstance().getLoadJob(loadJobId);
                if (job == null) {
                    throw new MetaNotFoundException("cannot find load job, job[" + loadJobId + "]");
                }
                Preconditions.checkState((!infos.isEmpty() ? 1 : 0) != 0);
                for (ReplicaPersistInfo info : infos) {
                    job.addReplicaPersistInfos(info);
                }
            } else if (pushTask.getPushType() == TPushType.DELETE && pushTask.getVersion() != request.getRequestVersion()) {
                throw new MetaNotFoundException("delete task is not match. [" + pushTask.getVersion() + "-" + request.getRequestVersion() + "]");
            }
            AgentTaskQueue.removePushTask(backendId, signature, finishVersion, pushTask.getPushType(), pushTask.getTaskType());
            LOG.debug("finish push replica. tabletId: {}, backendId: {}", (Object)pushTabletId, (Object)backendId);
        }
        catch (MetaNotFoundException e) {
            AgentTaskQueue.removePushTask(backendId, signature, finishVersion, pushTask.getPushType(), pushTask.getTaskType());
            LOG.warn("finish push replica error", (Throwable)e);
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    private void finishClearAlterTask(AgentTask task, TFinishTaskRequest request) {
        ClearAlterTask clearAlterTask = (ClearAlterTask)task;
        clearAlterTask.setFinished(true);
        AgentTaskQueue.removeTask(task.getBackendId(), task.getTaskType(), task.getSignature());
    }

    private void finishPublishVersion(AgentTask task, TFinishTaskRequest request) {
        List errorTabletIds = null;
        if (request.isSetErrorTabletIds()) {
            errorTabletIds = request.getErrorTabletIds();
        }
        if (request.isSetReportVersion()) {
            long reportVersion = request.getReportVersion();
            Catalog.getCurrentSystemInfo().updateBackendReportVersion(task.getBackendId(), reportVersion, task.getDbId(), task.getTableId());
        }
        PublishVersionTask publishVersionTask = (PublishVersionTask)task;
        publishVersionTask.addErrorTablets(errorTabletIds);
        publishVersionTask.setIsFinished(true);
        if (request.getTaskStatus().getStatusCode() != TStatusCode.OK) {
            return;
        }
        AgentTaskQueue.removeTask(publishVersionTask.getBackendId(), publishVersionTask.getTaskType(), publishVersionTask.getSignature());
    }

    private ReplicaPersistInfo updateReplicaInfo(OlapTable olapTable, Partition partition, long backendId, long pushIndexId, long indexId, TTabletInfo tTabletInfo, Partition.PartitionState pushState) throws MetaNotFoundException {
        long tabletId = tTabletInfo.getTabletId();
        int schemaHash = tTabletInfo.getSchemaHash();
        long version = tTabletInfo.getVersion();
        long rowCount = tTabletInfo.getRowCount();
        long dataSize = tTabletInfo.getDataSize();
        if (indexId != pushIndexId) {
            if (pushState != Partition.PartitionState.ROLLUP && indexId != -1L) {
                LOG.warn("push task report tablet[{}] with different index[{}] and is not in ROLLUP. push index[{}]", (Object)tabletId, (Object)indexId, (Object)pushIndexId);
                return null;
            }
            if (indexId == -1L) {
                LOG.warn("tablet[{}] may be dropped. push index[{}]", (Object)tabletId, (Object)pushIndexId);
                return null;
            }
            return null;
        }
        int currentSchemaHash = olapTable.getSchemaHashByIndexId(pushIndexId);
        if (schemaHash != currentSchemaHash && pushState != Partition.PartitionState.SCHEMA_CHANGE) {
            throw new MetaNotFoundException("Diff tablet[" + tabletId + "] schemaHash. index[" + pushIndexId + "]: " + currentSchemaHash + " vs. " + schemaHash);
        }
        MaterializedIndex materializedIndex = partition.getIndex(pushIndexId);
        if (materializedIndex == null) {
            throw new MetaNotFoundException("Cannot find index[" + pushIndexId + "]");
        }
        Tablet tablet = materializedIndex.getTablet(tabletId);
        if (tablet == null) {
            throw new MetaNotFoundException("Cannot find tablet[" + tabletId + "]");
        }
        Replica replica = tablet.getReplicaByBackendId(backendId);
        if (replica == null) {
            throw new MetaNotFoundException("cannot find replica in tablet[" + tabletId + "], backend[" + backendId + "]");
        }
        replica.updateVersionInfo(version, dataSize, rowCount);
        LOG.debug("replica[{}] report schemaHash:{}", (Object)replica.getId(), (Object)schemaHash);
        return ReplicaPersistInfo.createForLoad(olapTable.getId(), partition.getId(), pushIndexId, tabletId, replica.getId(), version, schemaHash, dataSize, rowCount);
    }

    private void finishDropReplica(AgentTask task) {
        AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.DROP, task.getSignature());
    }

    private void finishClone(AgentTask task, TFinishTaskRequest request) {
        CloneTask cloneTask = (CloneTask)task;
        if (cloneTask.getTaskVersion() == 2) {
            Catalog.getCurrentCatalog().getTabletScheduler().finishCloneTask(cloneTask, request);
        } else {
            LOG.warn("invalid clone task, ignore it. {}", (Object)task);
        }
        AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.CLONE, task.getSignature());
    }

    private void finishConsistencyCheck(AgentTask task, TFinishTaskRequest request) {
        CheckConsistencyTask checkConsistencyTask = (CheckConsistencyTask)task;
        if (checkConsistencyTask.getVersion() != request.getRequestVersion()) {
            LOG.warn("check consistency task is not match. [{}-{}]", (Object)checkConsistencyTask.getVersion(), (Object)request.getRequestVersion());
            return;
        }
        Catalog.getCurrentCatalog().getConsistencyChecker().handleFinishedConsistencyCheck(checkConsistencyTask, request.getTabletChecksum());
        AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.CHECK_CONSISTENCY, task.getSignature());
    }

    private void finishMakeSnapshot(AgentTask task, TFinishTaskRequest request) {
        SnapshotTask snapshotTask = (SnapshotTask)task;
        if (Catalog.getCurrentCatalog().getBackupHandler().handleFinishedSnapshotTask(snapshotTask, request)) {
            AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.MAKE_SNAPSHOT, task.getSignature());
        }
    }

    private void finishUpload(AgentTask task, TFinishTaskRequest request) {
        UploadTask uploadTask = (UploadTask)task;
        if (Catalog.getCurrentCatalog().getBackupHandler().handleFinishedSnapshotUploadTask(uploadTask, request)) {
            AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.UPLOAD, task.getSignature());
        }
    }

    private void finishDownloadTask(AgentTask task, TFinishTaskRequest request) {
        DownloadTask downloadTask = (DownloadTask)task;
        if (Catalog.getCurrentCatalog().getBackupHandler().handleDownloadSnapshotTask(downloadTask, request)) {
            AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.DOWNLOAD, task.getSignature());
        }
    }

    private void finishMoveDirTask(AgentTask task, TFinishTaskRequest request) {
        DirMoveTask dirMoveTask = (DirMoveTask)task;
        if (Catalog.getCurrentCatalog().getBackupHandler().handleDirMoveTask(dirMoveTask, request)) {
            AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.MOVE, task.getSignature());
        }
    }

    private void finishRecoverTablet(AgentTask task) {
        AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.RECOVER_TABLET, task.getSignature());
    }

    public TMasterResult report(TReportRequest request) throws TException {
        return this.reportHandler.handleReport(request);
    }

    public TFetchResourceResult fetchResource() {
        return Catalog.getCurrentCatalog().getAuth().toResourceThrift();
    }

    private void finishAlterTask(AgentTask task) {
        AlterReplicaTask alterTask = (AlterReplicaTask)task;
        try {
            if (alterTask.getJobType() == AlterJobV2.JobType.ROLLUP) {
                Catalog.getCurrentCatalog().getMaterializedViewHandler().handleFinishAlterTask(alterTask);
            } else if (alterTask.getJobType() == AlterJobV2.JobType.SCHEMA_CHANGE) {
                Catalog.getCurrentCatalog().getSchemaChangeHandler().handleFinishAlterTask(alterTask);
            }
            alterTask.setFinished(true);
        }
        catch (MetaNotFoundException e) {
            LOG.warn("failed to handle finish alter task: {}, {}", (Object)task.getSignature(), (Object)e.getMessage());
        }
        AgentTaskQueue.removeTask(task.getBackendId(), TTaskType.ALTER, task.getSignature());
    }
}

