/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.master;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.CheckpointException;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.master.MetaHelper;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.monitor.jvm.JvmService;
import org.apache.doris.monitor.jvm.JvmStats;
import org.apache.doris.persist.EditLog;
import org.apache.doris.persist.MetaCleaner;
import org.apache.doris.persist.Storage;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.system.Frontend;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Checkpoint
extends MasterDaemon {
    public static final Logger LOG = LogManager.getLogger(Checkpoint.class);
    private static final int PUT_TIMEOUT_SECOND = 3600;
    private static final int CONNECT_TIMEOUT_SECOND = 1;
    private static final int READ_TIMEOUT_SECOND = 1;
    private Catalog catalog;
    private String imageDir = Catalog.getServingCatalog().getImageDir();
    private EditLog editLog;

    public Checkpoint(EditLog editLog) {
        super("leaderCheckpointer", (long)FeConstants.checkpoint_interval_second * 1000L);
        this.editLog = editLog;
    }

    @Override
    protected void runAfterCatalogReady() {
        try {
            this.doCheckpoint();
        }
        catch (CheckpointException e) {
            LOG.warn("failed to do checkpoint.", (Throwable)e);
        }
    }

    public synchronized void doCheckpoint() throws CheckpointException {
        block45: {
            block44: {
                long imageVersion = 0L;
                long checkPointVersion = 0L;
                Storage storage = null;
                try {
                    storage = new Storage(this.imageDir);
                    imageVersion = storage.getLatestImageSeq();
                    checkPointVersion = this.editLog.getFinalizedJournalId();
                    LOG.info("last checkpoint journal id: {}, current finalized journal id: {}", (Object)imageVersion, (Object)checkPointVersion);
                    if (imageVersion >= checkPointVersion) {
                        return;
                    }
                }
                catch (Throwable e) {
                    LOG.error("Does not get storage info", e);
                    if (MetricRepo.isInit) {
                        MetricRepo.COUNTER_IMAGE_WRITE_FAILED.increase(1L);
                    }
                    return;
                }
                if (!this.checkMemoryEnoughToDoCheckpoint()) {
                    if (MetricRepo.isInit) {
                        MetricRepo.COUNTER_IMAGE_WRITE_FAILED.increase(1L);
                    }
                    return;
                }
                long replayedJournalId = -1L;
                LOG.info("begin to generate new image: image.{}", (Object)checkPointVersion);
                this.catalog = Catalog.getCurrentCatalog();
                this.catalog.setEditLog(this.editLog);
                this.createStaticFieldForCkpt();
                boolean exceptionCaught = false;
                String latestImageFilePath = null;
                try {
                    this.catalog.loadImage(this.imageDir);
                    this.catalog.replayJournal(checkPointVersion);
                    if (this.catalog.getReplayedJournalId() != checkPointVersion) {
                        throw new CheckpointException(String.format("checkpoint version should be %d, actual replayed journal id is %d", checkPointVersion, this.catalog.getReplayedJournalId()));
                    }
                    this.catalog.fixBugAfterMetadataReplayed(false);
                    latestImageFilePath = this.catalog.saveImage();
                    replayedJournalId = this.catalog.getReplayedJournalId();
                    this.catalog = null;
                    Catalog.destroyCheckpoint();
                    this.destroyStaticFieldForCkpt();
                    this.catalog = Catalog.getCurrentCatalog();
                    this.createStaticFieldForCkpt();
                    this.catalog.loadImage(this.imageDir);
                    if (MetricRepo.isInit) {
                        MetricRepo.COUNTER_IMAGE_WRITE_SUCCESS.increase(1L);
                    }
                    LOG.info("checkpoint finished save image.{}", (Object)replayedJournalId);
                }
                catch (Throwable e) {
                    exceptionCaught = true;
                    LOG.error("Exception when generate new image file", e);
                    if (MetricRepo.isInit) {
                        MetricRepo.COUNTER_IMAGE_WRITE_FAILED.increase(1L);
                    }
                    throw new CheckpointException(e.getMessage(), e);
                }
                finally {
                    block43: {
                        this.catalog = null;
                        Catalog.destroyCheckpoint();
                        this.destroyStaticFieldForCkpt();
                        if (!Strings.isNullOrEmpty((String)latestImageFilePath) && exceptionCaught) {
                            MetaCleaner cleaner = new MetaCleaner(Config.meta_dir + "/image");
                            try {
                                cleaner.cleanTheLatestInvalidImageFile(latestImageFilePath);
                                if (MetricRepo.isInit) {
                                    MetricRepo.COUNTER_IMAGE_CLEAN_SUCCESS.increase(1L);
                                }
                            }
                            catch (Throwable ex) {
                                LOG.error("Master delete latest invalid image file failed.", ex);
                                if (!MetricRepo.isInit) break block43;
                                MetricRepo.COUNTER_IMAGE_CLEAN_FAILED.increase(1L);
                            }
                        }
                    }
                }
                List<Frontend> allFrontends = Catalog.getServingCatalog().getFrontends(null);
                int successPushed = 0;
                int otherNodesCount = 0;
                if (!allFrontends.isEmpty()) {
                    otherNodesCount = allFrontends.size() - 1;
                    for (Frontend fe : allFrontends) {
                        String host = fe.getHost();
                        if (host.equals(Catalog.getServingCatalog().getMasterIp())) continue;
                        int port = Config.http_port;
                        String url = "http://" + host + ":" + port + "/put?version=" + replayedJournalId + "&port=" + port;
                        LOG.info("Put image:{}", (Object)url);
                        try {
                            MetaHelper.getRemoteFile(url, 3600000, new NullOutputStream());
                            ++successPushed;
                        }
                        catch (IOException e) {
                            LOG.error("Exception when pushing image file. url = {}", (Object)url, (Object)e);
                        }
                    }
                    LOG.info("push image.{} to other nodes. totally {} nodes, push succeed {} nodes", (Object)replayedJournalId, (Object)otherNodesCount, (Object)successPushed);
                }
                if (successPushed == otherNodesCount) {
                    if (MetricRepo.isInit) {
                        MetricRepo.COUNTER_IMAGE_PUSH_SUCCESS.increase(1L);
                    }
                } else if (MetricRepo.isInit) {
                    MetricRepo.COUNTER_IMAGE_PUSH_FAILED.increase(1L);
                }
                if (successPushed == otherNodesCount) {
                    try {
                        long minOtherNodesJournalId = Long.MAX_VALUE;
                        long deleteVersion = storage.getLatestValidatedImageSeq();
                        if (successPushed > 0) {
                            for (Frontend fe : allFrontends) {
                                String host = fe.getHost();
                                if (host.equals(Catalog.getServingCatalog().getMasterIp())) continue;
                                int port = Config.http_port;
                                HttpURLConnection conn = null;
                                try {
                                    URL idURL = new URL("http://" + host + ":" + port + "/journal_id");
                                    conn = (HttpURLConnection)idURL.openConnection();
                                    conn.setConnectTimeout(1000);
                                    conn.setReadTimeout(1000);
                                    String idString = conn.getHeaderField("id");
                                    long id = Long.parseLong(idString);
                                    if (minOtherNodesJournalId <= id) continue;
                                    minOtherNodesJournalId = id;
                                }
                                catch (Throwable e) {
                                    throw new CheckpointException(String.format("Exception when getting current replayed journal id. host=%s, port=%d", host, port), e);
                                }
                                finally {
                                    if (conn == null) continue;
                                    conn.disconnect();
                                }
                            }
                            deleteVersion = Math.min(minOtherNodesJournalId, deleteVersion);
                        }
                        this.editLog.deleteJournals(deleteVersion + 1L);
                        if (MetricRepo.isInit) {
                            MetricRepo.COUNTER_EDIT_LOG_CLEAN_SUCCESS.increase(1L);
                        }
                        LOG.info("journals <= {} are deleted. image version {}, other nodes min version {}", (Object)deleteVersion, (Object)checkPointVersion, (Object)minOtherNodesJournalId);
                    }
                    catch (Throwable e) {
                        LOG.error("failed to delete old edit log", e);
                        if (!MetricRepo.isInit) break block44;
                        MetricRepo.COUNTER_EDIT_LOG_CLEAN_FAILED.increase(1L);
                    }
                }
            }
            MetaCleaner cleaner = new MetaCleaner(Config.meta_dir + "/image");
            try {
                cleaner.clean();
                if (MetricRepo.isInit) {
                    MetricRepo.COUNTER_IMAGE_CLEAN_SUCCESS.increase(1L);
                }
            }
            catch (Throwable e) {
                LOG.error("Master delete old image file fail.", e);
                if (!MetricRepo.isInit) break block45;
                MetricRepo.COUNTER_IMAGE_CLEAN_FAILED.increase(1L);
            }
        }
    }

    private void createStaticFieldForCkpt() {
        VariableMgr.createDefaultSessionVariableForCkpt();
    }

    private void destroyStaticFieldForCkpt() {
        VariableMgr.destroyDefaultSessionVariableForCkpt();
    }

    private boolean checkMemoryEnoughToDoCheckpoint() {
        long memUsedPercent = this.getMemoryUsedPercent();
        LOG.info("get jvm memory used percent: {} %", (Object)memUsedPercent);
        if (memUsedPercent > Config.metadata_checkpoint_memory_threshold && !Config.force_do_metadata_checkpoint) {
            LOG.warn("the memory used percent {} exceed the checkpoint memory threshold: {}", (Object)memUsedPercent, (Object)Config.metadata_checkpoint_memory_threshold);
            return false;
        }
        return true;
    }

    private long getMemoryUsedPercent() {
        JvmService jvmService = new JvmService();
        JvmStats jvmStats = jvmService.stats();
        Iterator<JvmStats.MemoryPool> memIter = jvmStats.getMem().iterator();
        JvmStats.MemoryPool oldMemPool = null;
        while (memIter.hasNext()) {
            JvmStats.MemoryPool memPool = memIter.next();
            if (!memPool.getName().equalsIgnoreCase("old")) continue;
            oldMemPool = memPool;
            break;
        }
        if (oldMemPool != null) {
            long used = oldMemPool.getUsed().getBytes();
            long max = oldMemPool.getMax().getBytes();
            return used * 100L / max;
        }
        LOG.warn("failed to get jvm old mem pool, use heap usage instead");
        long used = jvmStats.getMem().getHeapUsed().getBytes();
        long max = jvmStats.getMem().getHeapMax().getBytes();
        return used * 100L / max;
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

