/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.update;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.UpdateStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.QuotaExceedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.load.update.UpdatePlanner;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.qe.Coordinator;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TQueryType;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.GlobalTransactionMgr;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateStmtExecutor {
    private static final Logger LOG = LogManager.getLogger(UpdateStmtExecutor.class);
    private OlapTable targetTable;
    private Expr whereExpr;
    private List<Expr> setExprs;
    private long dbId;
    private TUniqueId queryId;
    private int timeoutSecond;
    private Analyzer analyzer;
    private UpdatePlanner updatePlanner;
    private String label;
    private long txnId;
    private Coordinator coordinator;
    private long effectRows;

    public long getTargetTableId() {
        return this.targetTable.getId();
    }

    public void execute() throws UserException {
        if (this.analyzer.hasEmptyResultSet()) {
            QeProcessorImpl.INSTANCE.unregisterQuery(this.queryId);
            this.analyzer.getContext().getState().setOk();
            return;
        }
        this.beginTxn();
        this.targetTable.readLock();
        try {
            this.updatePlanner.plan(this.txnId);
        }
        catch (Throwable e) {
            LOG.warn("failed to plan update stmt, query id:{}", (Object)DebugUtil.printId(this.queryId), (Object)e);
            Catalog.getCurrentGlobalTransactionMgr().abortTransaction(this.dbId, this.txnId, e.getMessage());
            QeProcessorImpl.INSTANCE.unregisterQuery(this.queryId);
            throw new DdlException("failed to plan update stmt, query id: " + DebugUtil.printId(this.queryId) + ", err: " + e.getMessage());
        }
        finally {
            this.targetTable.readUnlock();
        }
        try {
            this.executePlan();
        }
        catch (DdlException e) {
            LOG.warn("failed to execute update stmt, query id:{}", (Object)DebugUtil.printId(this.queryId), (Object)e);
            Catalog.getCurrentGlobalTransactionMgr().abortTransaction(this.dbId, this.txnId, e.getMessage());
            throw e;
        }
        catch (Throwable e) {
            LOG.warn("failed to execute update stmt, query id:{}", (Object)DebugUtil.printId(this.queryId), (Object)e);
            Catalog.getCurrentGlobalTransactionMgr().abortTransaction(this.dbId, this.txnId, e.getMessage());
            throw new DdlException("failed to execute update stmt, query id: " + DebugUtil.printId(this.queryId) + ", err: " + e.getMessage());
        }
        finally {
            QeProcessorImpl.INSTANCE.unregisterQuery(this.queryId);
        }
        this.commitAndPublishTxn();
    }

    private void beginTxn() throws LabelAlreadyUsedException, AnalysisException, BeginTransactionException, DuplicatedRequestException, QuotaExceedException, MetaNotFoundException {
        LOG.info("begin transaction for update stmt, query id:{}", (Object)DebugUtil.printId(this.queryId));
        MetricRepo.COUNTER_LOAD_ADD.increase(1L);
        this.label = "update_" + DebugUtil.printId(this.queryId);
        this.txnId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(this.dbId, Lists.newArrayList((Object[])new Long[]{this.targetTable.getId()}), this.label, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), TransactionState.LoadJobSourceType.INSERT_STREAMING, this.timeoutSecond);
    }

    private void executePlan() throws Exception {
        LOG.info("begin execute update stmt, query id:{}", (Object)DebugUtil.printId(this.queryId));
        this.coordinator = new Coordinator(Catalog.getCurrentCatalog().getNextId(), this.queryId, this.analyzer.getDescTbl(), this.updatePlanner.getFragments(), this.updatePlanner.getScanNodes(), "Asia/Shanghai", false);
        this.coordinator.setQueryType(TQueryType.LOAD);
        this.coordinator.setExecVecEngine(VectorizedUtil.isVectorized());
        QeProcessorImpl.INSTANCE.registerQuery(this.queryId, this.coordinator);
        this.analyzer.getContext().getExecutor().setCoord(this.coordinator);
        this.coordinator.setTimeout(this.timeoutSecond);
        this.coordinator.exec();
        if (this.coordinator.join(this.timeoutSecond)) {
            if (!this.coordinator.isDone()) {
                this.coordinator.cancel();
                ErrorReport.reportDdlException(ErrorCode.ERR_EXECUTE_TIMEOUT, new Object[0]);
            }
            if (!this.coordinator.getExecStatus().ok()) {
                String errMsg = "update failed: " + this.coordinator.getExecStatus().getErrorMsg();
                LOG.warn(errMsg);
                throw new DdlException(errMsg);
            }
        } else {
            String errMsg = "coordinator could not finished before update timeout: " + this.coordinator.getExecStatus().getErrorMsg();
            LOG.warn(errMsg);
            throw new DdlException(errMsg);
        }
        LOG.info("finish to execute update stmt, query id:{}", (Object)DebugUtil.printId(this.queryId));
        if (this.coordinator.getLoadCounters().get("dpp.norm.ALL") != null) {
            this.effectRows = Long.valueOf(this.coordinator.getLoadCounters().get("dpp.norm.ALL"));
            if (Long.valueOf(this.coordinator.getLoadCounters().get("dpp.abnorm.ALL")) != 0L) {
                throw new DdlException("update failed, some rows did not take effect");
            }
        }
    }

    private void commitAndPublishTxn() throws UserException {
        TransactionStatus txnStatus;
        boolean isPublished;
        GlobalTransactionMgr globalTransactionMgr = Catalog.getCurrentGlobalTransactionMgr();
        try {
            LOG.info("commit and publish transaction for update stmt, query id: {}", (Object)DebugUtil.printId(this.queryId));
            isPublished = globalTransactionMgr.commitAndPublishTransaction(Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId), Lists.newArrayList((Object[])new Table[]{this.targetTable}), this.txnId, TabletCommitInfo.fromThrift(this.coordinator.getCommitInfos()), this.analyzer.getContext().getSessionVariable().getInsertVisibleTimeoutMs());
        }
        catch (Throwable e) {
            String errMsg = "failed to commit and publish transaction for update stmt, query id:" + DebugUtil.printId(this.queryId);
            LOG.warn(errMsg, e);
            globalTransactionMgr.abortTransaction(this.dbId, this.txnId, e.getMessage());
            throw new DdlException(errMsg, e);
        }
        String errMsg = null;
        if (isPublished) {
            txnStatus = TransactionStatus.VISIBLE;
            MetricRepo.COUNTER_LOAD_FINISHED.increase(1L);
        } else {
            txnStatus = TransactionStatus.COMMITTED;
            errMsg = "transaction will be published later, data will be visible later";
            LOG.warn("transaction will be published later, query id: {}", (Object)DebugUtil.printId(this.queryId));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{'label':'").append(this.label).append("', 'status':'").append(txnStatus.name()).append("'");
        sb.append(", 'txnId':'").append(this.txnId).append("'");
        sb.append(", 'queryId':'").append(DebugUtil.printId(this.queryId)).append("'");
        if (errMsg != null) {
            sb.append(", 'err':'").append(errMsg).append("'");
        }
        sb.append("}");
        this.analyzer.getContext().getState().setOk(this.effectRows, 0, sb.toString());
    }

    public static UpdateStmtExecutor fromUpdateStmt(UpdateStmt updateStmt) throws AnalysisException {
        UpdateStmtExecutor updateStmtExecutor = new UpdateStmtExecutor();
        updateStmtExecutor.targetTable = (OlapTable)updateStmt.getTargetTable();
        updateStmtExecutor.whereExpr = updateStmt.getWhereExpr();
        updateStmtExecutor.setExprs = updateStmt.getSetExprs();
        Database database = Catalog.getCurrentCatalog().getDbOrAnalysisException(updateStmt.getTableName().getDb());
        updateStmtExecutor.dbId = database.getId();
        updateStmtExecutor.analyzer = updateStmt.getAnalyzer();
        updateStmtExecutor.queryId = updateStmtExecutor.analyzer.getContext().queryId();
        updateStmtExecutor.timeoutSecond = updateStmtExecutor.analyzer.getContext().getSessionVariable().getQueryTimeoutS();
        updateStmtExecutor.updatePlanner = new UpdatePlanner(updateStmtExecutor.dbId, updateStmtExecutor.targetTable, updateStmt.getSetExprs(), updateStmt.getSrcTupleDesc(), updateStmt.getAnalyzer());
        return updateStmtExecutor;
    }
}

