/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.update;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.DescriptorTable;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.IdGenerator;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.OlapScanNode;
import org.apache.doris.planner.OlapTableSink;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanFragmentId;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.Planner;
import org.apache.doris.planner.ScanNode;

public class UpdatePlanner
extends Planner {
    private final IdGenerator<PlanNodeId> nodeIdGenerator_ = PlanNodeId.createGenerator();
    private final IdGenerator<PlanFragmentId> fragmentIdGenerator_ = PlanFragmentId.createGenerator();
    private long targetDBId;
    private OlapTable targetTable;
    private List<Expr> setExprs;
    private TupleDescriptor srcTupleDesc;
    private Analyzer analyzer;
    private List<ScanNode> scanNodeList = Lists.newArrayList();

    public UpdatePlanner(long dbId, OlapTable targetTable, List<Expr> setExprs, TupleDescriptor srcTupleDesc, Analyzer analyzer) {
        this.targetDBId = dbId;
        this.targetTable = targetTable;
        this.setExprs = setExprs;
        this.srcTupleDesc = srcTupleDesc;
        this.analyzer = analyzer;
    }

    @Override
    public List<ScanNode> getScanNodes() {
        return this.scanNodeList;
    }

    public void plan(long txnId) throws UserException {
        OlapScanNode olapScanNode = new OlapScanNode(this.nodeIdGenerator_.getNextId(), this.srcTupleDesc, "OlapScanNode");
        olapScanNode.closePreAggregation("This an update operation");
        olapScanNode.useBaseIndexId();
        olapScanNode.init(this.analyzer);
        olapScanNode.finalize(this.analyzer);
        if (VectorizedUtil.isVectorized()) {
            olapScanNode.convertToVectoriezd();
        }
        this.scanNodeList.add(olapScanNode);
        OlapTableSink olapTableSink = new OlapTableSink(this.targetTable, this.computeTargetTupleDesc(), null);
        olapTableSink.init(this.analyzer.getContext().queryId(), txnId, this.targetDBId, this.analyzer.getContext().getSessionVariable().queryTimeoutS, this.analyzer.getContext().getSessionVariable().sendBatchParallelism, false);
        olapTableSink.complete();
        PlanFragment planFragment = new PlanFragment(this.fragmentIdGenerator_.getNextId(), olapScanNode, DataPartition.RANDOM);
        planFragment.setSink(olapTableSink);
        planFragment.setOutputExprs(this.computeOutputExprs());
        planFragment.finalize(null);
        this.fragments.add(planFragment);
    }

    private TupleDescriptor computeTargetTupleDesc() {
        DescriptorTable descTable = this.analyzer.getDescTbl();
        TupleDescriptor targetTupleDesc = descTable.createTupleDescriptor();
        for (Column col : this.targetTable.getFullSchema()) {
            SlotDescriptor slotDesc = descTable.addSlotDescriptor(targetTupleDesc);
            slotDesc.setIsMaterialized(true);
            slotDesc.setType(col.getType());
            slotDesc.setColumn(col);
            if (col.isAllowNull()) {
                slotDesc.setIsNullable(true);
                continue;
            }
            slotDesc.setIsNullable(false);
        }
        targetTupleDesc.computeStatAndMemLayout();
        return targetTupleDesc;
    }

    private List<Expr> computeOutputExprs() throws AnalysisException {
        HashMap columnNameToSetExpr = Maps.newHashMap();
        for (Expr expr : this.setExprs) {
            Preconditions.checkState((boolean)(expr instanceof BinaryPredicate));
            Preconditions.checkState((boolean)(expr.getChild(0) instanceof SlotRef));
            SlotRef slotRef = (SlotRef)expr.getChild(0);
            columnNameToSetExpr.put(slotRef.getColumnName().toLowerCase(), (Expr)expr.getChild(1));
        }
        HashMap columnNameToSrcSlotDesc = Maps.newHashMap();
        for (SlotDescriptor srcSlotDesc : this.srcTupleDesc.getSlots()) {
            columnNameToSrcSlotDesc.put(srcSlotDesc.getColumn().getName().toLowerCase(), srcSlotDesc);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 0; i < this.targetTable.getFullSchema().size(); ++i) {
            Expr defaultExpr;
            Column column = this.targetTable.getFullSchema().get(i);
            String originColumnName = (column.getName().startsWith("__doris_shadow_") ? column.getName().substring("__doris_shadow_".length()) : column.getName()).toLowerCase();
            Expr setExpr = (Expr)columnNameToSetExpr.get(originColumnName);
            SlotDescriptor srcSlotDesc = (SlotDescriptor)columnNameToSrcSlotDesc.get(originColumnName);
            if (setExpr != null) {
                arrayList.add(setExpr);
                continue;
            }
            if (srcSlotDesc != null) {
                SlotRef slotRef = new SlotRef(srcSlotDesc);
                arrayList.add(slotRef);
                continue;
            }
            if (column.getDefaultValue() != null) {
                defaultExpr = column.getDefaultValueExpr();
            } else if (column.isAllowNull()) {
                defaultExpr = NullLiteral.create(column.getType());
            } else {
                throw new AnalysisException("column has no source field, column=" + column.getName());
            }
            defaultExpr.analyze(this.analyzer);
            arrayList.add(defaultExpr);
        }
        return arrayList;
    }
}

