/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.analysis.UpdateStmt;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.doris.load.update.UpdateStmtExecutor;

public class UpdateManager {
    private final boolean enableConcurrentUpdate = Config.enable_concurrent_update;
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private Map<Long, List<UpdateStmtExecutor>> tableIdToCurrentUpdate = Maps.newConcurrentMap();

    private void writeLock() {
        this.rwLock.writeLock().lock();
    }

    private void writeUnlock() {
        this.rwLock.writeLock().unlock();
    }

    public void handleUpdate(UpdateStmt updateStmt) throws UserException {
        UpdateStmtExecutor updateStmtExecutor = this.addUpdateExecutor(updateStmt);
        try {
            updateStmtExecutor.execute();
        }
        finally {
            this.removeUpdateExecutor(updateStmtExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateStmtExecutor addUpdateExecutor(UpdateStmt updateStmt) throws AnalysisException, DdlException {
        this.writeLock();
        try {
            ArrayList currentUpdateList = this.tableIdToCurrentUpdate.get(updateStmt.getTargetTable().getId());
            if (!this.enableConcurrentUpdate && currentUpdateList != null && currentUpdateList.size() > 0) {
                throw new DdlException("There is an update operation in progress for the current table. Please try again later, or set enable_concurrent_update in fe.conf to true");
            }
            UpdateStmtExecutor updateStmtExecutor = UpdateStmtExecutor.fromUpdateStmt(updateStmt);
            if (currentUpdateList == null) {
                currentUpdateList = Lists.newArrayList();
                this.tableIdToCurrentUpdate.put(updateStmtExecutor.getTargetTableId(), currentUpdateList);
            }
            currentUpdateList.add(updateStmtExecutor);
            UpdateStmtExecutor updateStmtExecutor2 = updateStmtExecutor;
            return updateStmtExecutor2;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void removeUpdateExecutor(UpdateStmtExecutor updateStmtExecutor) {
        this.writeLock();
        try {
            List<UpdateStmtExecutor> currentUpdateList = this.tableIdToCurrentUpdate.get(updateStmtExecutor.getTargetTableId());
            if (currentUpdateList == null) {
                return;
            }
            currentUpdateList.remove(updateStmtExecutor);
        }
        finally {
            this.writeUnlock();
        }
    }
}

