/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.position;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.load.sync.position.PositionRange;

public class PositionMeta<T> {
    private long maxBatchId = -1L;
    private Map<Long, PositionRange<T>> batches = Maps.newHashMap();
    private Map<Long, T> commitPositions = Maps.newHashMap();
    private T ackPosition;
    private long ackTime;

    public void addBatch(long batchId, PositionRange<T> range) {
        this.updateMaxBatchId(batchId);
        this.batches.put(batchId, range);
    }

    public PositionRange<T> removeBatch(long batchId) {
        return this.batches.remove(batchId);
    }

    public void clearAllBatch() {
        this.batches.clear();
    }

    public void setCommitPosition(long channelId, T position) {
        this.commitPositions.put(channelId, position);
    }

    public T getCommitPosition(long channelId) {
        return this.commitPositions.get(channelId);
    }

    public void setAckPosition(T ackPosition) {
        this.ackPosition = ackPosition;
    }

    public T getAckPosition() {
        return this.ackPosition;
    }

    public void setAckTime(long ackTime) {
        this.ackTime = ackTime;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public T getLatestPosition() {
        if (!this.batches.containsKey(this.maxBatchId)) {
            return null;
        }
        return this.batches.get(this.maxBatchId).getEnd();
    }

    private void updateMaxBatchId(long batchId) {
        if (this.maxBatchId < batchId) {
            this.maxBatchId = batchId;
        }
    }

    public void cleanUp() {
        this.maxBatchId = -1L;
        this.batches.clear();
        this.commitPositions.clear();
    }
}

