/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.position;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.google.common.base.Strings;

public class EntryPosition {
    private String journalName;
    private Long position;
    private String gtid = null;
    private Long executeTime;
    public static final EntryPosition MIN_POS = new EntryPosition("", -1L, null);

    public EntryPosition() {
        this(null, null, null);
    }

    public EntryPosition(String journalName, Long position, Long timestamp) {
        this.journalName = journalName;
        this.position = position;
        this.executeTime = timestamp;
    }

    public EntryPosition(String journalName, Long position) {
        this(journalName, position, null);
    }

    public String getJournalName() {
        return this.journalName;
    }

    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }

    public Long getPosition() {
        return this.position;
    }

    public void setPosition(Long position) {
        this.position = position;
    }

    public Long getExecuteTime() {
        return this.executeTime;
    }

    public void setExecuteTime(Long timeStamp) {
        this.executeTime = timeStamp;
    }

    public String getGtid() {
        return this.gtid;
    }

    public void setGtid(String gtid) {
        this.gtid = gtid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.journalName == null ? 0 : this.journalName.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.executeTime == null ? 0 : this.executeTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntryPosition)) {
            return false;
        }
        EntryPosition other = (EntryPosition)obj;
        if (this.journalName == null ? other.journalName != null : !this.journalName.equals(other.journalName)) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        return !(this.executeTime == null ? other.executeTime != null : !this.executeTime.equals(other.executeTime));
    }

    public String toString() {
        return "[" + this.journalName + ":" + this.position + "]";
    }

    public int compareTo(EntryPosition o) {
        int val = this.journalName.compareTo(o.journalName);
        if (val == 0) {
            return (int)(this.position - o.position);
        }
        return val;
    }

    public static EntryPosition min(EntryPosition position1, EntryPosition position2) {
        if (position1.getJournalName().compareTo(position2.getJournalName()) > 0) {
            return position2;
        }
        if (position1.getJournalName().compareTo(position2.getJournalName()) < 0) {
            return position1;
        }
        if (position1.getPosition() > position2.getPosition()) {
            return position2;
        }
        return position1;
    }

    public static EntryPosition createPosition(CanalEntry.Entry entry) {
        CanalEntry.Header header = entry.getHeader();
        EntryPosition position = new EntryPosition();
        position.setJournalName(header.getLogfileName());
        position.setPosition(header.getLogfileOffset());
        position.setExecuteTime(header.getExecuteTime());
        position.setGtid(header.getGtid());
        return position;
    }

    public static boolean checkPosition(CanalEntry.Entry entry, EntryPosition entryPosition) {
        return EntryPosition.checkPosition(entry.getHeader(), entryPosition);
    }

    public static boolean checkPosition(CanalEntry.Header header, EntryPosition entryPosition) {
        boolean isEmptyPosition;
        boolean result = entryPosition.getExecuteTime().equals(header.getExecuteTime());
        boolean bl = isEmptyPosition = Strings.isNullOrEmpty((String)entryPosition.getJournalName()) && entryPosition.getPosition() == null;
        if (!isEmptyPosition && (result &= entryPosition.getPosition().equals(header.getLogfileOffset()))) {
            result &= header.getLogfileName().equals(entryPosition.getJournalName());
        }
        return result;
    }
}

